/***************************************************************************
                          kwebget.h  -  description
                             -------------------
    begin                : Sun Apr 30 18:34:34 CEST 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWEBGET_H
#define KWEBGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kglobal.h>
#include <ktmainwindow.h>
#include <kmenubar.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kconfig.h>
#include <kiconloader.h>
//#include <kfiledialog.h>
#include <kprocess.h>

#include <qwidget.h>
#include <qaccel.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qtabwidget.h>
#include <qfiledialog.h>

#include "mainconf.h"
#include "optconf.h"
#include "fileconf.h"
#include "domainconf.h"
#include "passconf.h"
#include "proxyconf.h"
#include "scheduleconf.h"
#include "prefdialog.h"
#include "mydialog.h"
#include "outputwidget.h"
#include "kscheduleicon.h"
#include "statusdialog.h"

#include "wizard/kwgwizard.h"

class KWebGet : public KTMainWindow
{
  Q_OBJECT 
  public:
	/** construtor */
	KWebGet(QWidget *parent=0, const char* name=0);
	/** destructor */
	~KWebGet();

	/** StartApp **/
	void startApp();

	/** Startscreen **/
	void startView();
	
	/* Is the application started, or just the wizard ? */
	int start;

private:
	/* Some pics */
    QPixmap welPic, bgPic, bg2Pic;

    /** Widget for the startscreen **/
	QWidget *startShow;
	bool wizOnStartup;

	/* This will initialize the menuBar*/
    void initMenuBar();
		QPopupMenu *fileMenu, *optionsMenu, *wizMenu, *help_menu;

	/* This will initialize the toolBar*/
    void initToolBar();
		QPushButton *newBut, *openBut, *saveBut, *prevBut, *wizBut;

	/* Initialize the Main-Window */
	void initMainView();

	/* The Main-View */
	QTabWidget *mainTab;
	QWidget *mainConf, *optConf, *fileConf, *domainConf, *passConf,
			*proxyConf, *scheduleConf;
	QPushButton *startBut, *cancelBut;

	/* The Main-Configuration */
	void setMainConf();
	MainConf *mainFrame;
			
	/* The WGet-Options */
	void setOptConf();
	OptConf *optFrame;

	/* The File-Select Dialog */
	void setFileConf();
	FileConf *fileFrame;
		QButtonGroup *fileBox;
		QRadioButton *getAllTypes, *getSelTypes;

	/* The Domain-Select Dialog */
	void setDomainConf();
	DomainConf *domainFrame;
		QButtonGroup *domainBox;
		QRadioButton *getAllDomains, *getSelDomains;

	/* The Pass-Config Dialog */
	void setPassConf();
	PassConf *passFrame;
		QString email, emailUse;

	/* The Proxy-Config Dialog */
	void setProxyConf();
	ProxyConf *proxyFrame;
		QString defHttpProxyAdr, defHttpProxyPrt, defHttpProxyUsr, defHttpProxyPss,
				defFtpProxyAdr, defFtpProxyPrt;
		bool defhpr, htprlog, deffpr;

	/* The Scheduler Dialog */
	void setScheduleConf();
	ScheduleConf *scheduleFrame;
	
	/* The used protocol */
	QString prot;

	/* The Path to wget */
	QString wgetBin;

	/* Needed to call wget */
	const char* term;
	KShellProcess *wget, *turnOnProxy;
	QString getWgetOptions();
	void writeListFile();
	void letItRoll();
	QFile logFile;
	OutputWidget *outputWidget;
  	QDir projDir;
	QString wgetopt;

	/* Needed for the scheduler */
	KScheduleIcon *schedIcon;
	void prepareScheduler();
	int days[8], schedMonth;
	void startScheduler();
	void timerEvent(QTimerEvent *);
		int checkMinute();
		int checkHour();
		int checkDay();
		int checkMonth();
		StatusDialog *statusDialog;

	/* Needed for the output-window */
	char *iBuffer;
	QAccel *acc;

	/* Needed for the scheduler */
	int numself, scheduleTime, cnt, scheduleCount, schedNums, afterHour,
		schedHour, schedMinute;
	bool  scheduling;

	bool killed, writeLog, recBool, scrollIt;

	/* Needed for the testConf()-Slot */
	QString projName, saveName, home;
	QFileDialog *saveDialog;
	void writeConfig();
	KSimpleConfig *config;

	/* This checks, if the user has changed something and returns 0, if not, else 1*/
	int appChanged();

	// Everything needed to open an existing project
	QFileDialog *openDialog;

	/* Needed by the preferences-dialog */
	PrefDialog *prefDialog;
	
	/* This opens the dialog, that will ask for the wizard to be stated */
	void wizStartQuest();
	MyDialog *wizQuest;

	/* The wizard */
	KWGWizard *wizard;


	// The close Event
	void closeEvent(QCloseEvent*);

private slots:
    // Funktion, that is called after the startscreen
	void timerStoped();

    // Function, to initialize the MainScreen
    void initView();

	/* Everything that can be called by the MenuBar/ToolBar */
	void newProject();
	int closeProject();
	void openFile();

	/* This will check, that everything is ok ... */
	int testConf();

	void saveFileAs();
	void quitApp();
	void prefMenu();
	void startWizard();
	
	/* This will change the Caption to the Project name */
	void setCaptionText(const QString &);

	/* This will start wget, if everything is ok (called by the start-Button) */
	void startWGet();

	/* Slot for the FileSelect-Dialog */
	void getAllFileTypes();

	/* Slot for the DomainSelect-Dialog */
	void getALLDomains();

	/* Gets the used protocol */
	void getProt(int);

	/* If (not) only one file to download ... */
	void enableFileTypes();
	void disableFileTypes();

	/* The option, to use anon ftp */
	void setFtpAnon();

	/* The Slots, needed by the preferences menu */
	void prefCancel();
	void prefOk();
	void prefOkApply();

	/* These slots are used for the start question */
	void showWizQuestApply();
	void showWizQuestCancel();
	void showWizQuestSave();

	/* Required for the wizard */
	void quitWizard();
	void getWizSet();

	/* The Slots of the scheduler */
	void cancelScheduler();
	void showSchedInfo();
	void showSchedOutput();

	/* Required by wget */
	void giveBackStdoutErr(KProcess *, char *, int);
	void cancelWget();
	void dismissWget();
	void wgetReady(KProcess *);
	void autoScroll();
};

#endif