"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShakeBox = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const React = __importStar(require("react"));
exports.ShakeBox = React.forwardRef(({ children, amplitude = 8, damping = 0.75, speed = 4, threshold = 1 }, ref) => {
    const [offset, setOffset] = (0, react_1.useState)(0);
    let requestAnimationId = 0;
    const shakeLoop = (targetOffset, currentOffset = 0) => {
        if (targetOffset > 0 && currentOffset < targetOffset) {
            currentOffset += speed;
        }
        else if (targetOffset < 0 && currentOffset > targetOffset) {
            currentOffset -= speed;
        }
        else {
            currentOffset = targetOffset - (currentOffset - targetOffset);
            targetOffset *= -damping;
        }
        if (Math.abs(targetOffset) >= threshold) {
            requestAnimationId = requestAnimationFrame(() => shakeLoop(targetOffset, currentOffset));
        }
        else {
            currentOffset = 0;
        }
        setOffset(currentOffset);
    };
    (0, react_1.useImperativeHandle)(ref, () => ({
        shake: () => {
            cancelAnimationFrame(requestAnimationId);
            shakeLoop(amplitude);
        },
    }));
    (0, react_1.useEffect)(() => () => cancelAnimationFrame(requestAnimationId), []);
    return (0, jsx_runtime_1.jsx)("div", Object.assign({ css: { transform: `translateX(${offset}px)` } }, { children: children }));
});
exports.ShakeBox.displayName = 'ShakeBox';
