"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Modal = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const color_1 = __importDefault(require("color"));
const Overlay_1 = require("./Overlay");
const Icon_1 = require("../Icon");
const Identity_1 = require("../Identity");
const mediaQueries_1 = require("../mediaQueries");
const util_1 = require("../util");
const modalBodyStyle = (theme, { fullscreen = false }) => ({
    alignItems: 'center',
    backgroundColor: theme.general.backgroundColor,
    borderRadius: fullscreen ? 0 : '8px',
    bottom: fullscreen ? 0 : undefined,
    boxShadow: fullscreen ? 'none' : '0 16px 64px 0 rgba(0, 0, 0, 0.16)',
    display: 'flex',
    flexDirection: 'column',
    justifyContent: fullscreen ? 'center' : 'space-between',
    left: fullscreen ? 0 : undefined,
    margin: 'auto',
    position: fullscreen ? 'fixed' : 'relative',
    right: fullscreen ? 0 : undefined,
    top: fullscreen ? 0 : undefined,
    transform: 'translate3d(0, 0, 0)',
    zIndex: 9999,
    [mediaQueries_1.media[mediaQueries_1.QueryKeys.TABLET_DOWN]]: {
        width: fullscreen ? 'initial' : '100%',
    },
});
const filterModalBodyProps = (props) => (0, util_1.filterProps)(props, ['fullscreen']);
const ModalBody = (props) => ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: (theme) => modalBodyStyle(theme, props) }, filterModalBodyProps(props))));
const ModalClose = (props) => ((0, jsx_runtime_1.jsx)(Icon_1.CloseIcon, Object.assign({ width: 16, height: 16, css: {
        alignItems: 'center',
        cursor: 'pointer',
        display: 'flex',
        justifyContent: 'center',
        position: 'absolute',
        right: 16,
        top: 16,
    } }, props)));
const ModalContent = props => ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: {
        maxWidth: '100%',
        overflowY: 'auto',
        padding: '40px',
    } }, props)));
const modalBackgroundStyle = props => (Object.assign(Object.assign({}, (0, Overlay_1.overlayBackgroundStyle)(props)), { backgroundColor: 'rgba(50, 54, 57, 0.4)' }));
const ModalBackground = (props) => (0, jsx_runtime_1.jsx)("div", Object.assign({ css: modalBackgroundStyle(props) }, props));
const modalActionsWrapperStyles = () => ({
    borderTop: `1px solid ${Identity_1.COLOR.GRAY_LIGHTEN_72}`,
    bottom: 0,
    display: 'flex',
    div: {
        '&:hover': {
            backgroundColor: Identity_1.COLOR.opaque(Identity_1.COLOR.GRAY_DARKEN_72, 0.04),
        },
        '&:active': {
            backgroundColor: Identity_1.COLOR.opaque(Identity_1.COLOR.GRAY_DARKEN_72, 0.08),
        },
        borderRight: `1px solid ${Identity_1.COLOR.GRAY_LIGHTEN_72}`,
    },
    'div:first-child': {
        borderBottomLeftRadius: 8,
    },
    'div:last-child': {
        borderBottomRightRadius: 8,
        borderRight: 0,
    },
    position: 'absolute',
    width: '100%',
});
const modalActionStyles = ({ bold }) => ({
    '&:hover': {
        color: (0, color_1.default)(Identity_1.COLOR.BLUE).mix((0, color_1.default)(Identity_1.COLOR.BLACK), 0.16).toString(),
    },
    color: Identity_1.COLOR.BLUE,
    cursor: 'pointer',
    display: 'flex',
    flex: 1,
    fontWeight: bold ? 'bold' : 'normal',
    justifyContent: 'center',
    padding: '8px 0',
});
const ModalActions = ({ actions }) => ((0, jsx_runtime_1.jsx)("div", Object.assign({ css: modalActionsWrapperStyles() }, { children: actions.map(action => ((0, jsx_runtime_1.jsx)("div", Object.assign({ onClick: action.onClick, css: modalActionStyles({ bold: action.bold }), "data-uie-name": action.dataUieName }, { children: action.title }), action.title))) })));
const Modal = (_a) => {
    var { actions = [], children, bodyStyle, fullscreen, onClose, onBackgroundClick } = _a, props = __rest(_a, ["actions", "children", "bodyStyle", "fullscreen", "onClose", "onBackgroundClick"]);
    return ((0, jsx_runtime_1.jsxs)(Overlay_1.OverlayWrapper, Object.assign({}, props, { "data-uie-name": "modal" }, { children: [(0, jsx_runtime_1.jsxs)(ModalBody, Object.assign({ fullscreen: fullscreen, style: bodyStyle }, { children: [(0, jsx_runtime_1.jsx)(ModalContent, { children: children }), onClose !== util_1.noop && (0, jsx_runtime_1.jsx)(ModalClose, { onClick: onClose, "data-uie-name": "do-close" }), actions.length > 0 && (0, jsx_runtime_1.jsx)(ModalActions, { actions: actions, "data-uie-name": "modal-actions" })] })), !fullscreen && ((0, jsx_runtime_1.jsx)(ModalBackground, { onClick: onBackgroundClick === util_1.noop ? onClose : onBackgroundClick, "data-uie-name": "modal-background" }))] })));
};
exports.Modal = Modal;
exports.Modal.defaultProps = {
    actions: [],
    fullscreen: false,
    onBackgroundClick: util_1.noop,
    onClose: util_1.noop,
};
