/* installer.c generated by valac 0.56.18, the Vala compiler
 * generated from installer.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2014-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <pamac.h>
#include "pamac-gtk.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <adwaita.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <stdio.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_INSTALLER (pamac_installer_get_type ())
#define PAMAC_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_INSTALLER, PamacInstaller))
#define PAMAC_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_INSTALLER, PamacInstallerClass))
#define PAMAC_IS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_INSTALLER))
#define PAMAC_IS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_INSTALLER))
#define PAMAC_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_INSTALLER, PamacInstallerClass))

typedef struct _PamacInstaller PamacInstaller;
typedef struct _PamacInstallerClass PamacInstallerClass;
typedef struct _PamacInstallerPrivate PamacInstallerPrivate;

#define PAMAC_TYPE_PROGRESS_DIALOG (pamac_progress_dialog_get_type ())
#define PAMAC_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_PROGRESS_DIALOG, PamacProgressDialog))
#define PAMAC_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_PROGRESS_DIALOG, PamacProgressDialogClass))
#define PAMAC_IS_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_PROGRESS_DIALOG))
#define PAMAC_IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_PROGRESS_DIALOG))
#define PAMAC_PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_PROGRESS_DIALOG, PamacProgressDialogClass))

typedef struct _PamacProgressDialog PamacProgressDialog;
typedef struct _PamacProgressDialogClass PamacProgressDialogClass;
enum  {
	PAMAC_INSTALLER_0_PROPERTY,
	PAMAC_INSTALLER_NUM_PROPERTIES
};
static GParamSpec* pamac_installer_properties[PAMAC_INSTALLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PamacProgressDialogPrivate PamacProgressDialogPrivate;
typedef struct _Block1Data Block1Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PamacInstaller {
	GtkApplication parent_instance;
	PamacInstallerPrivate * priv;
};

struct _PamacInstallerClass {
	GtkApplicationClass parent_class;
};

struct _PamacInstallerPrivate {
	GApplicationCommandLine* cmd;
	PamacDatabase* database;
	PamacTransactionGtk* transaction;
	PamacProgressDialog* progress_dialog;
	gboolean important_details;
	gboolean waiting;
	gboolean cancelled;
};

struct _PamacProgressDialog {
	GtkApplicationWindow parent_instance;
	PamacProgressDialogPrivate * priv;
	GtkBox* box;
	GtkButton* close_button;
	GtkButton* cancel_button;
	GtkExpander* expander;
};

struct _PamacProgressDialogClass {
	GtkApplicationWindowClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	PamacInstaller* self;
	GApplicationCommandLine* cmd;
};

static gint PamacInstaller_private_offset;
static gpointer pamac_installer_parent_class = NULL;

VALA_EXTERN GType pamac_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacInstaller, g_object_unref)
VALA_EXTERN GType pamac_progress_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacProgressDialog, g_object_unref)
VALA_EXTERN PamacInstaller* pamac_installer_new (void);
VALA_EXTERN PamacInstaller* pamac_installer_construct (GType object_type);
static void pamac_installer_real_startup (GApplication* base);
VALA_EXTERN PamacProgressDialog* pamac_progress_dialog_new (GtkApplication* application);
VALA_EXTERN PamacProgressDialog* pamac_progress_dialog_construct (GType object_type,
                                                      GtkApplication* application);
static void pamac_installer_on_start_waiting (PamacInstaller* self);
static void _pamac_installer_on_start_waiting_pamac_transaction_start_waiting (PamacTransaction* _sender,
                                                                        gpointer self);
static void pamac_installer_on_stop_waiting (PamacInstaller* self);
static void _pamac_installer_on_stop_waiting_pamac_transaction_stop_waiting (PamacTransaction* _sender,
                                                                      gpointer self);
static void pamac_installer_on_start_preparing (PamacInstaller* self);
static void _pamac_installer_on_start_preparing_pamac_transaction_start_preparing (PamacTransaction* _sender,
                                                                            gpointer self);
static void pamac_installer_on_stop_preparing (PamacInstaller* self);
static void _pamac_installer_on_stop_preparing_pamac_transaction_stop_preparing (PamacTransaction* _sender,
                                                                          gpointer self);
static void pamac_installer_on_start_downloading (PamacInstaller* self);
static void _pamac_installer_on_start_downloading_pamac_transaction_start_downloading (PamacTransaction* _sender,
                                                                                gpointer self);
static void pamac_installer_on_stop_downloading (PamacInstaller* self);
static void _pamac_installer_on_stop_downloading_pamac_transaction_stop_downloading (PamacTransaction* _sender,
                                                                              gpointer self);
static void pamac_installer_on_important_details_outpout (PamacInstaller* self,
                                                   gboolean must_show);
static void _pamac_installer_on_important_details_outpout_pamac_transaction_important_details_outpout (PamacTransaction* _sender,
                                                                                                gboolean must_show,
                                                                                                gpointer self);
static void pamac_installer_on_close_button_clicked (PamacInstaller* self);
static void _pamac_installer_on_close_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static void pamac_installer_on_cancel_button_clicked (PamacInstaller* self);
static void _pamac_installer_on_cancel_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static gint pamac_installer_real_command_line (GApplication* base,
                                        GApplicationCommandLine* cmd);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _g_free0_ (gpointer var);
static void pamac_installer_display_help (PamacInstaller* self);
static gboolean pamac_installer_check_build_pkgs (PamacInstaller* self,
                                           GPtrArray* targets);
static void ___lambda4_ (Block1Data* _data1_,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda4__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void pamac_installer_real_shutdown (GApplication* base);
static gboolean pamac_installer_check_pamac_running (PamacInstaller* self);
static gint pamac_installer_main (gchar** args,
                           gint args_length1);
static void pamac_installer_finalize (GObject * obj);
static GType pamac_installer_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
pamac_installer_get_instance_private (PamacInstaller* self)
{
	return G_STRUCT_MEMBER_P (self, PamacInstaller_private_offset);
}

PamacInstaller*
pamac_installer_construct (GType object_type)
{
	PamacInstaller * self = NULL;
	GApplicationFlags _tmp0_;
	GApplicationFlags _tmp1_;
	self = (PamacInstaller*) g_object_new (object_type, NULL);
	g_application_set_application_id ((GApplication*) self, "org.manjaro.pamac.installer");
	_tmp0_ = g_application_get_flags ((GApplication*) self);
	_tmp1_ = _tmp0_;
	g_application_set_flags ((GApplication*) self, _tmp1_ | G_APPLICATION_HANDLES_COMMAND_LINE);
	return self;
}

PamacInstaller*
pamac_installer_new (void)
{
	return pamac_installer_construct (PAMAC_TYPE_INSTALLER);
}

static void
_pamac_installer_on_start_waiting_pamac_transaction_start_waiting (PamacTransaction* _sender,
                                                                   gpointer self)
{
	pamac_installer_on_start_waiting ((PamacInstaller*) self);
}

static void
_pamac_installer_on_stop_waiting_pamac_transaction_stop_waiting (PamacTransaction* _sender,
                                                                 gpointer self)
{
	pamac_installer_on_stop_waiting ((PamacInstaller*) self);
}

static void
_pamac_installer_on_start_preparing_pamac_transaction_start_preparing (PamacTransaction* _sender,
                                                                       gpointer self)
{
	pamac_installer_on_start_preparing ((PamacInstaller*) self);
}

static void
_pamac_installer_on_stop_preparing_pamac_transaction_stop_preparing (PamacTransaction* _sender,
                                                                     gpointer self)
{
	pamac_installer_on_stop_preparing ((PamacInstaller*) self);
}

static void
_pamac_installer_on_start_downloading_pamac_transaction_start_downloading (PamacTransaction* _sender,
                                                                           gpointer self)
{
	pamac_installer_on_start_downloading ((PamacInstaller*) self);
}

static void
_pamac_installer_on_stop_downloading_pamac_transaction_stop_downloading (PamacTransaction* _sender,
                                                                         gpointer self)
{
	pamac_installer_on_stop_downloading ((PamacInstaller*) self);
}

static void
_pamac_installer_on_important_details_outpout_pamac_transaction_important_details_outpout (PamacTransaction* _sender,
                                                                                           gboolean must_show,
                                                                                           gpointer self)
{
	pamac_installer_on_important_details_outpout ((PamacInstaller*) self, must_show);
}

static void
_pamac_installer_on_close_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	pamac_installer_on_close_button_clicked ((PamacInstaller*) self);
}

static void
_pamac_installer_on_cancel_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	pamac_installer_on_cancel_button_clicked ((PamacInstaller*) self);
}

static void
pamac_installer_real_startup (GApplication* base)
{
	PamacInstaller * self;
	PamacConfig* config = NULL;
	PamacConfig* _tmp0_;
	PamacDatabase* _tmp1_;
	PamacLocalConfig* local_config = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	PamacLocalConfig* _tmp5_;
	PamacLocalConfig* _tmp6_;
	PamacProgressDialog* _tmp7_;
	GDesktopAppInfo* appinfo = NULL;
	GDesktopAppInfo* _tmp8_;
	PamacProgressDialog* _tmp9_;
	const gchar* _tmp10_;
	PamacDatabase* _tmp11_;
	PamacTransactionGtk* _tmp12_;
	PamacTransactionGtk* _tmp13_;
	PamacTransactionGtk* _tmp14_;
	PamacTransactionGtk* _tmp15_;
	PamacTransactionGtk* _tmp16_;
	PamacTransactionGtk* _tmp17_;
	PamacTransactionGtk* _tmp18_;
	PamacTransactionGtk* _tmp19_;
	PamacProgressDialog* _tmp20_;
	GtkBox* _tmp21_;
	PamacTransactionGtk* _tmp22_;
	PamacProgressBox* _tmp23_;
	PamacTransactionGtk* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	PamacProgressDialog* _tmp26_;
	GtkExpander* _tmp27_;
	PamacTransactionGtk* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	PamacProgressDialog* _tmp30_;
	GtkButton* _tmp31_;
	PamacProgressDialog* _tmp32_;
	GtkButton* _tmp33_;
	self = (PamacInstaller*) base;
	textdomain ("pamac");
	setlocale (LC_ALL, "");
	G_APPLICATION_CLASS (pamac_installer_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	adw_init ();
	self->priv->important_details = FALSE;
	self->priv->waiting = FALSE;
	self->priv->cancelled = FALSE;
	_tmp0_ = pamac_config_new ("/etc/pamac.conf");
	config = _tmp0_;
	pamac_config_set_recurse (config, FALSE);
	_tmp1_ = pamac_database_new (config);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp1_;
	_tmp2_ = g_get_user_config_dir ();
	_tmp3_ = g_strdup_printf ("%s/pamac/config", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = pamac_local_config_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	local_config = _tmp6_;
	pamac_local_config_set_software_mode (local_config, FALSE);
	_tmp7_ = pamac_progress_dialog_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->progress_dialog);
	self->priv->progress_dialog = _tmp7_;
	_tmp8_ = g_desktop_app_info_new ("pamac-installer.desktop");
	appinfo = _tmp8_;
	_tmp9_ = self->priv->progress_dialog;
	_tmp10_ = g_app_info_get_name ((GAppInfo*) appinfo);
	gtk_window_set_title ((GtkWindow*) _tmp9_, _tmp10_);
	_tmp11_ = self->priv->database;
	_tmp12_ = pamac_transaction_gtk_new (_tmp11_, local_config, (GtkApplication*) self);
	_g_object_unref0 (self->priv->transaction);
	self->priv->transaction = _tmp12_;
	_tmp13_ = self->priv->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp13_, "start-waiting", (GCallback) _pamac_installer_on_start_waiting_pamac_transaction_start_waiting, self, 0);
	_tmp14_ = self->priv->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp14_, "stop-waiting", (GCallback) _pamac_installer_on_stop_waiting_pamac_transaction_stop_waiting, self, 0);
	_tmp15_ = self->priv->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp15_, "start-preparing", (GCallback) _pamac_installer_on_start_preparing_pamac_transaction_start_preparing, self, 0);
	_tmp16_ = self->priv->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp16_, "stop-preparing", (GCallback) _pamac_installer_on_stop_preparing_pamac_transaction_stop_preparing, self, 0);
	_tmp17_ = self->priv->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp17_, "start-downloading", (GCallback) _pamac_installer_on_start_downloading_pamac_transaction_start_downloading, self, 0);
	_tmp18_ = self->priv->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp18_, "stop-downloading", (GCallback) _pamac_installer_on_stop_downloading_pamac_transaction_stop_downloading, self, 0);
	_tmp19_ = self->priv->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp19_, "important-details-outpout", (GCallback) _pamac_installer_on_important_details_outpout_pamac_transaction_important_details_outpout, self, 0);
	_tmp20_ = self->priv->progress_dialog;
	_tmp21_ = _tmp20_->box;
	_tmp22_ = self->priv->transaction;
	_tmp23_ = _tmp22_->progress_box;
	gtk_box_prepend (_tmp21_, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->transaction;
	_tmp25_ = _tmp24_->details_window;
	g_object_set ((GtkWidget*) _tmp25_, "height-request", 200, NULL);
	_tmp26_ = self->priv->progress_dialog;
	_tmp27_ = _tmp26_->expander;
	_tmp28_ = self->priv->transaction;
	_tmp29_ = _tmp28_->details_window;
	gtk_expander_set_child (_tmp27_, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->progress_dialog;
	_tmp31_ = _tmp30_->close_button;
	g_signal_connect_object (_tmp31_, "clicked", (GCallback) _pamac_installer_on_close_button_clicked_gtk_button_clicked, self, 0);
	_tmp32_ = self->priv->progress_dialog;
	_tmp33_ = _tmp32_->cancel_button;
	g_signal_connect_object (_tmp33_, "clicked", (GCallback) _pamac_installer_on_cancel_button_clicked_gtk_button_clicked, self, 0);
	_g_object_unref0 (appinfo);
	_g_object_unref0 (local_config);
	_g_object_unref0 (config);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PamacInstaller* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->cmd);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
___lambda4_ (Block1Data* _data1_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacInstaller* self;
	gboolean success = FALSE;
	PamacTransactionGtk* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->transaction;
	success = pamac_transaction_run_finish ((PamacTransaction*) _tmp0_, res);
	if (!success) {
		PamacTransactionGtk* _tmp4_;
		_tmp4_ = self->priv->transaction;
		_tmp3_ = _tmp4_->commit_transaction_answer;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = !self->priv->cancelled;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->important_details;
	}
	if (_tmp1_) {
		PamacProgressDialog* _tmp5_;
		GtkExpander* _tmp6_;
		PamacProgressDialog* _tmp7_;
		GtkButton* _tmp8_;
		_tmp5_ = self->priv->progress_dialog;
		_tmp6_ = _tmp5_->expander;
		gtk_expander_set_expanded (_tmp6_, TRUE);
		_tmp7_ = self->priv->progress_dialog;
		_tmp8_ = _tmp7_->close_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp8_, TRUE);
	} else {
		g_application_release ((GApplication*) self);
	}
	if (!success) {
		g_application_command_line_set_exit_status (_data1_->cmd, 1);
	}
}

static void
____lambda4__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda4_ (self, source_object, res);
	block1_data_unref (self);
}

static gint
pamac_installer_real_command_line (GApplication* base,
                                   GApplicationCommandLine* cmd)
{
	PamacInstaller * self;
	Block1Data* _data1_;
	GApplicationCommandLine* _tmp0_;
	GApplicationCommandLine* _tmp1_;
	gchar** args = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint args_length1;
	gint _args_size_;
	GPtrArray* to_install = NULL;
	GPtrArray* _tmp4_;
	GPtrArray* to_remove = NULL;
	GPtrArray* _tmp5_;
	GPtrArray* to_load = NULL;
	GPtrArray* _tmp6_;
	GPtrArray* to_build = NULL;
	GPtrArray* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	GPtrArray* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gint result;
	self = (PamacInstaller*) base;
	g_return_val_if_fail (cmd != NULL, 0);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (cmd);
	_g_object_unref0 (_data1_->cmd);
	_data1_->cmd = _tmp0_;
	_tmp1_ = _g_object_ref0 (_data1_->cmd);
	_g_object_unref0 (self->priv->cmd);
	self->priv->cmd = _tmp1_;
	_tmp3_ = g_application_command_line_get_arguments (_data1_->cmd, &_tmp2_);
	args = _tmp3_;
	args_length1 = _tmp2_;
	_args_size_ = args_length1;
	_tmp4_ = g_ptr_array_new_full ((guint) 0, NULL);
	to_install = _tmp4_;
	_tmp5_ = g_ptr_array_new_full ((guint) 0, NULL);
	to_remove = _tmp5_;
	_tmp6_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	to_load = _tmp6_;
	_tmp7_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	to_build = _tmp7_;
	_tmp8_ = args;
	_tmp8__length1 = args_length1;
	if (_tmp8__length1 == 1) {
		pamac_installer_display_help (self);
		g_application_release ((GApplication*) self);
		result = g_application_command_line_get_exit_status (_data1_->cmd);
		_g_ptr_array_unref0 (to_build);
		_g_ptr_array_unref0 (to_load);
		_g_ptr_array_unref0 (to_remove);
		_g_ptr_array_unref0 (to_install);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp10_ = args;
	_tmp10__length1 = args_length1;
	_tmp11_ = _tmp10_[1];
	if (g_strcmp0 (_tmp11_, "--help") == 0) {
		_tmp9_ = TRUE;
	} else {
		gchar** _tmp12_;
		gint _tmp12__length1;
		const gchar* _tmp13_;
		_tmp12_ = args;
		_tmp12__length1 = args_length1;
		_tmp13_ = _tmp12_[1];
		_tmp9_ = g_strcmp0 (_tmp13_, "-h") == 0;
	}
	if (_tmp9_) {
		pamac_installer_display_help (self);
		g_application_release ((GApplication*) self);
		result = g_application_command_line_get_exit_status (_data1_->cmd);
		_g_ptr_array_unref0 (to_build);
		_g_ptr_array_unref0 (to_load);
		_g_ptr_array_unref0 (to_remove);
		_g_ptr_array_unref0 (to_install);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	} else {
		gboolean add_to_remove = FALSE;
		gboolean add_to_build = FALSE;
		gint i = 0;
		add_to_remove = FALSE;
		add_to_build = FALSE;
		i = 1;
		while (TRUE) {
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* target = NULL;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gint _tmp46_;
			_tmp14_ = args;
			_tmp14__length1 = args_length1;
			if (!(i < _tmp14__length1)) {
				break;
			}
			_tmp15_ = args;
			_tmp15__length1 = args_length1;
			_tmp16_ = _tmp15_[i];
			target = _tmp16_;
			_tmp17_ = target;
			if (g_strcmp0 (_tmp17_, "--remove") == 0) {
				add_to_remove = TRUE;
				add_to_build = FALSE;
			} else {
				const gchar* _tmp18_;
				_tmp18_ = target;
				if (g_strcmp0 (_tmp18_, "--build") == 0) {
					add_to_build = TRUE;
					add_to_remove = FALSE;
				} else {
					if (add_to_remove) {
						GPtrArray* _tmp19_;
						const gchar* _tmp20_;
						_tmp19_ = to_remove;
						_tmp20_ = target;
						g_ptr_array_add (_tmp19_, _tmp20_);
					} else {
						if (add_to_build) {
							GPtrArray* _tmp21_;
							const gchar* _tmp22_;
							gchar* _tmp23_;
							_tmp21_ = to_build;
							_tmp22_ = target;
							_tmp23_ = g_strdup (_tmp22_);
							g_ptr_array_add (_tmp21_, _tmp23_);
						} else {
							const gchar* _tmp24_;
							_tmp24_ = target;
							if (string_contains (_tmp24_, ".pkg.tar")) {
								const gchar* _tmp25_;
								_tmp25_ = target;
								if (string_contains (_tmp25_, "://")) {
									const gchar* _tmp26_;
									_tmp26_ = target;
									if (string_contains (_tmp26_, "file://")) {
										GFile* file = NULL;
										const gchar* _tmp27_;
										GFile* _tmp28_;
										gchar* absolute_path = NULL;
										GFile* _tmp29_;
										gchar* _tmp30_;
										const gchar* _tmp31_;
										_tmp27_ = target;
										_tmp28_ = g_file_new_for_uri (_tmp27_);
										file = _tmp28_;
										_tmp29_ = file;
										_tmp30_ = g_file_get_path (_tmp29_);
										absolute_path = _tmp30_;
										_tmp31_ = absolute_path;
										if (_tmp31_ != NULL) {
											GPtrArray* _tmp32_;
											gchar* _tmp33_;
											_tmp32_ = to_load;
											_tmp33_ = absolute_path;
											absolute_path = NULL;
											g_ptr_array_add (_tmp32_, _tmp33_);
										}
										_g_free0 (absolute_path);
										_g_object_unref0 (file);
									} else {
										GPtrArray* _tmp34_;
										const gchar* _tmp35_;
										gchar* _tmp36_;
										_tmp34_ = to_load;
										_tmp35_ = target;
										_tmp36_ = g_strdup (_tmp35_);
										g_ptr_array_add (_tmp34_, _tmp36_);
									}
								} else {
									GFile* file = NULL;
									const gchar* _tmp37_;
									GFile* _tmp38_;
									gchar* absolute_path = NULL;
									GFile* _tmp39_;
									gchar* _tmp40_;
									const gchar* _tmp41_;
									_tmp37_ = target;
									_tmp38_ = g_file_new_for_path (_tmp37_);
									file = _tmp38_;
									_tmp39_ = file;
									_tmp40_ = g_file_get_path (_tmp39_);
									absolute_path = _tmp40_;
									_tmp41_ = absolute_path;
									if (_tmp41_ != NULL) {
										GPtrArray* _tmp42_;
										gchar* _tmp43_;
										_tmp42_ = to_load;
										_tmp43_ = absolute_path;
										absolute_path = NULL;
										g_ptr_array_add (_tmp42_, _tmp43_);
									}
									_g_free0 (absolute_path);
									_g_object_unref0 (file);
								}
							} else {
								GPtrArray* _tmp44_;
								const gchar* _tmp45_;
								_tmp44_ = to_install;
								_tmp45_ = target;
								g_ptr_array_add (_tmp44_, _tmp45_);
							}
						}
					}
				}
			}
			_tmp46_ = i;
			i = _tmp46_ + 1;
		}
	}
	_tmp50_ = to_install;
	_tmp51_ = vala_g_ptr_array_get_length (_tmp50_);
	_tmp52_ = _tmp51_;
	if (_tmp52_ == 0) {
		GPtrArray* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		_tmp53_ = to_load;
		_tmp54_ = vala_g_ptr_array_get_length (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp49_ = _tmp55_ == 0;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		GPtrArray* _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		_tmp56_ = to_build;
		_tmp57_ = vala_g_ptr_array_get_length (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp48_ = _tmp58_ == 0;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		GPtrArray* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		_tmp59_ = to_remove;
		_tmp60_ = vala_g_ptr_array_get_length (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp47_ = _tmp61_ == 0;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		FILE* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		_tmp62_ = stdout;
		_tmp63_ = g_strconcat (g_dgettext (NULL, "Nothing to do"), ".\n", NULL);
		_tmp64_ = _tmp63_;
		fprintf (_tmp62_, "%s", _tmp64_);
		_g_free0 (_tmp64_);
	} else {
		GPtrArray* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		GPtrArray* _tmp72_;
		GPtrArray* _tmp75_;
		GPtrArray* _tmp78_;
		PamacProgressDialog* _tmp81_;
		GtkButton* _tmp82_;
		PamacProgressDialog* _tmp83_;
		GtkButton* _tmp84_;
		PamacProgressDialog* _tmp85_;
		PamacTransactionGtk* _tmp86_;
		_tmp65_ = to_build;
		_tmp66_ = vala_g_ptr_array_get_length (_tmp65_);
		_tmp67_ = _tmp66_;
		if (_tmp67_ > 0) {
			gboolean success = FALSE;
			GPtrArray* _tmp68_;
			_tmp68_ = to_build;
			success = pamac_installer_check_build_pkgs (self, _tmp68_);
			if (success) {
				GPtrArray* _tmp69_;
				_tmp69_ = to_build;
				{
					GPtrArray* name_collection = NULL;
					guint name_index = 0U;
					name_collection = _tmp69_;
					for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
						const gchar* name = NULL;
						name = (const gchar*) g_ptr_array_index (name_collection, name_index);
						{
							PamacTransactionGtk* _tmp70_;
							const gchar* _tmp71_;
							_tmp70_ = self->priv->transaction;
							_tmp71_ = name;
							pamac_transaction_add_pkg_to_build ((PamacTransaction*) _tmp70_, _tmp71_, TRUE, TRUE);
						}
					}
				}
			} else {
				g_application_release ((GApplication*) self);
				result = 1;
				_g_ptr_array_unref0 (to_build);
				_g_ptr_array_unref0 (to_load);
				_g_ptr_array_unref0 (to_remove);
				_g_ptr_array_unref0 (to_install);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				block1_data_unref (_data1_);
				_data1_ = NULL;
				return result;
			}
		}
		_tmp72_ = to_install;
		{
			GPtrArray* name_collection = NULL;
			guint name_index = 0U;
			name_collection = _tmp72_;
			for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
				const gchar* name = NULL;
				name = (const gchar*) g_ptr_array_index (name_collection, name_index);
				{
					PamacTransactionGtk* _tmp73_;
					const gchar* _tmp74_;
					_tmp73_ = self->priv->transaction;
					_tmp74_ = name;
					pamac_transaction_add_pkg_to_install ((PamacTransaction*) _tmp73_, _tmp74_);
				}
			}
		}
		_tmp75_ = to_remove;
		{
			GPtrArray* name_collection = NULL;
			guint name_index = 0U;
			name_collection = _tmp75_;
			for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
				const gchar* name = NULL;
				name = (const gchar*) g_ptr_array_index (name_collection, name_index);
				{
					PamacTransactionGtk* _tmp76_;
					const gchar* _tmp77_;
					_tmp76_ = self->priv->transaction;
					_tmp77_ = name;
					pamac_transaction_add_pkg_to_remove ((PamacTransaction*) _tmp76_, _tmp77_);
				}
			}
		}
		_tmp78_ = to_load;
		{
			GPtrArray* path_collection = NULL;
			guint path_index = 0U;
			path_collection = _tmp78_;
			for (path_index = 0; path_index < path_collection->len; path_index = path_index + 1) {
				const gchar* path = NULL;
				path = (const gchar*) g_ptr_array_index (path_collection, path_index);
				{
					PamacTransactionGtk* _tmp79_;
					const gchar* _tmp80_;
					_tmp79_ = self->priv->transaction;
					_tmp80_ = path;
					pamac_transaction_add_path_to_load ((PamacTransaction*) _tmp79_, _tmp80_);
				}
			}
		}
		_tmp81_ = self->priv->progress_dialog;
		_tmp82_ = _tmp81_->cancel_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp82_, FALSE);
		_tmp83_ = self->priv->progress_dialog;
		_tmp84_ = _tmp83_->close_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp84_, FALSE);
		_tmp85_ = self->priv->progress_dialog;
		gtk_widget_show ((GtkWidget*) _tmp85_);
		_tmp86_ = self->priv->transaction;
		pamac_transaction_run_async ((PamacTransaction*) _tmp86_, ____lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	}
	result = g_application_command_line_get_exit_status (_data1_->cmd);
	_g_ptr_array_unref0 (to_build);
	_g_ptr_array_unref0 (to_load);
	_g_ptr_array_unref0 (to_remove);
	_g_ptr_array_unref0 (to_install);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static gboolean
pamac_installer_check_build_pkgs (PamacInstaller* self,
                                  GPtrArray* targets)
{
	GHashTable* aur_pkgs = NULL;
	PamacDatabase* _tmp0_;
	GHashTable* _tmp1_;
	GHashTableIter iter = {0};
	GHashTable* _tmp2_;
	const gchar* pkgname = NULL;
	PamacAURPackage* aur_pkg = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (targets != NULL, FALSE);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_aur_pkgs (_tmp0_, targets);
	aur_pkgs = _tmp1_;
	_tmp2_ = aur_pkgs;
	g_hash_table_iter_init (&iter, _tmp2_);
	while (TRUE) {
		gconstpointer _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gboolean _tmp5_;
		PamacAURPackage* _tmp6_;
		_tmp5_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp3_), (gpointer*) (&_tmp4_));
		pkgname = (const gchar*) _tmp3_;
		aur_pkg = (PamacAURPackage*) _tmp4_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = aur_pkg;
		if (_tmp6_ == NULL) {
			GPtrArray* details = NULL;
			GPtrArray* _tmp7_;
			GPtrArray* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			PamacTransactionGtk* _tmp11_;
			GPtrArray* _tmp12_;
			_tmp7_ = g_ptr_array_new_full ((guint) 1, _g_free0_);
			details = _tmp7_;
			_tmp8_ = details;
			_tmp9_ = pkgname;
			_tmp10_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp9_);
			g_ptr_array_add (_tmp8_, _tmp10_);
			_tmp11_ = self->priv->transaction;
			_tmp12_ = details;
			pamac_transaction_gtk_display_error (_tmp11_, g_dgettext (NULL, "Failed to prepare transaction"), _tmp12_);
			result = FALSE;
			_g_ptr_array_unref0 (details);
			_g_hash_table_unref0 (aur_pkgs);
			return result;
		}
	}
	result = TRUE;
	_g_hash_table_unref0 (aur_pkgs);
	return result;
}

static void
pamac_installer_display_help (PamacInstaller* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	FILE* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Install packages from repositories, path or url"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n");
	_tmp2_ = stdout;
	fprintf (_tmp2_, "%s", g_dgettext (NULL, "Remove packages"));
	_tmp3_ = stdout;
	fprintf (_tmp3_, "\n");
	_tmp4_ = stdout;
	fprintf (_tmp4_, "%s", g_dgettext (NULL, "Build packages from AUR and install them with their dependencies"));
	_tmp5_ = stdout;
	fprintf (_tmp5_, "\n\n");
	_tmp6_ = stdout;
	_tmp7_ = g_strdup_printf ("pamac-installer [%s] [--remove] [%s] [--build] [%s]", g_dgettext (NULL, "package(s)"), g_dgettext (NULL, "package(s)"), g_dgettext (NULL, "package(s)"));
	_tmp8_ = _tmp7_;
	fprintf (_tmp6_, "%s", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = stdout;
	fprintf (_tmp9_, "\n");
}

static void
pamac_installer_on_important_details_outpout (PamacInstaller* self,
                                              gboolean must_show)
{
	g_return_if_fail (self != NULL);
	self->priv->important_details = TRUE;
}

static void
pamac_installer_on_close_button_clicked (PamacInstaller* self)
{
	g_return_if_fail (self != NULL);
	g_application_release ((GApplication*) self);
}

static void
pamac_installer_on_cancel_button_clicked (PamacInstaller* self)
{
	PamacTransactionGtk* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->cancelled = TRUE;
	_tmp0_ = self->priv->transaction;
	pamac_transaction_cancel ((PamacTransaction*) _tmp0_);
	if (self->priv->waiting) {
		PamacTransactionGtk* _tmp1_;
		self->priv->waiting = FALSE;
		_tmp1_ = self->priv->transaction;
		pamac_transaction_gtk_stop_progressbar_pulse (_tmp1_);
	}
}

static void
pamac_installer_on_start_waiting (PamacInstaller* self)
{
	PamacProgressDialog* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->waiting = TRUE;
	_tmp0_ = self->priv->progress_dialog;
	_tmp1_ = _tmp0_->cancel_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
}

static void
pamac_installer_on_stop_waiting (PamacInstaller* self)
{
	PamacProgressDialog* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->waiting = FALSE;
	_tmp0_ = self->priv->progress_dialog;
	_tmp1_ = _tmp0_->cancel_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
}

static void
pamac_installer_on_start_preparing (PamacInstaller* self)
{
	PamacProgressDialog* _tmp0_;
	GdkCursor* _tmp1_;
	GdkCursor* _tmp2_;
	PamacProgressDialog* _tmp3_;
	GtkButton* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_dialog;
	_tmp1_ = gdk_cursor_new_from_name ("progress", NULL);
	_tmp2_ = _tmp1_;
	gtk_widget_set_cursor ((GtkWidget*) _tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->progress_dialog;
	_tmp4_ = _tmp3_->cancel_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
}

static void
pamac_installer_on_stop_preparing (PamacInstaller* self)
{
	PamacProgressDialog* _tmp0_;
	GtkButton* _tmp1_;
	PamacProgressDialog* _tmp2_;
	GdkCursor* _tmp3_;
	GdkCursor* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_dialog;
	_tmp1_ = _tmp0_->cancel_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->progress_dialog;
	_tmp3_ = gdk_cursor_new_from_name ("default", NULL);
	_tmp4_ = _tmp3_;
	gtk_widget_set_cursor ((GtkWidget*) _tmp2_, _tmp4_);
	_g_object_unref0 (_tmp4_);
}

static void
pamac_installer_on_start_downloading (PamacInstaller* self)
{
	PamacProgressDialog* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_dialog;
	_tmp1_ = _tmp0_->cancel_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
}

static void
pamac_installer_on_stop_downloading (PamacInstaller* self)
{
	PamacProgressDialog* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->progress_dialog;
	_tmp1_ = _tmp0_->cancel_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
}

static void
pamac_installer_real_shutdown (GApplication* base)
{
	PamacInstaller * self;
	self = (PamacInstaller*) base;
	G_APPLICATION_CLASS (pamac_installer_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	if (!pamac_installer_check_pamac_running (self)) {
		PamacTransactionGtk* _tmp0_;
		_tmp0_ = self->priv->transaction;
		pamac_transaction_quit_daemon ((PamacTransaction*) _tmp0_);
	}
}

static gboolean
pamac_installer_check_pamac_running (PamacInstaller* self)
{
	GApplication* app = NULL;
	gboolean run = FALSE;
	GApplication* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	run = FALSE;
	_tmp0_ = g_application_new ("org.manjaro.pamac.manager", 0);
	_g_object_unref0 (app);
	app = _tmp0_;
	{
		g_application_register (app, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("installer.vala:270: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	run = g_application_get_is_remote (app);
	result = run;
	_g_object_unref0 (app);
	return result;
}

static gint
pamac_installer_main (gchar** args,
                      gint args_length1)
{
	PamacInstaller* installer = NULL;
	PamacInstaller* _tmp0_;
	gint result;
	_tmp0_ = pamac_installer_new ();
	installer = _tmp0_;
	result = g_application_run ((GApplication*) installer, (gint) args_length1, args);
	_g_object_unref0 (installer);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return pamac_installer_main (argv, argc);
}

static void
pamac_installer_class_init (PamacInstallerClass * klass,
                            gpointer klass_data)
{
	pamac_installer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacInstaller_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) pamac_installer_real_startup;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) pamac_installer_real_command_line;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) pamac_installer_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = pamac_installer_finalize;
}

static void
pamac_installer_instance_init (PamacInstaller * self,
                               gpointer klass)
{
	self->priv = pamac_installer_get_instance_private (self);
}

static void
pamac_installer_finalize (GObject * obj)
{
	PamacInstaller * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_INSTALLER, PamacInstaller);
	_g_object_unref0 (self->priv->cmd);
	_g_object_unref0 (self->priv->database);
	_g_object_unref0 (self->priv->transaction);
	_g_object_unref0 (self->priv->progress_dialog);
	G_OBJECT_CLASS (pamac_installer_parent_class)->finalize (obj);
}

static GType
pamac_installer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacInstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacInstaller), 0, (GInstanceInitFunc) pamac_installer_instance_init, NULL };
	GType pamac_installer_type_id;
	pamac_installer_type_id = g_type_register_static (gtk_application_get_type (), "PamacInstaller", &g_define_type_info, 0);
	PamacInstaller_private_offset = g_type_add_instance_private (pamac_installer_type_id, sizeof (PamacInstallerPrivate));
	return pamac_installer_type_id;
}

GType
pamac_installer_get_type (void)
{
	static volatile gsize pamac_installer_type_id__once = 0;
	if (g_once_init_enter (&pamac_installer_type_id__once)) {
		GType pamac_installer_type_id;
		pamac_installer_type_id = pamac_installer_get_type_once ();
		g_once_init_leave (&pamac_installer_type_id__once, pamac_installer_type_id);
	}
	return pamac_installer_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

