/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeFilter;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultFiltered;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.data.AttributeMetaDataProxy;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ResultSetDataContainer
implements DBSDataContainer,
DBPContextProvider,
DBPAdaptable,
DBDAttributeFilter {
    private static final Log log = Log.getLog(ResultSetDataContainer.class);
    private final IResultSetController controller;
    private final DBSDataContainer dataContainer;
    private final ResultSetModel model;
    private ResultSetDataContainerOptions options;
    private boolean filterAttributes;

    public ResultSetDataContainer(IResultSetController controller, ResultSetDataContainerOptions options) {
        this.controller = controller;
        this.dataContainer = controller.getDataContainer();
        this.model = controller.getModel();
        this.options = options;
    }

    public String getDescription() {
        return this.dataContainer.getDescription();
    }

    public DBSObject getParentObject() {
        return this.dataContainer.getParentObject();
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataContainer.getDataSource();
    }

    @NotNull
    public String[] getSupportedFeatures() {
        return new String[]{"data.select", "data.count"};
    }

    public ResultSetDataContainerOptions getOptions() {
        return this.options;
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBException {
        this.filterAttributes = this.proceedSelectedColumnsOnly(flags);
        if (this.filterAttributes || this.proceedSelectedRowsOnly(flags)) {
            long startTime = System.currentTimeMillis();
            DBCStatistics statistics = new DBCStatistics();
            statistics.setExecuteTime(System.currentTimeMillis() - startTime);
            ModelResultSet resultSet = new ModelResultSet(session, flags);
            long resultCount = 0L;
            Throwable throwable = null;
            Object var19_15 = null;
            try {
                try {
                    DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (long)firstRow, (long)maxRows);
                    while (!session.getProgressMonitor().isCanceled() && resultSet.nextRow()) {
                        if (!this.proceedSelectedRowsOnly(flags) || this.options.getSelectedRows().contains(resultSet.curRow.getRowNumber())) {
                            dataReceiver.fetchRow(session, (DBCResultSet)resultSet);
                        }
                        ++resultCount;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            statistics.setFetchTime(System.currentTimeMillis() - startTime);
            statistics.setRowsFetched(resultCount);
            return statistics;
        }
        return this.dataContainer.readData(source, session, dataReceiver, dataFilter, firstRow, maxRows, flags, fetchSize);
    }

    private boolean proceedSelectedColumnsOnly(long flags) {
        return (flags & 8L) != 0L && !CommonUtils.isEmpty(this.options.getSelectedColumns());
    }

    private boolean proceedSelectedRowsOnly(long flags) {
        return (flags & 4L) != 0L && !CommonUtils.isEmpty(this.options.getSelectedRows());
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBException {
        if (this.proceedSelectedRowsOnly(flags)) {
            return this.options.getSelectedRows().size();
        }
        if (this.proceedSelectedColumnsOnly(flags)) {
            return this.model.getRowCount();
        }
        return this.dataContainer.countData(source, session, dataFilter, flags);
    }

    @NotNull
    public String getName() {
        return this.dataContainer.getName();
    }

    public boolean isPersisted() {
        return this.dataContainer.isPersisted();
    }

    public <T> T getAdapter(@NotNull Class<T> adapter) {
        Object result = GeneralUtils.adapt((Object)this.dataContainer, adapter);
        if (result == null) {
            result = GeneralUtils.adapt((Object)this.controller, adapter);
        }
        if (result == null) {
            result = GeneralUtils.adapt((Object)this.controller.getDecorator(), adapter);
        }
        return adapter.cast(result);
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.controller.getExecutionContext();
    }

    public DBDAttributeBinding[] filterAttributeBindings(DBDAttributeBinding[] attributes) {
        DBDAttributeBinding[] preFiltered;
        DBDDataFilter dataFilter = this.model.getDataFilter();
        ArrayList<DBDAttributeBinding> filtered = new ArrayList<DBDAttributeBinding>();
        if (this.filterAttributes && !this.options.getSelectedColumns().isEmpty()) {
            preFiltered = this.options.getSelectedColumns().toArray(new DBDAttributeBinding[0]);
            int i = 0;
            while (i < preFiltered.length) {
                DBDAttributeBinding pfa = preFiltered[i];
                DBDAttributeBinding[] dBDAttributeBindingArray = attributes;
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBDAttributeBinding oa = dBDAttributeBindingArray[n2];
                    if (oa.getMetaAttribute() instanceof ModelMetaAttribute && ((ModelMetaAttribute)oa.getMetaAttribute()).getProxyAttribute() == pfa.getMetaAttribute()) {
                        preFiltered[i] = oa;
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
        } else {
            preFiltered = attributes;
        }
        DBDAttributeBinding[] dBDAttributeBindingArray = preFiltered;
        int n = preFiltered.length;
        int n3 = 0;
        while (n3 < n) {
            DBDAttributeBinding attr = dBDAttributeBindingArray[n3];
            DBDAttributeConstraint ac = dataFilter.getConstraint(attr);
            if (ac == null || ac.isVisible()) {
                filtered.add(attr);
            }
            ++n3;
        }
        filtered.sort((o1, o2) -> {
            DBDAttributeConstraint c1 = dataFilter.getConstraint((DBSAttributeBase)o1, true);
            DBDAttributeConstraint c2 = dataFilter.getConstraint((DBSAttributeBase)o2, true);
            if (c1 == null || c2 == null) {
                return 0;
            }
            return c1.getVisualPosition() - c2.getVisualPosition();
        });
        return filtered.toArray(new DBDAttributeBinding[0]);
    }

    private static class ModelMetaAttribute
    extends AttributeMetaDataProxy {
        private final int position;

        public ModelMetaAttribute(DBCAttributeMetaData metaAttribute, int position) {
            super((DBSAttributeBase)metaAttribute);
            this.position = position;
        }

        public int getOrdinalPosition() {
            return this.position;
        }
    }

    private class ModelResultSet
    implements DBCResultSet,
    DBCResultFiltered {
        private final DBCSession session;
        private DBCStatement localStatement;
        private final long flags;
        private ResultSetRow curRow;
        private CustomResultSetMeta meta;

        ModelResultSet(DBCSession session, long flags) {
            this.session = session;
            this.localStatement = new LocalStatement(session, "");
            this.flags = flags;
        }

        @NotNull
        public DBCSession getSession() {
            return this.session;
        }

        @NotNull
        public DBCStatement getSourceStatement() {
            return this.localStatement;
        }

        public Object getAttributeValue(int index) throws DBCException {
            return ResultSetDataContainer.this.model.getCellValue(ResultSetDataContainer.this.model.getVisibleAttribute(index), this.curRow);
        }

        public Object getAttributeValue(String name) throws DBCException {
            DBDAttributeBinding attr = (DBDAttributeBinding)DBUtils.findObject(ResultSetDataContainer.this.model.getVisibleAttributes(), (String)name);
            if (attr == null) {
                throw new DBCException("Attribute '" + name + "' not found");
            }
            return ResultSetDataContainer.this.model.getCellValue(attr, this.curRow);
        }

        public DBDValueMeta getAttributeValueMeta(int index) throws DBCException {
            return null;
        }

        public DBDValueMeta getRowMeta() throws DBCException {
            return null;
        }

        public boolean nextRow() throws DBCException {
            if (this.curRow == null) {
                if (ResultSetDataContainer.this.model.getRowCount() == 0) {
                    return false;
                }
                this.curRow = ResultSetDataContainer.this.model.getRow(0);
            } else {
                if (this.curRow.getVisualNumber() >= ResultSetDataContainer.this.model.getRowCount() - 1) {
                    return false;
                }
                this.curRow = ResultSetDataContainer.this.model.getRow(this.curRow.getVisualNumber() + 1);
            }
            return true;
        }

        public boolean moveTo(int position) throws DBCException {
            if (position >= ResultSetDataContainer.this.model.getRowCount() - 1) {
                return false;
            }
            this.curRow = ResultSetDataContainer.this.model.getRow(position);
            return true;
        }

        @NotNull
        public DBCResultSetMetaData getMeta() throws DBCException {
            if (this.meta == null) {
                List<DBDAttributeBinding> attributes = ResultSetDataContainer.this.model.getVisibleAttributes();
                ArrayList<DBCAttributeMetaData> meta = new ArrayList<DBCAttributeMetaData>(attributes.size());
                int i = 0;
                while (i < attributes.size()) {
                    DBDAttributeBinding attribute = attributes.get(i);
                    DBCAttributeMetaData metaAttribute = attribute.getMetaAttribute();
                    if (metaAttribute != null) {
                        meta.add((DBCAttributeMetaData)new ModelMetaAttribute(metaAttribute, i));
                    }
                    ++i;
                }
                this.meta = new CustomResultSetMeta(meta);
            }
            return this.meta;
        }

        public String getResultSetName() throws DBCException {
            return "ClientResults";
        }

        public Object getFeature(String name) {
            if ("local".equals(name)) {
                return true;
            }
            return null;
        }

        public void close() {
        }

        private class CustomResultSetMeta
        extends LocalResultSetMeta {
            public CustomResultSetMeta(List<DBCAttributeMetaData> meta) {
                super(meta);
            }
        }
    }
}

