/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlResult;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLScript;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.ISmartTransactionManager;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.editors.sql.QueryResultsContainer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLResultsConsumer;
import org.jkiss.dbeaver.ui.editors.sql.execute.SQLQueryJob;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

abstract class QueryProcessor
implements SQLResultsConsumer,
ISmartTransactionManager,
SQLEditor.QueryProcessingComponent {
    static final int QUERIES_COUNT_FOR_NO_FETCH_RESULT_SET_CONFIRMATION = 100;
    @NotNull
    private final SQLEditor owner;
    private volatile SQLQueryJob curJob;
    private final boolean singleQuery;
    private final AtomicInteger curJobRunning = new AtomicInteger(0);
    protected final List<QueryResultsContainer> resultContainers = new ArrayList<QueryResultsContainer>();
    private DBDDataReceiver curDataReceiver = null;

    QueryProcessor(@NotNull SQLEditor owner, boolean singleQuery, boolean makeDefault) {
        this.owner = owner;
        this.singleQuery = singleQuery;
        if (makeDefault) {
            owner.queryProcessors.addFirst(this);
        } else {
            owner.queryProcessors.add(this);
        }
        this.createResultsProvider(0, makeDefault);
    }

    @NotNull
    public SQLEditor getOwner() {
        return this.owner;
    }

    public SQLQueryJob getCurJob() {
        return this.curJob;
    }

    int getRunningJobs() {
        return this.curJobRunning.get();
    }

    public AtomicInteger getCurJobRunning() {
        return this.curJobRunning;
    }

    public void setCurDataReceiver(DBDDataReceiver curDataReceiver) {
        this.curDataReceiver = curDataReceiver;
    }

    @NotNull
    private QueryResultsContainer createResultsProvider(int resultSetNumber, boolean makeDefault) {
        QueryResultsContainer resultsProvider = this.createQueryResultsContainer(resultSetNumber, this.owner.getMaxResultsTabIndex() + 1, this.singleQuery, makeDefault);
        this.resultContainers.add(resultsProvider);
        return resultsProvider;
    }

    @NotNull
    QueryResultsContainer createResultsProvider(@NotNull DBSDataContainer dataContainer) {
        QueryResultsContainer resultsProvider = this.createQueryResultsContainer(this.resultContainers.size(), this.owner.getMaxResultsTabIndex(), dataContainer, this.singleQuery);
        this.resultContainers.add(resultsProvider);
        return resultsProvider;
    }

    @NotNull
    protected abstract QueryResultsContainer createQueryResultsContainer(int var1, int var2, boolean var3, boolean var4);

    @NotNull
    protected abstract QueryResultsContainer createQueryResultsContainer(int var1, int var2, @NotNull DBSDataContainer var3, boolean var4);

    public boolean hasPinnedTabs() {
        for (QueryResultsContainer container : this.resultContainers) {
            if (!container.isPinned()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    QueryResultsContainer getFirstResults() {
        return this.resultContainers.getFirst();
    }

    @NotNull
    List<QueryResultsContainer> getResultContainers() {
        return this.resultContainers;
    }

    void closeJob() {
        SQLQueryJob job = this.curJob;
        if (job != null) {
            if (job.getState() == 4) {
                job.cancel();
            }
            this.curJob = null;
            if (job.isJobOpen()) {
                RuntimeUtils.runTask(monitor -> job.closeJob(), (String)"Close SQL job", (long)2000L, (boolean)true);
            }
        }
    }

    public void cancelJob() {
        for (QueryResultsContainer rc : this.resultContainers) {
            rc.viewer.cancelJobs();
        }
        SQLQueryJob job = this.curJob;
        if (job != null && job.getState() == 4) {
            job.cancel();
        }
    }

    boolean processQueries(SQLScriptContext scriptContext, List<SQLScriptElement> queries, boolean forceScript, boolean fetchResults, boolean export, boolean closeTabOnError, SQLQueryListener queryListener) {
        if (queries.isEmpty()) {
            return false;
        }
        if (this.curJobRunning.get() > 0) {
            DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, SQLEditorMessages.editors_sql_error_cant_execute_query_message);
            return false;
        }
        DBCExecutionContext executionContext = this.owner.getExecutionContext();
        if (executionContext == null) {
            DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, ModelMessages.error_not_connected_to_database);
            return false;
        }
        boolean isSingleQuery = !forceScript && queries.size() == 1;
        this.owner.showScriptPositionRuler(this.owner.getShowScriptRulerOnExecution());
        QueryResultsContainer resultsContainer = this.getFirstResults();
        SQLEditor.SQLEditorQueryListener listener = new SQLEditor.SQLEditorQueryListener(this, closeTabOnError);
        if (queryListener != null) {
            listener.setExtListener(queryListener);
        }
        if (export) {
            this.processDataExport(scriptContext, queries);
        } else {
            boolean disableFetchCurrentResultSets;
            if (queries.size() > 100) {
                if (this.owner.getDisableFetchResultSet() == null) {
                    DBPPlatformUI.UserChoiceResponse rs = DBWorkbench.getPlatformUI().showUserChoice(SQLEditorMessages.sql_editor_confirm_no_fetch_result_for_big_script_title, SQLEditorMessages.sql_editor_confirm_no_fetch_result_for_big_script_question, List.of(SQLEditorMessages.sql_editor_confirm_no_fetch_result_for_big_script_yes, SQLEditorMessages.sql_editor_confirm_no_fetch_result_for_big_script_no), List.of(SQLEditorMessages.sql_editor_confirm_no_fetch_result_for_big_script_remember), Integer.valueOf(0), 0);
                    boolean bl = disableFetchCurrentResultSets = rs.choiceIndex == 0;
                    if (rs.forAllChoiceIndex != null) {
                        this.owner.setDisableFetchResultSet(disableFetchCurrentResultSets);
                    }
                } else {
                    disableFetchCurrentResultSets = this.owner.getDisableFetchResultSet();
                }
            } else {
                disableFetchCurrentResultSets = false;
            }
            SQLQueryJob job = new SQLQueryJob(this.owner.getSite(), isSingleQuery ? SQLEditorMessages.editors_sql_job_execute_query : SQLEditorMessages.editors_sql_job_execute_script, executionContext, resultsContainer, queries, scriptContext, this, listener, disableFetchCurrentResultSets);
            if (isSingleQuery) {
                resultsContainer.setQuery(queries.getFirst());
                this.closeJob();
                this.curJob = job;
                ResultSetViewer rsv = resultsContainer.getResultSetController();
                if (rsv != null) {
                    rsv.resetDataFilter(false);
                    rsv.resetHistory();
                    rsv.refresh();
                }
            } else {
                if (fetchResults) {
                    job.setFetchResultSets(true);
                }
                job.schedule();
                this.curJob = job;
            }
        }
        return true;
    }

    private void processDataExport(SQLScriptContext scriptContext, List<SQLScriptElement> queries) {
        ArrayList<DatabaseTransferProducer> producers = new ArrayList<DatabaseTransferProducer>();
        for (SQLScriptElement element : queries) {
            if (element instanceof SQLControlCommand) {
                SQLControlCommand controlCommand = (SQLControlCommand)element;
                try {
                    SQLControlResult controlResult = scriptContext.executeControlCommand((DBRProgressMonitor)new LoggingProgressMonitor(SQLEditorBase.log), controlCommand);
                    if (controlResult.getTransformed() != null) {
                        element = controlResult.getTransformed();
                    }
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Command error", "Error processing control command", (Throwable)e);
                    return;
                }
            }
            if (element instanceof SQLScript) {
                DBWorkbench.getPlatformUI().showError("Embedded scripts are not allowed", "Query contains script element: " + element.getText());
                return;
            }
            if (!(element instanceof SQLQuery)) continue;
            SQLQuery query = (SQLQuery)element;
            scriptContext.fillQueryParameters(query, () -> null, false);
            SQLQueryDataContainer dataContainer = new SQLQueryDataContainer((DBPContextProvider)this.getOwner(), query, scriptContext, SQLEditorBase.log);
            producers.add(new DatabaseTransferProducer((DBSDataContainer)dataContainer, null));
        }
        DataTransferWizard.openWizard((IWorkbenchWindow)this.owner.getSite().getWorkbenchWindow(), producers, null, (IStructuredSelection)new StructuredSelection((Object)this), (boolean)true);
    }

    public boolean isDirty() {
        for (QueryResultsContainer resultsProvider : this.resultContainers) {
            ResultSetViewer rsv = resultsProvider.getResultSetController();
            if (rsv == null || !rsv.isDirty()) continue;
            return true;
        }
        return false;
    }

    void removeResults(QueryResultsContainer resultsContainer) {
        this.resultContainers.remove(resultsContainer);
        this.owner.removeResults(resultsContainer, this.resultContainers.isEmpty());
    }

    @Override
    @Nullable
    public DBDDataReceiver getDataReceiver(SQLQuery statement, int resultSetNumber) {
        ResultSetViewer rsv;
        boolean isStatsResult;
        if (this.curDataReceiver != null) {
            return this.curDataReceiver;
        }
        boolean bl = isStatsResult = statement != null && statement.getData() == SQLQueryJob.STATS_RESULTS;
        if (resultSetNumber >= this.resultContainers.size() && !this.owner.isDisposed()) {
            UIUtils.syncExec(() -> this.createResultsProvider(resultSetNumber, false));
        }
        if (resultSetNumber >= this.resultContainers.size()) {
            return null;
        }
        QueryResultsContainer resultsProvider = this.resultContainers.get(resultSetNumber);
        if (statement != null && !this.owner.getResultTabsContainer().isDisposed()) {
            resultsProvider.setQuery((SQLScriptElement)statement);
            resultsProvider.setLastGoodQuery((SQLScriptElement)statement);
            Object tabName = null;
            String queryText = CommonUtils.truncateString((String)statement.getText(), (int)1000);
            DBPDataSourceContainer dataSourceContainer = this.owner.getDataSourceContainer();
            String dataSourceContainerName = dataSourceContainer == null ? "N/A" : dataSourceContainer.getName();
            String processedQueryText = CommonUtils.isEmpty((String)queryText) ? "N/A" : queryText;
            String toolTip = NLS.bind((String)SQLEditorMessages.sql_editor_data_receiver_result_name_tooltip_connection, (Object)dataSourceContainerName) + GeneralUtils.getDefaultLineSeparator() + NLS.bind((String)SQLEditorMessages.sql_editor_data_receiver_result_name_tooltip_time, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date())) + GeneralUtils.getDefaultLineSeparator() + NLS.bind((String)SQLEditorMessages.sql_editor_data_receiver_result_name_tooltip_query, (Object)processedQueryText);
            if (isStatsResult) {
                tabName = SQLEditorMessages.editors_sql_statistics;
                int queryIndex = this.owner.queryProcessors.indexOf(this);
                tabName = (String)tabName + " " + (queryIndex + 1);
            }
            String finalTabName = tabName;
            UIUtils.asyncExec(() -> resultsProvider.updateResultsName(finalTabName, toolTip));
        }
        return (rsv = resultsProvider.getResultSetController()) == null ? null : rsv.getDataReceiver();
    }

    public boolean isSmartAutoCommit() {
        return this.owner.isSmartAutoCommit();
    }

    public void setSmartAutoCommit(boolean smartAutoCommit) {
        this.owner.setSmartAutoCommit(smartAutoCommit);
    }
}

