/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.format;

import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AIQueryConfirmationRule;
import org.jkiss.dbeaver.model.ai.AISchemaGenerator;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class DefaultFormattingConfigurator
implements IObjectPropertyConfigurator<AISchemaGenerator, AISettings> {
    private Button includeSourceTextInCommentCheck;
    private Button executeQueryImmediatelyCheck;
    private Button sendTypeInfoCheck;
    private Button sendDescriptionCheck;
    protected Composite settingsPanel;
    private Combo languageText;
    private Combo confirmSQLCombo;
    private Combo confirmDDLCombo;
    private Combo confirmDMLCombo;
    private Combo confirmOtherCombo;

    public void createControl(@NotNull Composite parent, AISchemaGenerator object, @NotNull Runnable propertyChangeListener) {
        this.settingsPanel = UIUtils.createComposite((Composite)parent, (int)2);
        this.settingsPanel.setLayoutData((Object)new GridData(768));
        Composite leftPanel = UIUtils.createComposite((Composite)this.settingsPanel, (int)1);
        leftPanel.setLayoutData((Object)new GridData(34));
        this.createLeftPanel(leftPanel, propertyChangeListener);
        Composite rightPanel = UIUtils.createComposite((Composite)this.settingsPanel, (int)1);
        rightPanel.setLayoutData((Object)new GridData(34));
        this.createRightPanel(rightPanel);
    }

    protected void createLeftPanel(@NotNull Composite leftPanel, @NotNull Runnable propertyChangeListener) {
        Composite generalComposite = UIUtils.createTitledComposite((Composite)leftPanel, (String)UIMessages.ui_properties_tree_viewer_category_general, (int)2, (int)34);
        this.languageText = UIUtils.createLabelCombo((Composite)generalComposite, (String)UIMessages.controls_locale_selector_label_language, (int)4);
        this.languageText.setLayoutData((Object)GridDataFactory.create((int)768).hint(150, -1).create());
        this.languageText.setToolTipText("Language AI engine should use in chat by default.\nYou can enter any natural language name.\nIf not specified then AI will reply in the same language you use for prompts.");
        TreeSet<String> languages = new TreeSet<String>();
        for (Locale locale : Locale.getAvailableLocales()) {
            languages.add(locale.getDisplayLanguage());
        }
        this.languageText.setItems(languages.toArray(new String[0]));
        Composite completionGroup = UIUtils.createTitledComposite((Composite)leftPanel, (String)"SQL Completion", (int)1, (int)34);
        Composite appearanceSettings = UIUtils.createComposite((Composite)completionGroup, (int)2);
        appearanceSettings.setLayoutData((Object)new GridData(34));
        this.createAppearanceSettings(appearanceSettings, propertyChangeListener);
        Composite completionComposite = UIUtils.createComposite((Composite)completionGroup, (int)2);
        completionComposite.setLayoutData((Object)new GridData(768));
        this.createCompletionSettings(completionComposite, propertyChangeListener);
        Composite queryExecutionSettingsGroup = UIUtils.createTitledComposite((Composite)leftPanel, (String)AIUIMessages.gpt_preference_page_ai_query_confirm_group, (int)2, (int)770);
        this.createQueryExecutionSettings(queryExecutionSettingsGroup);
    }

    protected void createQueryExecutionSettings(@NotNull Composite chatSettingsGroup) {
        this.confirmSQLCombo = this.createConfirmQueryCombo(chatSettingsGroup, AIUIMessages.gpt_preference_page_ai_query_confirm_sql_label, AIUIMessages.gpt_preference_page_ai_query_confirm_sql_tip);
        this.confirmSQLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_execute);
        this.confirmSQLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_confirm);
        this.confirmSQLCombo.select(0);
        this.confirmDMLCombo = this.createConfirmQueryCombo(chatSettingsGroup, AIUIMessages.gpt_preference_page_ai_query_confirm_dml_label, AIUIMessages.gpt_preference_page_ai_query_confirm_dml_tip);
        this.confirmDMLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_execute);
        this.confirmDMLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_confirm);
        this.confirmDMLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_disable_autocommit);
        this.confirmDMLCombo.select(1);
        this.confirmDDLCombo = this.createConfirmQueryCombo(chatSettingsGroup, AIUIMessages.gpt_preference_page_ai_query_confirm_ddl_label, AIUIMessages.gpt_preference_page_ai_query_confirm_ddl_tip);
        this.confirmDDLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_execute);
        this.confirmDDLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_confirm);
        this.confirmDDLCombo.select(1);
        this.confirmOtherCombo = this.createConfirmQueryCombo(chatSettingsGroup, AIUIMessages.gpt_preference_page_ai_query_confirm_other_label, AIUIMessages.gpt_preference_page_ai_query_confirm_other_tip);
        this.confirmOtherCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_execute);
        this.confirmOtherCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_confirm);
        this.confirmOtherCombo.select(1);
    }

    @NotNull
    private Combo createConfirmQueryCombo(@NotNull Composite group, @NotNull String queryType, String hint) {
        Combo combo = UIUtils.createLabelCombo((Composite)group, (String)queryType, (String)hint, (int)12);
        combo.setLayoutData((Object)new GridData(32));
        return combo;
    }

    protected void createRightPanel(Composite rightPanel) {
        Composite schemaGroup = UIUtils.createTitledComposite((Composite)rightPanel, (String)AIUIMessages.gpt_preference_page_schema_group, (int)2, (int)768);
        this.createSchemaSettings(schemaGroup);
    }

    protected void createCompletionSettings(Composite completionGroup, Runnable propertyChangeListener) {
        completionGroup.setLayoutData((Object)new GridData(1808));
        this.executeQueryImmediatelyCheck = UIUtils.createCheckbox((Composite)completionGroup, (String)AIUIMessages.gpt_preference_page_completion_execute_immediately_label, (String)AIUIMessages.gpt_preference_page_completion_execute_immediately_tip, (boolean)false, (int)2);
    }

    protected void createSchemaSettings(Composite schemaGroup) {
        schemaGroup.setLayoutData((Object)new GridData(770));
        this.sendTypeInfoCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIMessages.gpt_preference_page_completion_send_type_label, (String)AIUIMessages.gpt_preference_page_completion_send_type_tip, (boolean)false, (int)2);
        this.sendDescriptionCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIMessages.gpt_preference_page_completion_execute_description_label, (String)AIUIMessages.gpt_preference_page_completion_execute_description_tip, (boolean)false, (int)2);
    }

    protected void createAppearanceSettings(Composite appearanceGroup, Runnable propertyChangeListener) {
        this.includeSourceTextInCommentCheck = UIUtils.createCheckbox((Composite)appearanceGroup, (String)AIUIMessages.gpt_preference_page_completion_include_source_label, (String)AIUIMessages.gpt_preference_page_completion_include_source_tip, (boolean)false, (int)2);
    }

    public void loadSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.languageText.setText(CommonUtils.notEmpty((String)store.getString("ai.language")));
        this.includeSourceTextInCommentCheck.setSelection(store.getBoolean("ai.completion.includeSourceTextInQuery"));
        this.executeQueryImmediatelyCheck.setSelection(store.getBoolean("ai.completion.executeImmediately"));
        this.sendTypeInfoCheck.setSelection(store.getBoolean("ai.completion.sendType"));
        this.sendDescriptionCheck.setSelection(store.getBoolean("ai.completion.description"));
        AIQueryConfirmationRule confirmSqlRule = (AIQueryConfirmationRule)CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)store.getString("ai.confirmation.sql"), (Enum)AIQueryConfirmationRule.EXECUTE);
        this.confirmSQLCombo.select(confirmSqlRule.ordinal());
        AIQueryConfirmationRule confirmDmlRule = (AIQueryConfirmationRule)CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)store.getString("ai.confirmation.dml"), (Enum)AIQueryConfirmationRule.CONFIRM);
        this.confirmDMLCombo.select(confirmDmlRule.ordinal());
        AIQueryConfirmationRule confirmDdlRule = (AIQueryConfirmationRule)CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)store.getString("ai.confirmation.ddl"), (Enum)AIQueryConfirmationRule.CONFIRM);
        this.confirmDDLCombo.select(confirmDdlRule.ordinal());
        this.confirmDMLCombo.select(confirmDmlRule.ordinal());
        AIQueryConfirmationRule confirmOtherRule = (AIQueryConfirmationRule)CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)store.getString("ai.confirmation.other"), (Enum)AIQueryConfirmationRule.CONFIRM);
        this.confirmOtherCombo.select(confirmOtherRule.ordinal());
    }

    public void saveSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ai.language", this.languageText.getText());
        store.setValue("ai.completion.includeSourceTextInQuery", this.includeSourceTextInCommentCheck.getSelection());
        store.setValue("ai.completion.executeImmediately", this.executeQueryImmediatelyCheck.getSelection());
        store.setValue("ai.completion.sendType", this.sendTypeInfoCheck.getSelection());
        store.setValue("ai.completion.description", this.sendDescriptionCheck.getSelection());
        store.setValue("ai.confirmation.sql", ((AIQueryConfirmationRule)CommonUtils.fromOrdinal(AIQueryConfirmationRule.class, (int)this.confirmSQLCombo.getSelectionIndex())).name());
        store.setValue("ai.confirmation.dml", ((AIQueryConfirmationRule)CommonUtils.fromOrdinal(AIQueryConfirmationRule.class, (int)this.confirmDMLCombo.getSelectionIndex())).name());
        store.setValue("ai.confirmation.ddl", ((AIQueryConfirmationRule)CommonUtils.fromOrdinal(AIQueryConfirmationRule.class, (int)this.confirmDDLCombo.getSelectionIndex())).name());
        store.setValue("ai.confirmation.other", ((AIQueryConfirmationRule)CommonUtils.fromOrdinal(AIQueryConfirmationRule.class, (int)this.confirmOtherCombo.getSelectionIndex())).name());
    }

    public void resetSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setToDefault("ai.confirmation.sql");
        store.setToDefault("ai.confirmation.dml");
        store.setToDefault("ai.confirmation.ddl");
        store.setToDefault("ai.confirmation.other");
    }

    public boolean isComplete() {
        return true;
    }
}

