/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.sql.SQLGroupingAttribute;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.StringEditorTableFactory;
import org.jkiss.dbeaver.ui.controls.StringEditorTableUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class GroupingConfigDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.GroupingConfigDialog";
    private final GroupingResultsContainer resultsContainer;
    private Table columnsTable;
    private Table functionsTable;

    public GroupingConfigDialog(Shell parentShell, GroupingResultsContainer resultsContainer) {
        super(parentShell, "Grouping configuration", null);
        this.resultsContainer = resultsContainer;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        ArrayList<String> allColumnNames = new ArrayList<String>();
        for (DBDAttributeBinding attr : this.resultsContainer.getOwnerPresentation().getController().getModel().getAttributes()) {
            allColumnNames.add(this.getAttributeBindingName(attr));
        }
        ArrayList<String> proposals = new ArrayList<String>(allColumnNames);
        StringContentProposalProvider proposalProvider = new StringContentProposalProvider(new String[0]);
        proposalProvider.setProposals(proposals.toArray(new String[0]));
        this.columnsTable = this.createColumnsTable(parent, proposalProvider, this.resultsContainer.getGroupAttributes(), allColumnNames);
        List<String> defaultFunctions = List.of("COUNT", "SUM", "AVG", "MAX", "MIN");
        proposals.addAll(defaultFunctions);
        proposalProvider.setProposals(proposals.toArray(new String[0]));
        this.functionsTable = this.createFunctionsTable(parent, proposalProvider, this.resultsContainer.getGroupFunctions(), defaultFunctions, allColumnNames);
        return composite;
    }

    protected void okPressed() {
        List attributes = StringEditorTableUtils.collectCustomValues((Table)this.columnsTable);
        List functions = StringEditorTableUtils.collectStringValues((Table)this.functionsTable);
        this.resultsContainer.setGrouping(attributes, functions);
        super.okPressed();
    }

    @NotNull
    private String getAttributeBindingName(@NotNull DBDAttributeBinding binding) {
        if (binding instanceof DBDAttributeBindingMeta) {
            return DBUtils.getQuotedIdentifier((DBPDataSource)binding.getDataSource(), (String)binding.getMetaAttribute().getLabel());
        }
        return binding.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    @NotNull
    private Table createFunctionsTable(@NotNull Composite parent, @NotNull StringContentProposalProvider proposalProvider, @NotNull List<String> groupFunctions, @NotNull List<String> defaultFunctions, @NotNull List<String> columnNames) {
        FunctionsTableFactory tableFactory = new FunctionsTableFactory(this, parent, (IContentProposalProvider)proposalProvider, groupFunctions, defaultFunctions, columnNames);
        return tableFactory.createTable();
    }

    @NotNull
    private Table createColumnsTable(@NotNull Composite parent, @NotNull StringContentProposalProvider proposalProvider, @NotNull List<SQLGroupingAttribute> groupAttributes, @NotNull List<String> allColumnNames) {
        ColumnsTableFactory tableFactory = new ColumnsTableFactory(this, parent, (IContentProposalProvider)proposalProvider, groupAttributes, allColumnNames);
        return tableFactory.createTable();
    }

    private class FunctionsTableFactory
    extends StringEditorTableFactory<String> {
        private final List<String> defaultFunctions;
        private final List<String> columns;

        FunctionsTableFactory(@NotNull GroupingConfigDialog groupingConfigDialog, @Nullable Composite parent, @NotNull IContentProposalProvider proposalProvider, @NotNull List<String> values, @NotNull List<String> defaultFunctions, List<String> columns) {
            super((Composite)UIUtils.createControlGroup((Composite)parent, (String)ResultSetMessages.grouping_panel_function_panel_title, (int)2, (int)1808, (int)0), values, (StringEditorTableUtils.TableValuesManager)new StringEditorTableFactory.StringValuesManager((DBPImage)DBIcon.TREE_FUNCTION), proposalProvider, true);
            this.defaultFunctions = defaultFunctions;
            this.columns = new ArrayList<String>(columns);
            this.columns.addFirst("*");
        }

        @NotNull
        protected Control addButton(@NotNull Composite buttonsGroup) {
            Button addButton = new Button(buttonsGroup, 1036);
            addButton.setText(UIMessages.button_add);
            addButton.setLayoutData((Object)new GridData(768));
            final Menu items = this.createAddMenu(addButton);
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){

                public void widgetSelected(SelectionEvent e) {
                    items.setVisible(true);
                }
            });
            return addButton;
        }

        @NotNull
        private Menu createAddMenu(@NotNull Button addButton) {
            MenuManager rootManager = new MenuManager();
            addButton.addDisposeListener(e -> rootManager.dispose());
            this.addCustomFunction(rootManager);
            for (String function : this.defaultFunctions) {
                MenuManager functionMenu = new MenuManager(function);
                for (String column : this.columns) {
                    functionMenu.add((IAction)this.createSubmenuAction(function, column));
                }
                rootManager.add((IContributionItem)functionMenu);
            }
            Menu addMenu = rootManager.createContextMenu((Control)addButton);
            return addMenu;
        }

        private void addCustomFunction(@NotNull MenuManager addMenu) {
            addMenu.add((IAction)new Action(ResultSetMessages.grouping_panel_function_panel_custom_label){

                public void run() {
                    FunctionsTableFactory.this.addTableItem(new TableItem(FunctionsTableFactory.this.valueTable, 16384));
                }
            });
        }

        @NotNull
        private Action createSubmenuAction(final @NotNull String functionName, final @NotNull String columnName) {
            return new Action(this, columnName){
                final /* synthetic */ FunctionsTableFactory this$1;
                {
                    this.this$1 = this$1;
                    super(arg0);
                }

                public void run() {
                    String functionCall = functionName + "(" + columnName + ")";
                    TableItem newItem = new TableItem(this.this$1.valueTable, 16384);
                    newItem.setText(functionCall);
                    this.this$1.addTableItem(newItem);
                }
            };
        }
    }

    private class ColumnsTableFactory
    extends StringEditorTableFactory<SQLGroupingAttribute> {
        private final List<String> columnNames;

        ColumnsTableFactory(@NotNull GroupingConfigDialog groupingConfigDialog, @Nullable Composite parent, @NotNull IContentProposalProvider proposalProvider, @NotNull List<SQLGroupingAttribute> values, List<String> allColumnNames) {
            super((Composite)UIUtils.createControlGroup((Composite)parent, (String)ResultSetMessages.grouping_panel_column_panel_title, (int)2, (int)1808, (int)0), values, (StringEditorTableUtils.TableValuesManager)groupingConfigDialog.new GroupingAttributeValueManager(), proposalProvider, true);
            this.columnNames = allColumnNames;
        }

        @NotNull
        protected Control addButton(@NotNull Composite buttonsGroup) {
            Button addButton = new Button(buttonsGroup, 1036);
            addButton.setText(UIMessages.button_add);
            addButton.setLayoutData((Object)new GridData(768));
            final Menu items = this.createAddMenu(addButton);
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){

                public void widgetSelected(SelectionEvent e) {
                    items.setVisible(true);
                }
            });
            return addButton;
        }

        @NotNull
        private Menu createAddMenu(@NotNull Button addButton) {
            MenuManager rootManager = new MenuManager();
            addButton.addDisposeListener(e -> rootManager.dispose());
            this.addCustomColumn(rootManager);
            for (final String columnName : this.columnNames) {
                rootManager.add((IAction)new Action(this, columnName){
                    final /* synthetic */ ColumnsTableFactory this$1;
                    {
                        this.this$1 = this$1;
                        super(arg0);
                    }

                    public void run() {
                        TableItem newItem = new TableItem(this.this$1.valueTable, 16384);
                        newItem.setText(columnName);
                        this.this$1.addTableItem(newItem);
                    }
                });
            }
            return rootManager.createContextMenu((Control)addButton);
        }

        private void addCustomColumn(@NotNull MenuManager addMenu) {
            addMenu.add((IAction)new Action(ResultSetMessages.grouping_panel_column_panel_custom_label){

                public void run() {
                    ColumnsTableFactory.this.addTableItem(new TableItem(ColumnsTableFactory.this.valueTable, 16384));
                }
            });
        }
    }

    private class GroupingAttributeValueManager
    implements StringEditorTableUtils.TableValuesManager<SQLGroupingAttribute> {
        private GroupingAttributeValueManager() {
        }

        @NotNull
        public DBPImage getIcon(@Nullable SQLGroupingAttribute value) {
            if (value instanceof SQLGroupingAttribute.BoundAttribute) {
                SQLGroupingAttribute.BoundAttribute bound = (SQLGroupingAttribute.BoundAttribute)value;
                DBSDataType type = bound.getBinding().getDataType();
                return type == null ? DBIcon.TYPE_UNKNOWN : DBValueFormatting.getTypeImage((DBSTypedObject)type);
            }
            return DBIcon.TREE_ATTRIBUTE;
        }

        @NotNull
        public String getString(@Nullable SQLGroupingAttribute value) {
            return value == null ? "" : value.getDisplayName();
        }

        @NotNull
        public Boolean isEditable(@Nullable SQLGroupingAttribute value) {
            return value == null || value instanceof SQLGroupingAttribute.CustomAttribute;
        }

        @Nullable
        public SQLGroupingAttribute prepareNewValue(@Nullable SQLGroupingAttribute originalValue, @Nullable String string) {
            if (CommonUtils.isNotEmpty((String)string)) {
                return SQLGroupingAttribute.makeCustom((DBPDataSource)GroupingConfigDialog.this.resultsContainer.getDataContainer().getDataSource(), (String)string);
            }
            return null;
        }
    }
}

