/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.bitmap;

import java.awt.Color;
import org.apache.fop.util.bitmap.BitmapImageUtil;

public final class DitherUtil {
    public static final int DITHER_MATRIX_2X2 = 2;
    public static final int DITHER_MATRIX_4X4 = 4;
    public static final int DITHER_MATRIX_8X8 = 8;
    private static final int[] BAYER_D2 = new int[]{0, 2, 3, 1};
    private static final int[] BAYER_D4 = DitherUtil.deriveBayerMatrix(BAYER_D2);
    private static final int[] BAYER_D8 = DitherUtil.deriveBayerMatrix(BAYER_D4);

    private DitherUtil() {
    }

    private static int[] deriveBayerMatrix(int[] d) {
        int[] dn = new int[d.length * 4];
        int half = (int)Math.sqrt(d.length);
        for (int part = 0; part < 4; ++part) {
            int c = d.length;
            for (int i = 0; i < c; ++i) {
                DitherUtil.setValueInMatrix(dn, half, part, i, d[i] * 4 + BAYER_D2[part]);
            }
        }
        return dn;
    }

    private static void setValueInMatrix(int[] dn, int half, int part, int idx, int value) {
        int xoff = (part & 1) * half;
        int yoff = (part & 2) * half * half;
        int matrixIndex = yoff + idx / half * half * 2 + idx % half + xoff;
        dn[matrixIndex] = value;
    }

    public static int[] getBayerBasePattern(int matrix) {
        int[] result = new int[matrix * matrix];
        switch (matrix) {
            case 2: {
                System.arraycopy(BAYER_D2, 0, result, 0, BAYER_D2.length);
                break;
            }
            case 4: {
                System.arraycopy(BAYER_D4, 0, result, 0, BAYER_D4.length);
                break;
            }
            case 8: {
                System.arraycopy(BAYER_D8, 0, result, 0, BAYER_D8.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported dither matrix: " + matrix);
            }
        }
        return result;
    }

    public static byte[] getBayerDither(int matrix, int gray255, boolean doubleMatrix) {
        byte[] dither;
        int[] bayer;
        int ditherIndex;
        switch (matrix) {
            case 4: {
                ditherIndex = gray255 * 17 / 255;
                bayer = BAYER_D4;
                break;
            }
            case 8: {
                ditherIndex = gray255 * 65 / 255;
                bayer = BAYER_D8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported dither matrix: " + matrix);
            }
        }
        if (doubleMatrix) {
            if (matrix != 4) {
                throw new IllegalArgumentException("doubleMatrix=true is only allowed for 4x4");
            }
            dither = new byte[bayer.length / 8 * 4];
            int c = bayer.length;
            for (int i = 0; i < c; ++i) {
                int byteIdx;
                boolean dot;
                boolean bl = dot = bayer[i] >= ditherIndex - 1;
                if (!dot) continue;
                int n = byteIdx = i / 4;
                dither[n] = (byte)(dither[n] | 1 << i % 4);
                int n2 = byteIdx;
                dither[n2] = (byte)(dither[n2] | 1 << i % 4 + 4);
                int n3 = byteIdx + 4;
                dither[n3] = (byte)(dither[n3] | 1 << i % 4);
                int n4 = byteIdx + 4;
                dither[n4] = (byte)(dither[n4] | 1 << i % 4 + 4);
            }
        } else {
            dither = new byte[bayer.length / 8];
            int c = bayer.length;
            for (int i = 0; i < c; ++i) {
                int byteIdx;
                boolean dot;
                boolean bl = dot = bayer[i] >= ditherIndex - 1;
                if (!dot) continue;
                int n = byteIdx = i / 8;
                dither[n] = (byte)(dither[n] | 1 << i % 8);
            }
        }
        return dither;
    }

    public static byte[] getBayerDither(int matrix, Color col, boolean doubleMatrix) {
        float black = (float)BitmapImageUtil.convertToGray(col.getRGB()) / 256.0f;
        return DitherUtil.getBayerDither(matrix, Math.round(black * 256.0f), doubleMatrix);
    }
}

