/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.freeplane.core.util.collection.IListModel;

public class SortedComboBoxModel<T>
extends AbstractListModel<T>
implements ComboBoxModel<T>,
IListModel<T>,
Iterable<T> {
    private static final Comparator<Object> COMPARATOR = Comparator.comparing(Object::toString).thenComparing(x -> x.getClass().getName());
    private static final long serialVersionUID = 1L;
    private Object selectedItem;
    private final List<T> model;
    private final boolean areElementsComparable;

    public SortedComboBoxModel() {
        this(false);
    }

    public SortedComboBoxModel(Class<T> objectClass) {
        this(Comparable.class.isAssignableFrom(objectClass));
    }

    private SortedComboBoxModel(boolean areElementsCompable) {
        this.areElementsComparable = areElementsCompable;
        this.model = new ArrayList<T>();
    }

    @Override
    public void add(T element) {
        this.addIfNotExists(element);
    }

    public T addAndReturn(T element) {
        int index = this.addIfNotExists(element);
        return this.getElementAt(index >= 0 ? index : -index - 1);
    }

    public int addIfNotExists(T element) {
        boolean elementAdded;
        int addedElementIndex = this.addImpl(element);
        boolean bl = elementAdded = addedElementIndex >= 0;
        if (elementAdded) {
            this.fireContentsChanged(this, addedElementIndex, addedElementIndex);
        }
        return addedElementIndex;
    }

    private int addImpl(T element) {
        int foundElementIndex = this.binarySearch(element);
        int addedElementIndex = -foundElementIndex - 1;
        if (addedElementIndex >= 0) {
            this.model.add(addedElementIndex, element);
        }
        return addedElementIndex;
    }

    private int binarySearch(T element) {
        if (this.areElementsComparable) {
            return Collections.binarySearch(this.model, (Comparable)element);
        }
        return Collections.binarySearch(this.model, element, COMPARATOR);
    }

    public boolean addAll(T[] elements) {
        boolean contentsChanged = false;
        for (T e : elements) {
            contentsChanged = this.addImpl(e) >= 0 || contentsChanged;
        }
        if (contentsChanged) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
        return contentsChanged;
    }

    @Override
    public void clear() {
        int oldSize = this.getSize();
        if (oldSize > 0) {
            this.model.clear();
            this.fireIntervalRemoved(this, 0, oldSize - 1);
        }
    }

    @Override
    public boolean contains(Object element) {
        return this.binarySearch(element) >= 0;
    }

    public T firstElement() {
        return this.model.get(0);
    }

    @Override
    public T getElementAt(int index) {
        return this.model.get(index);
    }

    public Optional<T> getElement(T comparedElement) {
        int index = this.getIndexOf(comparedElement);
        return index >= 0 ? Optional.of(this.model.get(index)) : Optional.empty();
    }

    @Override
    public int getIndexOf(T o) {
        int index = this.binarySearch(o);
        return index < 0 ? -1 : index;
    }

    @Override
    public int getSize() {
        return this.model.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.model.iterator();
    }

    public Object lastElement() {
        return this.model.get(this.model.size() - 1);
    }

    @Override
    public void remove(Object element) {
        int index = this.binarySearch(element);
        if (index >= 0) {
            this.remove(index);
        }
    }

    @Override
    public void remove(int index) {
        this.model.remove(index);
        this.fireContentsChanged(this, index, index);
    }

    @Override
    public void replace(T oldO, T newO) {
        if (oldO.equals(newO)) {
            return;
        }
        this.remove((Object)oldO);
        this.add(newO);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object o) {
        this.selectedItem = o;
        this.fireContentsChanged(this, -1, -1);
    }

    public Stream<T> stream() {
        return this.model.stream();
    }

    public String toString() {
        return "SortedComboBoxModel [" + this.model + "]";
    }
}

