/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.launcher.daemon.configuration.DaemonPriority;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonRequestContext;
import org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria;

public class DefaultDaemonContext
implements DaemonContext {
    public static final org.gradle.internal.serialize.Serializer<DefaultDaemonContext> SERIALIZER = new Serializer();
    private final String uid;
    private final File javaHome;
    private final File daemonRegistryDir;
    private final Long pid;
    private final Integer idleTimeout;
    private final Collection<String> daemonOpts;
    private final boolean applyInstrumentationAgent;
    private final DaemonPriority priority;
    private final NativeServices.NativeServicesMode nativeServicesMode;
    private final JavaLanguageVersion javaVersion;
    private final String javaVendor;

    public DefaultDaemonContext(String uid, File javaHome, JavaLanguageVersion javaVersion, String javaVendor, File daemonRegistryDir, Long pid, Integer idleTimeout, Collection<String> daemonOpts, boolean applyInstrumentationAgent, NativeServices.NativeServicesMode nativeServicesMode, DaemonPriority priority) {
        this.uid = uid;
        this.javaHome = javaHome;
        this.javaVersion = javaVersion;
        this.daemonRegistryDir = daemonRegistryDir;
        this.pid = pid;
        this.idleTimeout = idleTimeout;
        this.daemonOpts = daemonOpts;
        this.applyInstrumentationAgent = applyInstrumentationAgent;
        this.priority = priority;
        this.nativeServicesMode = nativeServicesMode;
        this.javaVendor = javaVendor;
    }

    public String toString() {
        return String.format("DefaultDaemonContext[uid=%s,javaHome=%s,javaVersion=%s,javaVendor=%s,daemonRegistryDir=%s,pid=%s,idleTimeout=%s,priority=%s,applyInstrumentationAgent=%s,nativeServicesMode=%s,daemonOpts=%s]", new Object[]{this.uid, this.javaHome, this.javaVersion, this.javaVendor, this.daemonRegistryDir, this.pid, this.idleTimeout, this.priority, this.applyInstrumentationAgent, this.nativeServicesMode, Joiner.on((char)',').join(this.daemonOpts)});
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public File getJavaHome() {
        return this.javaHome;
    }

    @Override
    public JavaLanguageVersion getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public String getJavaVendor() {
        return this.javaVendor;
    }

    @Override
    public File getDaemonRegistryDir() {
        return this.daemonRegistryDir;
    }

    @Override
    public Long getPid() {
        return this.pid;
    }

    @Override
    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public Collection<String> getDaemonOpts() {
        return this.daemonOpts;
    }

    @Override
    public boolean shouldApplyInstrumentationAgent() {
        return this.applyInstrumentationAgent;
    }

    @Override
    public NativeServices.NativeServicesMode getNativeServicesMode() {
        return this.nativeServicesMode;
    }

    @Override
    public DaemonPriority getPriority() {
        return this.priority;
    }

    @Override
    public DaemonRequestContext toRequest() {
        return new DaemonRequestContext(new DaemonJvmCriteria.JavaHome(DaemonJvmCriteria.JavaHome.Source.EXISTING_DAEMON, this.javaHome), this.getDaemonOpts(), this.shouldApplyInstrumentationAgent(), this.getNativeServicesMode(), this.getPriority());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDaemonContext that = (DefaultDaemonContext)o;
        return this.applyInstrumentationAgent == that.applyInstrumentationAgent && Objects.equals(this.uid, that.uid) && Objects.equals(this.javaHome, that.javaHome) && Objects.equals(this.daemonRegistryDir, that.daemonRegistryDir) && Objects.equals(this.pid, that.pid) && Objects.equals(this.idleTimeout, that.idleTimeout) && Objects.equals(this.daemonOpts, that.daemonOpts) && this.priority == that.priority && this.nativeServicesMode == that.nativeServicesMode && Objects.equals(this.javaVersion, that.javaVersion) && Objects.equals(this.javaVendor, that.javaVendor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uid, this.javaHome, this.daemonRegistryDir, this.pid, this.idleTimeout, this.daemonOpts, this.applyInstrumentationAgent, this.priority, this.nativeServicesMode, this.javaVersion, this.javaVendor});
    }

    static class Serializer
    implements org.gradle.internal.serialize.Serializer<DefaultDaemonContext> {
        Serializer() {
        }

        public DefaultDaemonContext read(Decoder decoder) throws Exception {
            String uid = decoder.readNullableString();
            String pathname = decoder.readString();
            File javaHome = new File(pathname);
            JavaLanguageVersion javaVersion = JavaLanguageVersion.of((int)decoder.readSmallInt());
            String javaVendor = decoder.readString();
            File registryDir = new File(decoder.readString());
            Long pid = decoder.readBoolean() ? Long.valueOf(decoder.readLong()) : null;
            Integer idle = decoder.readBoolean() ? Integer.valueOf(decoder.readInt()) : null;
            int daemonOptCount = decoder.readInt();
            ArrayList<String> daemonOpts = new ArrayList<String>(daemonOptCount);
            for (int i = 0; i < daemonOptCount; ++i) {
                daemonOpts.add(decoder.readString());
            }
            boolean applyInstrumentationAgent = decoder.readBoolean();
            NativeServices.NativeServicesMode nativeServicesMode = NativeServices.NativeServicesMode.values()[decoder.readSmallInt()];
            DaemonPriority priority = decoder.readBoolean() ? DaemonPriority.values()[decoder.readInt()] : null;
            return new DefaultDaemonContext(uid, javaHome, javaVersion, javaVendor, registryDir, pid, idle, daemonOpts, applyInstrumentationAgent, nativeServicesMode, priority);
        }

        public void write(Encoder encoder, DefaultDaemonContext context) throws Exception {
            encoder.writeNullableString((CharSequence)context.uid);
            encoder.writeString((CharSequence)context.javaHome.getPath());
            encoder.writeSmallInt(context.javaVersion.asInt());
            encoder.writeString((CharSequence)context.javaVendor);
            encoder.writeString((CharSequence)context.daemonRegistryDir.getPath());
            encoder.writeBoolean(context.pid != null);
            if (context.pid != null) {
                encoder.writeLong(context.pid.longValue());
            }
            encoder.writeBoolean(context.idleTimeout != null);
            if (context.idleTimeout != null) {
                encoder.writeInt(context.idleTimeout.intValue());
            }
            encoder.writeInt(context.daemonOpts.size());
            for (String daemonOpt : context.daemonOpts) {
                encoder.writeString((CharSequence)daemonOpt);
            }
            encoder.writeBoolean(context.applyInstrumentationAgent);
            encoder.writeSmallInt(context.nativeServicesMode.ordinal());
            encoder.writeBoolean(context.priority != null);
            if (context.priority != null) {
                encoder.writeInt(context.priority.ordinal());
            }
        }
    }
}

