/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogManager {
    private static final Logger LOG = LoggerFactory.getLogger(LogManager.class);
    public static final String LOCK_FILE_NAME = ".lock";
    public static final String RECOVERY_POINT_CHECKPOINT_FILE = "recovery-point-offset-checkpoint";
    public static final String LOG_START_OFFSET_CHECKPOINT_FILE = "log-start-offset-checkpoint";

    public static boolean waitForAllToComplete(List<Future<?>> jobs, Consumer<Throwable> callback) {
        ArrayList failed = new ArrayList();
        for (Future<?> job : jobs) {
            try {
                job.get();
            }
            catch (Exception e) {
                callback.accept(e);
                failed.add(job);
            }
        }
        return failed.isEmpty();
    }

    public static boolean isStrayKraftReplica(int brokerId, TopicsImage newTopicsImage, UnifiedLog log) {
        int partitionId;
        if (log.topicId().isEmpty()) {
            LOG.info("The topicId does not exist in {}, treat it as a stray log.", (Object)log);
            return true;
        }
        Uuid topicId = log.topicId().get();
        PartitionRegistration partition = newTopicsImage.getPartition(topicId, partitionId = log.topicPartition().partition());
        if (partition == null) {
            LOG.info("Found stray log dir {}: the topicId {} does not exist in the metadata image.", (Object)log, (Object)topicId);
            return true;
        }
        List<Integer> replicas = Arrays.stream(partition.replicas).boxed().toList();
        if (!replicas.contains(brokerId)) {
            LOG.info("Found stray log dir {}: the current replica assignment {} does not contain the local brokerId {}.", new Object[]{log, replicas.stream().map(String::valueOf).collect(Collectors.joining(", ", "[", "]")), brokerId});
            return true;
        }
        return false;
    }
}

