/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Accepted$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Effective$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$None$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Queued$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0015a\u0001B7o\u0001MD\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\r\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u00111\u0005\u0005\u000b\u0003K\u0001!\u0011!Q\u0001\n\u0005\u001d\u0002BCA\u0017\u0001\t\u0005\t\u0015!\u0003\u00020!Q\u0011Q\u0007\u0001\u0003\u0002\u0003\u0006I!a\u000e\t\u0019\u0005u\u0002A!A!\u0002\u0013\ty$a\u0015\t\u0015\u0005U\u0003A!A!\u0002\u0013\t9\u0006\u0003\u0006\u0002`\u0001\u0011\t\u0011)A\u0005\u0003CBq!!\u001c\u0001\t\u0003\ty\u0007\u0003\u0006\u0002\u0004\u0002\u0011\r\u0011\"\u0001o\u0003\u000bC\u0001b!\u000e\u0001A\u0003%\u0011q\u0011\u0005\b\u0007o\u0001A\u0011KB\u001d\u0011\u001d\u0019i\u0005\u0001C)\u0007\u001fBqa!\u0017\u0001\t#\u001aY\u0006C\u0004\u0004`\u0001!\tf!\u0019\t\u000f\rE\u0004\u0001\"\u0011\u0004t!911\u0014\u0001\u0005B\ru\u0005bBAn\u0001\u0011%1Q\u0017\u0005\t\u0007w\u0003A\u0011\u00018\u0004>\"91Q\u0019\u0001\u0005\n\r\u001d\u0007bBBn\u0001\u0011\u00053Q\u001c\u0005\b\u0007W\u0004A\u0011IBw\u0011\u001d\u0019Y\u0010\u0001C)\u0007{<q!!-o\u0011\u0003\t\u0019L\u0002\u0004n]\"\u0005\u0011Q\u0017\u0005\b\u0003[JB\u0011AA_\r\u0019\ty,\u0007!\u0002B\"Q\u00111\\\u000e\u0003\u0016\u0004%\t!!8\t\u0015\t55D!E!\u0002\u0013\ty\u000e\u0003\u0006\u0003\u0010n\u0011)\u001a!C\u0001\u0005#C!Ba(\u001c\u0005#\u0005\u000b\u0011\u0002BJ\u0011)\u0011\tk\u0007BK\u0002\u0013\u0005!\u0011\u0013\u0005\u000b\u0005G[\"\u0011#Q\u0001\n\tM\u0005bBA77\u0011\u0005!Q\u0015\u0005\b\u0005_[B\u0011\u0001BY\u0011%\u00119lGA\u0001\n\u0003\u0011I\fC\u0005\u0003Bn\t\n\u0011\"\u0001\u0003D\"I!\u0011\\\u000e\u0012\u0002\u0013\u0005!1\u001c\u0005\n\u0005?\\\u0012\u0013!C\u0001\u00057D\u0011B!\u0005\u001c\u0003\u0003%\tEa\u0005\t\u0013\t}1$!A\u0005\u0002\t\u0005\u0002\"\u0003B\u00127\u0005\u0005I\u0011\u0001Bq\u0011%\u0011\tdGA\u0001\n\u0003\u0012\u0019\u0004C\u0005\u0003Bm\t\t\u0011\"\u0001\u0003f\"I!\u0011^\u000e\u0002\u0002\u0013\u0005#1\u001e\u0005\n\u0005\u000fZ\u0012\u0011!C!\u0005\u0013B\u0011Ba\u0013\u001c\u0003\u0003%\tE!\u0014\t\u0013\t=8$!A\u0005B\tEx!\u0003B{3\u0005\u0005\t\u0012\u0001B|\r%\ty,GA\u0001\u0012\u0003\u0011I\u0010C\u0004\u0002nI\"\ta!\u0005\t\u0013\t-#'!A\u0005F\t5\u0003\"CB\ne\u0005\u0005I\u0011QB\u000b\u0011%\u0019iBMA\u0001\n\u0003\u001by\u0002C\u0005\u0003PI\n\t\u0011\"\u0003\u0003R\u0019I\u00111]\r\u0011\u0002\u0007\u0005\u0012Q\u001d\u0005\b\u0003ODD\u0011AAu\u0011\u001d\t\t\u0010\u000fC\u0001\u0003g<qa!\f\u001a\u0011\u0003\u0011\u0019AB\u0004\u0002dfA\t!a@\t\u000f\u00055D\b\"\u0001\u0003\u0002\u001d9!Q\u0001\u001f\t\u0002\n\u001daa\u0002B\u0006y!\u0005%Q\u0002\u0005\b\u0003[zD\u0011\u0001B\b\u0011%\u0011\tbPA\u0001\n\u0003\u0012\u0019\u0002C\u0005\u0003 }\n\t\u0011\"\u0001\u0003\"!I!1E \u0002\u0002\u0013\u0005!Q\u0005\u0005\n\u0005cy\u0014\u0011!C!\u0005gA\u0011B!\u0011@\u0003\u0003%\tAa\u0011\t\u0013\t\u001ds(!A\u0005B\t%\u0003\"\u0003B&\u007f\u0005\u0005I\u0011\tB'\u0011%\u0011yePA\u0001\n\u0013\u0011\tfB\u0004\u0003ZqB\tIa\u0017\u0007\u000f\tuC\b#!\u0003`!9\u0011Q\u000e&\u0005\u0002\t\u0005\u0004bBAy\u0015\u0012\u0005\u00131\u001f\u0005\n\u0005#Q\u0015\u0011!C!\u0005'A\u0011Ba\bK\u0003\u0003%\tA!\t\t\u0013\t\r\"*!A\u0005\u0002\t\r\u0004\"\u0003B\u0019\u0015\u0006\u0005I\u0011\tB\u001a\u0011%\u0011\tESA\u0001\n\u0003\u00119\u0007C\u0005\u0003H)\u000b\t\u0011\"\u0011\u0003J!I!1\n&\u0002\u0002\u0013\u0005#Q\n\u0005\n\u0005\u001fR\u0015\u0011!C\u0005\u0005#:qAa\u001b=\u0011\u0003\u0013iGB\u0004\u0002~rB\tI!!\t\u000f\u00055d\u000b\"\u0001\u0003\u0004\"9\u0011\u0011\u001f,\u0005B\u0005M\b\"\u0003B\t-\u0006\u0005I\u0011\tB\n\u0011%\u0011yBVA\u0001\n\u0003\u0011\t\u0003C\u0005\u0003$Y\u000b\t\u0011\"\u0001\u0003\u0006\"I!\u0011\u0007,\u0002\u0002\u0013\u0005#1\u0007\u0005\n\u0005\u00032\u0016\u0011!C\u0001\u0005\u0013C\u0011Ba\u0012W\u0003\u0003%\tE!\u0013\t\u0013\t-c+!A\u0005B\t5\u0003\"\u0003B(-\u0006\u0005I\u0011\u0002B)\u000f\u001d\u0011y\u0007\u0010EA\u0005c2qAa\u001d=\u0011\u0003\u0013)\bC\u0004\u0002n\t$\tAa\u001e\t\u0013\tE!-!A\u0005B\tM\u0001\"\u0003B\u0010E\u0006\u0005I\u0011\u0001B\u0011\u0011%\u0011\u0019CYA\u0001\n\u0003\u0011I\bC\u0005\u00032\t\f\t\u0011\"\u0011\u00034!I!\u0011\t2\u0002\u0002\u0013\u0005!Q\u0010\u0005\n\u0005\u000f\u0012\u0017\u0011!C!\u0005\u0013B\u0011Ba\u0013c\u0003\u0003%\tE!\u0014\t\u0013\t=#-!A\u0005\n\tE\u0003\"CB\u00183E\u0005I\u0011AB\u0019\u0005e\u0011V\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t)\"\u0014X-\u00193\u000b\u0005=\u0004\u0018AB:feZ,'OC\u0001r\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001;\u0011\u0005U4X\"\u00018\n\u0005]t'!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0005]\u0006lW\rE\u0002{\u0003\u000fq1a_A\u0002!\tax0D\u0001~\u0015\tq(/\u0001\u0004=e>|GO\u0010\u0006\u0003\u0003\u0003\tQa]2bY\u0006L1!!\u0002\u0000\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011BA\u0006\u0005\u0019\u0019FO]5oO*\u0019\u0011QA@\u0002\r1,\u0017\rZ3s!\u0011\t\t\"a\b\u000e\u0005\u0005M!bA8\u0002\u0016)\u0019\u0011/a\u0006\u000b\t\u0005e\u00111D\u0001\u0007CB\f7\r[3\u000b\u0005\u0005u\u0011aA8sO&!\u0011\u0011EA\n\u00059aU-\u00193fe\u0016sG\rU8j]RL1!!\u0004w\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fE\u0002v\u0003SI1!a\u000bo\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/\u0001\u0006sKBd\u0017nY1NOJ\u00042!^A\u0019\u0013\r\t\u0019D\u001c\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\r)\u0018\u0011H\u0005\u0004\u0003wq'a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000f\u0005\u0003\u0002B\u0005=SBAA\"\u0015\u0011\t)%a\u0012\u0002\u000f5,GO]5dg*!\u0011\u0011JA&\u0003\rawn\u001a\u0006\u0005\u0003\u001b\n)\"A\u0004ti>\u0014\u0018mZ3\n\t\u0005E\u00131\t\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biNL1!!\u0010w\u000391W\r^2i\u0005\u0006\u001c7n\u00144g\u001bN\u0004B!!\u0017\u0002\\5\tq0C\u0002\u0002^}\u00141!\u00138u\u0003U!\u0017N]3di>\u0014\u00180\u0012<f]RD\u0015M\u001c3mKJ\u0004B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0005\u0003O\n\u0019\"\u0001\u0004d_6lwN\\\u0005\u0005\u0003W\n)GA\u000bESJ,7\r^8ss\u00163XM\u001c;IC:$G.\u001a:\u0002\rqJg.\u001b;?)I\t\t(a\u001d\u0002v\u0005]\u0014\u0011PA>\u0003{\ny(!!\u0011\u0005U\u0004\u0001\"\u0002=\n\u0001\u0004I\bbBA\u0007\u0013\u0001\u0007\u0011q\u0002\u0005\b\u0003KI\u0001\u0019AA\u0014\u0011\u001d\ti#\u0003a\u0001\u0003_Aq!!\u000e\n\u0001\u0004\t9\u0004C\u0004\u0002>%\u0001\r!a\u0010\t\u000f\u0005U\u0013\u00021\u0001\u0002X!I\u0011qL\u0005\u0011\u0002\u0003\u0007\u0011\u0011M\u0001\u0010aJ|Wn\u001c;j_:\u001cF/\u0019;fgV\u0011\u0011q\u0011\t\t\u0003\u0013\u000b9*a'\u0002&6\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)\u0001\u0006d_:\u001cWO\u001d:f]RTA!!%\u0002\u0014\u0006!Q\u000f^5m\u0015\t\t)*\u0001\u0003kCZ\f\u0017\u0002BAM\u0003\u0017\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\ti*!)\u000e\u0005\u0005}%\u0002BA4\u0003+IA!a)\u0002 \nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007cAAT79\u0019\u0011\u0011\u0016\r\u000f\t\u0005-\u0016q\u0016\b\u0004y\u00065\u0016\"A9\n\u0005=\u0004\u0018!\u0007*fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:fC\u0012\u0004\"!^\r\u0014\u0007e\t9\f\u0005\u0003\u0002Z\u0005e\u0016bAA^\u007f\n1\u0011I\\=SK\u001a$\"!a-\u0003\u001dA\u0013x.\\8uS>t7\u000b^1uKN91$a.\u0002D\u0006%\u0007\u0003BA-\u0003\u000bL1!a2\u0000\u0005\u001d\u0001&o\u001c3vGR\u0004B!a3\u0002V:!\u0011QZAi\u001d\ra\u0018qZ\u0005\u0003\u0003\u0003I1!a5\u0000\u0003\u001d\u0001\u0018mY6bO\u0016LA!a6\u0002Z\na1+\u001a:jC2L'0\u00192mK*\u0019\u00111[@\u0002#I,\u0017m]:jO:lWM\u001c;Ti\u0006$X-\u0006\u0002\u0002`B\u0019\u0011\u0011\u001d\u001d\u000e\u0003e\u0011\u0011CU3bgNLwM\\7f]R\u001cF/\u0019;f'\rA\u0014qW\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0005\u0005-\b\u0003BA-\u0003[L1!a<\u0000\u0005\u0011)f.\u001b;\u000235\f\u0017PY3J]\u000e|gn]5ti\u0016tG/T3uC\u0012\fG/Y\u000b\u0003\u0003k\u0004B!!\u0017\u0002x&\u0019\u0011\u0011`@\u0003\u000f\t{w\u000e\\3b]&*\u0001H\u00162@\u0015\nA\u0011iY2faR,GmE\u0002=\u0003o#\"Aa\u0001\u0011\u0007\u0005\u0005H(\u0001\u0003O_:,\u0007c\u0001B\u0005\u007f5\tAH\u0001\u0003O_:,7#C \u00028\u0006}\u00171YAe)\t\u00119!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005+\u0001BAa\u0006\u0003\u001e5\u0011!\u0011\u0004\u0006\u0005\u00057\t\u0019*\u0001\u0003mC:<\u0017\u0002BA\u0005\u00053\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0016\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u0005B\u0017!\u0011\tIF!\u000b\n\u0007\t-rPA\u0002B]fD\u0011Ba\fD\u0003\u0003\u0005\r!a\u0016\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\u0004\u0005\u0004\u00038\tu\"qE\u0007\u0003\u0005sQ1Aa\u000f\u0000\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u007f\u0011ID\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA{\u0005\u000bB\u0011Ba\fF\u0003\u0003\u0005\rAa\n\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0016\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0006\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tM\u0003\u0003\u0002B\f\u0005+JAAa\u0016\u0003\u001a\t1qJ\u00196fGR\fa!U;fk\u0016$\u0007c\u0001B\u0005\u0015\n1\u0011+^3vK\u0012\u001c\u0012BSA\\\u0003?\f\u0019-!3\u0015\u0005\tmC\u0003\u0002B\u0014\u0005KB\u0011Ba\fP\u0003\u0003\u0005\r!a\u0016\u0015\t\u0005U(\u0011\u000e\u0005\n\u0005_\t\u0016\u0011!a\u0001\u0005O\t\u0001\"Q2dKB$X\r\u001a\t\u0004\u0005\u00131\u0016!C#gM\u0016\u001cG/\u001b<f!\r\u0011IA\u0019\u0002\n\u000b\u001a4Wm\u0019;jm\u0016\u001c\u0012BYA\\\u0003?\f\u0019-!3\u0015\u0005\tED\u0003\u0002B\u0014\u0005wB\u0011Ba\fg\u0003\u0003\u0005\r!a\u0016\u0015\t\u0005U(q\u0010\u0005\n\u0005_A\u0017\u0011!a\u0001\u0005O\u0019\u0012BVA\\\u0003?\f\u0019-!3\u0015\u0005\t5D\u0003\u0002B\u0014\u0005\u000fC\u0011Ba\f\\\u0003\u0003\u0005\r!a\u0016\u0015\t\u0005U(1\u0012\u0005\n\u0005_i\u0016\u0011!a\u0001\u0005O\t!C]3bgNLwM\\7f]R\u001cF/\u0019;fA\u00059Ao\u001c9jG&#WC\u0001BJ!\u0019\tIF!&\u0003\u001a&\u0019!qS@\u0003\r=\u0003H/[8o!\u0011\tiJa'\n\t\tu\u0015q\u0014\u0002\u0005+VLG-\u0001\u0005u_BL7-\u00133!\u0003)\u0019WO\u001d:f]R$\u0015N]\u0001\fGV\u0014(/\u001a8u\t&\u0014\b\u0005\u0006\u0005\u0003(\n%&1\u0016BW!\r\t\to\u0007\u0005\b\u00037\u0014\u0003\u0019AAp\u0011\u001d\u0011yI\ta\u0001\u0005'CqA!)#\u0001\u0004\u0011\u0019*\u0001\bxSRD\u0017i]:jO:lWM\u001c;\u0015\t\t\u001d&1\u0017\u0005\b\u0005k\u001b\u0003\u0019AAp\u0003]qWm\u001e#jeJ+\u0017m]:jO:lWM\u001c;Ti\u0006$X-\u0001\u0003d_BLH\u0003\u0003BT\u0005w\u0013iLa0\t\u0013\u0005mG\u0005%AA\u0002\u0005}\u0007\"\u0003BHIA\u0005\t\u0019\u0001BJ\u0011%\u0011\t\u000b\nI\u0001\u0002\u0004\u0011\u0019*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u0015'\u0006BAp\u0005\u000f\\#A!3\u0011\t\t-'Q[\u0007\u0003\u0005\u001bTAAa4\u0003R\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005'|\u0018AC1o]>$\u0018\r^5p]&!!q\u001bBg\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iN\u000b\u0003\u0003\u0014\n\u001d\u0017AD2paf$C-\u001a4bk2$He\r\u000b\u0005\u0005O\u0011\u0019\u000fC\u0005\u00030)\n\t\u00111\u0001\u0002XQ!\u0011Q\u001fBt\u0011%\u0011y\u0003LA\u0001\u0002\u0004\u00119#\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B\u000b\u0005[D\u0011Ba\f.\u0003\u0003\u0005\r!a\u0016\u0002\r\u0015\fX/\u00197t)\u0011\t)Pa=\t\u0013\t=\u0002'!AA\u0002\t\u001d\u0012A\u0004)s_6|G/[8o'R\fG/\u001a\t\u0004\u0003C\u00144#\u0002\u001a\u0003|\u000e\u001d\u0001\u0003\u0004B\u007f\u0007\u0007\tyNa%\u0003\u0014\n\u001dVB\u0001B\u0000\u0015\r\u0019\ta`\u0001\beVtG/[7f\u0013\u0011\u0019)Aa@\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0004\n\r=QBAB\u0006\u0015\u0011\u0019i!a%\u0002\u0005%|\u0017\u0002BAl\u0007\u0017!\"Aa>\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\t\u001d6qCB\r\u00077Aq!a76\u0001\u0004\ty\u000eC\u0004\u0003\u0010V\u0002\rAa%\t\u000f\t\u0005V\u00071\u0001\u0003\u0014\u00069QO\\1qa2LH\u0003BB\u0011\u0007S\u0001b!!\u0017\u0003\u0016\u000e\r\u0002CCA-\u0007K\tyNa%\u0003\u0014&\u00191qE@\u0003\rQ+\b\u000f\\34\u0011%\u0019YCNA\u0001\u0002\u0004\u00119+A\u0002yIA\n\u0011CU3bgNLwM\\7f]R\u001cF/\u0019;f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u001111\u0007\u0016\u0005\u0003C\u00129-\u0001\tqe>lw\u000e^5p]N#\u0018\r^3tA\u0005YA.\u0019;fgR,\u0005o\\2i)\u0011\u0019Yd!\u0013\u0011\r\ru2qHB\"\u001b\t\ty)\u0003\u0003\u0004B\u0005=%\u0001C(qi&|g.\u00197\u0011\t\t]1QI\u0005\u0005\u0007\u000f\u0012IBA\u0004J]R,w-\u001a:\t\u000f\r-C\u00021\u0001\u0002\u001c\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0005\u0007#\u001a9\u0006\u0005\u0003\u0002Z\rM\u0013bAB+\u007f\n!Aj\u001c8h\u0011\u001d\u0019Y%\u0004a\u0001\u00037\u000bA\u0002\\8h\u000b:$wJ\u001a4tKR$Ba!\u0015\u0004^!911\n\bA\u0002\u0005m\u0015!E3oI>3gm]3u\r>\u0014X\t]8dQR111MB6\u0007[\u0002ba!\u0010\u0004@\r\u0015\u0004\u0003BA2\u0007OJAa!\u001b\u0002f\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007bBB&\u001f\u0001\u0007\u00111\u0014\u0005\b\u0007_z\u0001\u0019AA,\u0003\u0015)\u0007o\\2i\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRQ1QOBC\u0007\u000f\u001bYia$\u0011\r\u0005e#QSB<!\u0011\u0019Ih!!\u000e\u0005\rm$\u0002BA%\u0007{RAaa \u0002L\u0005I\u0011N\u001c;fe:\fGn]\u0005\u0005\u0007\u0007\u001bYHA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0007\u0017\u0002\u0002\u0019AAN\u0011\u001d\u0019I\t\u0005a\u0001\u0007#\n1BZ3uG\"|eMZ:fi\"91Q\u0012\tA\u0002\u0005]\u0013\u0001\u00069beRLG/[8o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0004\u0004\u0012B\u0001\raa%\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\u0019)ja&\u000e\u0003\u0001I1a!'w\u0005%1U\r^2i\t\u0006$\u0018-\u0001\tsK6|g/\u001a)beRLG/[8ogR!1qTBV!!\u00119d!)\u0002\u001c\u000e\u0015\u0016\u0002BBR\u0005s\u00111!T1q!\u0011\t\tba*\n\t\r%\u00161\u0003\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/\u001a\u0005\b\u0007[\u000b\u0002\u0019ABX\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B\u001c\u0007c\u000bY*\u0003\u0003\u00044\ne\"aA*fiR!1qWB]!\r\t9\u000b\u000f\u0005\b\u0007\u0017\u0012\u0002\u0019AAN\u0003])\b\u000fZ1uKJ+\u0017m]:jO:lWM\u001c;Ti\u0006$X\r\u0006\u0004\u0002l\u000e}6\u0011\u0019\u0005\b\u0007\u0017\u001a\u0002\u0019AAN\u0011\u001d\u0019\u0019m\u0005a\u0001\u0007o\u000bQa\u001d;bi\u0016\f\u0011$\\1zE\u0016\u0004&o\\7pi\u00164U\u000f^;sKJ+\u0007\u000f\\5dCR1!qEBe\u0007\u0017Dqaa\u0013\u0015\u0001\u0004\tY\nC\u0004\u0004NR\u0001\raa4\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003BBi\u0007/l!aa5\u000b\u0007\rU\u0007/A\u0004dYV\u001cH/\u001a:\n\t\re71\u001b\u0002\n!\u0006\u0014H/\u001b;j_:\fQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0003BBX\u0007?Dqa!9\u0016\u0001\u0004\u0019\u0019/\u0001\nj]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\u001c\b\u0003\u0003B\u001c\u0007C\u000bYj!:\u0011\u0007U\u001c9/C\u0002\u0004j:\u0014\u0011#\u00138ji&\fGNR3uG\"\u001cF/\u0019;f\u0003!!(/\u001e8dCR,GCBAv\u0007_\u001c\t\u0010C\u0004\u0004LY\u0001\r!a'\t\u000f\rMh\u00031\u0001\u0004v\u0006yAO];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u0002v\u0007oL1a!?o\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fq\u0003\u001e:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;\u0015\r\u0005-8q C\u0001\u0011\u001d\u0019Ye\u0006a\u0001\u00037Cq\u0001b\u0001\u0018\u0001\u0004\u0019\t&\u0001\u0004pM\u001a\u001cX\r\u001e")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final DirectoryEventHandler directoryEventHandler;
    private final ConcurrentHashMap<TopicPartition, PromotionState> promotionStates;

    public static DirectoryEventHandler $lessinit$greater$default$8() {
        return DirectoryEventHandler.NOOP;
    }

    public ConcurrentHashMap<TopicPartition, PromotionState> promotionStates() {
        return this.promotionStates;
    }

    @Override
    public Optional<Integer> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Optional<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true, partitionLeaderEpoch) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        DirectoryEventHandler directoryEventHandler = this.directoryEventHandler;
        DirectoryEventHandler directoryEventHandler2 = DirectoryEventHandler.NOOP;
        if (!(directoryEventHandler2 != null ? !directoryEventHandler2.equals(directoryEventHandler) : directoryEventHandler != null)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
        } else {
            this.maybePromoteFutureReplica(topicPartition, partition);
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        topicPartitions.foreach((Function1 & Serializable)topicPartition -> {
            if (this.promotionStates().containsKey(topicPartition)) {
                void var3_3;
                void var4_4;
                void var5_5;
                PromotionState promotionState = this.promotionStates().get(topicPartition);
                if (promotionState == null) {
                    throw new MatchError(null);
                }
                ReassignmentState reassignmentState = promotionState.reassignmentState();
                Option<Uuid> topicId = promotionState.topicId();
                Option<Uuid> originalDir = promotionState.currentDir();
                if (var5_5.isDefined() && var4_4.isDefined() && var3_3.maybeInconsistentMetadata()) {
                    $this.directoryEventHandler.handleAssignment(new TopicIdPartition((Uuid)var4_4.get(), topicPartition.partition()), (Uuid)var5_5.get(), "Reverting reassignment for canceled future replica", () -> {});
                }
                return this.promotionStates().remove(topicPartition);
            }
            return BoxedUnit.UNIT;
        });
        return super.removePartitions(topicPartitions);
    }

    private ReassignmentState reassignmentState(TopicPartition topicPartition) {
        return this.promotionStates().get(topicPartition).reassignmentState();
    }

    public void updateReassignmentState(TopicPartition topicPartition, ReassignmentState state) {
        this.log.debug("Updating future replica " + topicPartition + " reassignment state to " + state);
        this.promotionStates().put(topicPartition, this.promotionStates().get(topicPartition).withAssignment(state));
    }

    private Object maybePromoteFutureReplica(TopicPartition topicPartition, Partition partition) {
        Option<Uuid> topicId = partition.topicId();
        if (topicId.isEmpty()) {
            throw new IllegalStateException("Topic " + topicPartition.topic() + " does not have an ID.");
        }
        ReassignmentState reassignmentState = this.reassignmentState(topicPartition);
        if (ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$.equals(reassignmentState)) {
            return BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1<UnifiedLog, BoxedUnit>)(Function1 & Serializable)x$2 -> {
                ReplicaAlterLogDirsThread.$anonfun$maybePromoteFutureReplica$1(this, partition, topicId, topicPartition, x$2);
                return BoxedUnit.UNIT;
            }));
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$.equals(reassignmentState)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.updateReassignmentState(topicPartition, ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$);
                return this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$.equals(reassignmentState)) {
            this.log.trace("Waiting for AssignReplicasToDirsRequest to succeed before promoting the future replica.");
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$.equals(reassignmentState)) {
            throw new IllegalStateException("BUG: trying to promote a future replica twice");
        }
        throw new MatchError((Object)reassignmentState);
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            filteredFetchStates.foreach((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$2._1();
                    Option<Uuid> topicId = ((InitialFetchState)x0$2._2()).topicId();
                    Option<Uuid> currentDirectoryId = $this.replicaMgr.getPartitionOrException(topicPartition).logDirectoryId();
                    PromotionState promotionState = new PromotionState(ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$, topicId, currentDirectoryId);
                    return this.promotionStates().put(topicPartition, promotionState);
                }
                throw new MatchError(null);
            });
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, true, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$maybePromoteFutureReplica$1(ReplicaAlterLogDirsThread $this, Partition partition$1, Option topicId$1, TopicPartition topicPartition$1, UnifiedLog x$2) {
        Uuid targetDir = (Uuid)partition$1.futureReplicaDirectoryId().get();
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)topicId$1.get(), topicPartition$1.partition());
        $this.directoryEventHandler.handleAssignment(topicIdPartition, targetDir, "Future replica promotion", () -> $this.updateReassignmentState(topicPartition$1, ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$));
        $this.updateReassignmentState(topicPartition$1, ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(null);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats, int fetchBackOffMs, DirectoryEventHandler directoryEventHandler) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.directoryEventHandler = directoryEventHandler;
        super(name, name, leader, failedPartitions, new TierStateMachine(leader, replicaMgr, true), fetchBackOffMs, false, brokerTopicStats);
        this.promotionStates = new ConcurrentHashMap();
    }

    public static class PromotionState
    implements Product,
    Serializable {
        private final ReassignmentState reassignmentState;
        private final Option<Uuid> topicId;
        private final Option<Uuid> currentDir;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ReassignmentState reassignmentState() {
            return this.reassignmentState;
        }

        public Option<Uuid> topicId() {
            return this.topicId;
        }

        public Option<Uuid> currentDir() {
            return this.currentDir;
        }

        public PromotionState withAssignment(ReassignmentState newDirReassignmentState) {
            return new PromotionState(newDirReassignmentState, this.topicId(), this.currentDir());
        }

        public PromotionState copy(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            return new PromotionState(reassignmentState, topicId, currentDir);
        }

        public ReassignmentState copy$default$1() {
            return this.reassignmentState();
        }

        public Option<Uuid> copy$default$2() {
            return this.topicId();
        }

        public Option<Uuid> copy$default$3() {
            return this.currentDir();
        }

        public String productPrefix() {
            return "PromotionState";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.reassignmentState();
                }
                case 1: {
                    return this.topicId();
                }
                case 2: {
                    return this.currentDir();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PromotionState;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "reassignmentState";
                }
                case 1: {
                    return "topicId";
                }
                case 2: {
                    return "currentDir";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof PromotionState)) break block3;
                    PromotionState promotionState = (PromotionState)x$1;
                    ReassignmentState reassignmentState = this.reassignmentState();
                    ReassignmentState reassignmentState2 = promotionState.reassignmentState();
                    if (reassignmentState != null ? !reassignmentState.equals(reassignmentState2) : reassignmentState2 != null) break block3;
                    Option<Uuid> option = this.topicId();
                    Option<Uuid> option2 = promotionState.topicId();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<Uuid> option3 = this.currentDir();
                    Option<Uuid> option4 = promotionState.currentDir();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !promotionState.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public PromotionState(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            this.reassignmentState = reassignmentState;
            this.topicId = topicId;
            this.currentDir = currentDir;
            Product.$init$((Product)this);
        }
    }

    public static interface ReassignmentState {
        public static /* synthetic */ boolean maybeInconsistentMetadata$(ReassignmentState $this) {
            return $this.maybeInconsistentMetadata();
        }

        default public boolean maybeInconsistentMetadata() {
            return false;
        }

        public static void $init$(ReassignmentState $this) {
        }
    }
}

