/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import java.util.Map;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.ClientAssertionState;
import org.keycloak.broker.provider.ClientAssertionIdentityProviderFactory;
import org.keycloak.cache.AlternativeLookupProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;

public class DefaultClientAssertionStrategy
implements ClientAssertionIdentityProviderFactory.ClientAssertionStrategy {
    public boolean isSupportedAssertionType(String assertionType) {
        return "urn:ietf:params:oauth:client-assertion-type:jwt-bearer".equals(assertionType);
    }

    public ClientAssertionIdentityProviderFactory.LookupResult lookup(ClientAuthenticationFlowContext context) throws Exception {
        ClientAssertionState clientAssertionState = (ClientAssertionState)context.getState(ClientAssertionState.class, ClientAssertionState.supplier());
        AlternativeLookupProvider lookupProvider = (AlternativeLookupProvider)context.getSession().getProvider(AlternativeLookupProvider.class);
        String issuer = clientAssertionState.getToken().getIssuer();
        String federatedClientId = clientAssertionState.getToken().getSubject();
        IdentityProviderModel identityProvider = lookupProvider.lookupIdentityProviderFromIssuer(context.getSession(), issuer);
        if (identityProvider == null) {
            return null;
        }
        ClientModel client = lookupProvider.lookupClientFromClientAttributes(context.getSession(), Map.of("jwt.credential.sub", federatedClientId, "jwt.credential.issuer", identityProvider.getAlias()));
        return new ClientAssertionIdentityProviderFactory.LookupResult(client, identityProvider);
    }
}

