/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseImpl;

public class SqlAliasBaseManager
implements SqlAliasBaseGenerator {
    private final Map<String, Integer> acronymCountMap;

    public SqlAliasBaseManager() {
        this.acronymCountMap = new HashMap<String, Integer>();
    }

    public SqlAliasBaseManager(Set<String> usedAcronyms) {
        this.acronymCountMap = new HashMap<String, Integer>(usedAcronyms.size());
        block0: for (String acronym : usedAcronyms) {
            int underscoreIndex = acronym.lastIndexOf(95);
            for (int i = underscoreIndex - 1; i >= 0; --i) {
                if (Character.isDigit(acronym.charAt(i))) continue;
                String stem = acronym.substring(0, i + 1);
                int acronymValue = Integer.parseInt(acronym.substring(i + 1, underscoreIndex));
                Integer acronymCount = this.acronymCountMap.get(stem);
                if (acronymCount != null && acronymCount >= acronymValue) continue block0;
                this.acronymCountMap.put(stem, acronymValue);
                continue block0;
            }
        }
    }

    @Override
    public SqlAliasBase createSqlAliasBase(String stem) {
        Integer acronymCount = this.acronymCountMap.get(stem);
        if (acronymCount == null) {
            acronymCount = 0;
        }
        Integer n = acronymCount;
        acronymCount = acronymCount + 1;
        this.acronymCountMap.put(stem, acronymCount);
        return new SqlAliasBaseImpl(stem + acronymCount);
    }
}

