/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.classification.tokenizers;

import com.hankcs.hanlp.classification.tokenizers.ITokenizer;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.dictionary.other.CharType;
import java.util.Iterator;
import java.util.LinkedList;

public class BigramTokenizer
implements ITokenizer {
    @Override
    public String[] segment(String text) {
        if (text.length() == 0) {
            return new String[0];
        }
        char[] charArray = text.toCharArray();
        CharTable.normalization(charArray);
        LinkedList<int[]> atomList = new LinkedList<int[]>();
        int start = 0;
        int end = charArray.length;
        int offsetAtom = start;
        byte preType = CharType.get(charArray[offsetAtom]);
        while (++offsetAtom < end) {
            byte curType = CharType.get(charArray[offsetAtom]);
            if (preType == 7) {
                atomList.add(new int[]{start, offsetAtom - start});
                start = offsetAtom;
            } else if (curType != preType) {
                if (charArray[offsetAtom] == '.' && preType == 9) {
                    while (++offsetAtom < end && (curType = CharType.get(charArray[offsetAtom])) == 9) {
                    }
                }
                if (preType == 9 || preType == 8) {
                    atomList.add(new int[]{start, offsetAtom - start});
                }
                start = offsetAtom;
            }
            preType = curType;
        }
        if (offsetAtom == end && (preType == 9 || preType == 8)) {
            atomList.add(new int[]{start, offsetAtom - start});
        }
        if (atomList.isEmpty()) {
            return new String[0];
        }
        String[] termArray = new String[atomList.size() - 1];
        Iterator iterator = atomList.iterator();
        int[] pre = (int[])iterator.next();
        int p = -1;
        while (iterator.hasNext()) {
            int[] cur = (int[])iterator.next();
            termArray[++p] = new StringBuilder(pre[1] + cur[1]).append(charArray, pre[0], pre[1]).append(charArray, cur[0], cur[1]).toString();
            pre = cur;
        }
        return termArray;
    }
}

