/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.server;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.netbeans.modules.selenium2.server.Bundle;
import org.netbeans.modules.selenium2.server.Selenium2ServerSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Selenium2Customizer
extends JPanel {
    private DialogDescriptor descriptor;
    private JButton bFirefoxProfileDir;
    private JButton bSeleniumServerJar;
    private JButton bUserExtensionFile;
    private JCheckBox cbSingleWindow;
    private JLabel labelFirefoxProfileDir;
    private JLabel labelPort;
    private JLabel labelSeleniumServerJar;
    private JLabel labelUserExtensionFile;
    private JSpinner spinnerPort;
    private JTextField tfFirefoxProfileDir;
    private JTextField tfSeleniumServerJar;
    private JTextField tfUserExtensionFile;

    public Selenium2Customizer() {
        this.initComponents();
        this.assignTooltips();
        this.assignPersistedValues();
    }

    private void assignTooltips() {
        this.tfSeleniumServerJar.setToolTipText("<html><pre>" + Bundle.Tooltip_SeleniumServerJar() + "</pre></html>");
        this.bSeleniumServerJar.setToolTipText("<html><pre>" + Bundle.Tooltip_SeleniumServerJar() + "</pre></html>");
        this.tfFirefoxProfileDir.setToolTipText("<html><pre>" + Bundle.Tooltip_FirefoxProfileDir() + "</pre></html>");
        this.bFirefoxProfileDir.setToolTipText("<html><pre>" + Bundle.Tooltip_FirefoxProfileDir() + "</pre></html>");
        this.tfUserExtensionFile.setToolTipText("<html><pre>" + Bundle.Tooltip_UserExtensionFile() + "</pre></html>");
        this.bUserExtensionFile.setToolTipText("<html><pre>" + Bundle.Tooltip_UserExtensionFile() + "</pre></html>");
        this.spinnerPort.setToolTipText("<html><pre>" + Bundle.Tooltip_Port() + "</pre></html>");
        this.cbSingleWindow.setToolTipText("<html><pre>" + Bundle.Tooltip_SingleWindow() + "</pre></html>");
    }

    private void assignPersistedValues() {
        String l = Selenium2Customizer.getSeleniumServerJarLocation();
        this.tfSeleniumServerJar.setText(l == null ? "" : l);
        this.tfFirefoxProfileDir.setText(Selenium2ServerSupport.getPrefs().get("firefox.profile.template.dir", ""));
        this.tfUserExtensionFile.setText(Selenium2ServerSupport.getPrefs().get("user.extension.file", ""));
        this.spinnerPort.setValue(Selenium2ServerSupport.getPrefs().getInt("port", 4444));
        this.cbSingleWindow.setSelected(Selenium2ServerSupport.getPrefs().getBoolean("single.window", false));
    }

    public static boolean showCustomizer() {
        Selenium2Customizer panel = new Selenium2Customizer();
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.MSG_CONFIGURE());
        panel.setDescriptor(descriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setModal(true);
        dialog.setVisible(true);
        dialog.dispose();
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
            Selenium2ServerSupport.getPrefs().put("selenium.server.jar", panel.tfSeleniumServerJar.getText());
            Selenium2ServerSupport.getPrefs().put("firefox.profile.template.dir", panel.tfFirefoxProfileDir.getText());
            Selenium2ServerSupport.getPrefs().put("user.extension.file", panel.tfUserExtensionFile.getText());
            Selenium2ServerSupport.getPrefs().putInt("port", Integer.parseInt(panel.spinnerPort.getValue().toString()));
            Selenium2ServerSupport.getPrefs().putBoolean("single.window", panel.cbSingleWindow.isSelected());
            return true;
        }
        return false;
    }

    private static String getSeleniumServerJarLocation() {
        return Selenium2ServerSupport.getPrefs().get("selenium.server.jar", null);
    }

    private void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
        this.updateValidity();
    }

    private void updateValidity() {
        this.descriptor.setValid(Selenium2Customizer.isValidJSTestDriverJar(this.tfSeleniumServerJar.getText()));
    }

    private static boolean isValidJSTestDriverJar(String s) {
        if (s == null) {
            return false;
        }
        File f = new File(s);
        return f.exists() && Selenium2Customizer.isValidFileName(f);
    }

    private static boolean isValidFileName(File f) {
        return f.getName().toLowerCase().startsWith("selenium-server-standalone") && f.getName().toLowerCase().endsWith(".jar");
    }

    public static boolean isConfiguredProperly() {
        return Selenium2Customizer.isValidJSTestDriverJar(Selenium2Customizer.getSeleniumServerJarLocation());
    }

    public static String getJSTestDriverJar() {
        return Selenium2Customizer.getSeleniumServerJarLocation();
    }

    private void initComponents() {
        this.labelSeleniumServerJar = new JLabel();
        this.tfSeleniumServerJar = new JTextField();
        this.bSeleniumServerJar = new JButton();
        this.labelFirefoxProfileDir = new JLabel();
        this.tfFirefoxProfileDir = new JTextField();
        this.bFirefoxProfileDir = new JButton();
        this.labelUserExtensionFile = new JLabel();
        this.tfUserExtensionFile = new JTextField();
        this.bUserExtensionFile = new JButton();
        this.labelPort = new JLabel();
        this.cbSingleWindow = new JCheckBox();
        this.spinnerPort = new JSpinner();
        this.labelSeleniumServerJar.setLabelFor(this.tfSeleniumServerJar);
        Mnemonics.setLocalizedText((JLabel)this.labelSeleniumServerJar, (String)NbBundle.getMessage(Selenium2Customizer.class, (String)"Selenium2Customizer.labelSeleniumServerJar.text"));
        this.tfSeleniumServerJar.setEditable(false);
        this.tfSeleniumServerJar.setColumns(15);
        Mnemonics.setLocalizedText((AbstractButton)this.bSeleniumServerJar, (String)NbBundle.getMessage(Selenium2Customizer.class, (String)"Selenium2Customizer.bSeleniumServerJar.text"));
        this.bSeleniumServerJar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Selenium2Customizer.this.bSeleniumServerJarActionPerformed(evt);
            }
        });
        this.labelFirefoxProfileDir.setLabelFor(this.tfFirefoxProfileDir);
        Mnemonics.setLocalizedText((JLabel)this.labelFirefoxProfileDir, (String)NbBundle.getMessage(Selenium2Customizer.class, (String)"Selenium2Customizer.labelFirefoxProfileDir.text"));
        this.tfFirefoxProfileDir.setEditable(false);
        this.tfFirefoxProfileDir.setColumns(15);
        Mnemonics.setLocalizedText((AbstractButton)this.bFirefoxProfileDir, (String)NbBundle.getMessage(Selenium2Customizer.class, (String)"Selenium2Customizer.bFirefoxProfileDir.text"));
        this.bFirefoxProfileDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Selenium2Customizer.this.bFirefoxProfileDirActionPerformed(evt);
            }
        });
        this.labelUserExtensionFile.setLabelFor(this.tfUserExtensionFile);
        Mnemonics.setLocalizedText((JLabel)this.labelUserExtensionFile, (String)NbBundle.getMessage(Selenium2Customizer.class, (String)"Selenium2Customizer.labelUserExtensionFile.text"));
        this.tfUserExtensionFile.setEditable(false);
        this.tfUserExtensionFile.setColumns(15);
        Mnemonics.setLocalizedText((AbstractButton)this.bUserExtensionFile, (String)NbBundle.getMessage(Selenium2Customizer.class, (String)"Selenium2Customizer.bUserExtensionFile.text"));
        this.bUserExtensionFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Selenium2Customizer.this.bUserExtensionFileActionPerformed(evt);
            }
        });
        this.labelPort.setLabelFor(this.spinnerPort);
        Mnemonics.setLocalizedText((JLabel)this.labelPort, (String)NbBundle.getMessage(Selenium2Customizer.class, (String)"Selenium2Customizer.labelPort.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSingleWindow, (String)NbBundle.getMessage(Selenium2Customizer.class, (String)"Selenium2Customizer.cbSingleWindow.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelSeleniumServerJar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSeleniumServerJar, -1, 256, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSeleniumServerJar)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelFirefoxProfileDir).addComponent(this.labelUserExtensionFile).addGroup(layout.createSequentialGroup().addComponent(this.labelPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerPort, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbSingleWindow).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.tfUserExtensionFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bUserExtensionFile)).addGroup(layout.createSequentialGroup().addComponent(this.tfFirefoxProfileDir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bFirefoxProfileDir))))).addContainerGap()));
        layout.linkSize(0, this.labelFirefoxProfileDir, this.labelSeleniumServerJar, this.labelUserExtensionFile);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSeleniumServerJar).addComponent(this.bSeleniumServerJar).addComponent(this.tfSeleniumServerJar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelFirefoxProfileDir).addComponent(this.bFirefoxProfileDir).addComponent(this.tfFirefoxProfileDir, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelUserExtensionFile).addComponent(this.bUserExtensionFile).addComponent(this.tfUserExtensionFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelPort).addComponent(this.spinnerPort, -2, -1, -2).addComponent(this.cbSingleWindow)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.bFirefoxProfileDir, this.bSeleniumServerJar, this.bUserExtensionFile, this.labelFirefoxProfileDir, this.labelSeleniumServerJar, this.labelUserExtensionFile, this.tfFirefoxProfileDir, this.tfSeleniumServerJar, this.tfUserExtensionFile);
        layout.linkSize(1, this.cbSingleWindow, this.labelPort, this.spinnerPort);
    }

    private void bSeleniumServerJarActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileNameExtensionFilter("Jar File", "jar"));
        chooser.setSelectedFile(new File(this.tfSeleniumServerJar.getText().trim()));
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.tfSeleniumServerJar.setText(chooser.getSelectedFile().getAbsolutePath());
            this.updateValidity();
        }
    }

    private void bFirefoxProfileDirActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(new File(this.tfFirefoxProfileDir.getText().trim()));
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.tfFirefoxProfileDir.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void bUserExtensionFileActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileNameExtensionFilter("Javascript File", "js"));
        chooser.setSelectedFile(new File(this.tfUserExtensionFile.getText().trim()));
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.tfUserExtensionFile.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }
}

