/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.svg;

import com.github.weisj.jsvg.attributes.AttributeParser;
import com.github.weisj.jsvg.parser.ElementLoader;
import com.github.weisj.jsvg.parser.ParsedDocument;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

class DenyingElementLoader
implements ElementLoader {
    private final Set<String> attemptedExternalURLsLoaded = new LinkedHashSet<String>();

    DenyingElementLoader() {
    }

    public Set<String> getAttemptedExternalURLsLoaded() {
        return Collections.unmodifiableSet(this.attemptedExternalURLsLoaded);
    }

    public <T> T loadElement(Class<T> type, String value, ParsedDocument document, AttributeParser attributeParser) {
        String url = attributeParser.parseUrl(value);
        if (url == null) {
            return null;
        }
        if (url.contains("#")) {
            String[] parts = url.split("#", 2);
            String name = parts[0];
            if (!name.isEmpty()) {
                this.attemptedExternalURLsLoaded.add(value);
                return null;
            }
            return (T)document.getElementById(type, parts[1]);
        }
        return (T)document.getElementById(type, url);
    }
}

