/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.developer;

import com.oracle.bmc.artifacts.ArtifactsClient;
import com.oracle.bmc.artifacts.model.ContainerRepository;
import com.oracle.bmc.artifacts.requests.GetContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.ListContainerRepositoriesRequest;
import com.oracle.bmc.artifacts.responses.GetContainerRepositoryResponse;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.developer.Bundle;
import org.netbeans.modules.cloud.oracle.developer.ContainerRepositoryItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;

public class ContainerRepositoryNode
extends OCINode {
    private static final String CONTAINER_REPOSITORY_ICON = "org/netbeans/modules/cloud/oracle/resources/containerrepository.svg";

    public ContainerRepositoryNode(ContainerRepositoryItem instance) {
        super(instance);
        this.setName(instance.getName());
        this.setDisplayName(instance.getName());
        this.setIconBaseWithExtension(CONTAINER_REPOSITORY_ICON);
        this.setShortDescription(Bundle.ContainerRepositoryDesc(instance.getName(), instance.getUrl()));
    }

    public static NodeProvider<ContainerRepositoryItem> createNode() {
        return ContainerRepositoryNode::new;
    }

    @Override
    public void update(OCIItem item) {
        ContainerRepositoryItem orig = (ContainerRepositoryItem)item;
        ArtifactsClient client = OCIManager.getDefault().getActiveProfile(item).newClient(ArtifactsClient.class);
        GetContainerRepositoryRequest listContainerRepositoriesRequest = GetContainerRepositoryRequest.builder().repositoryId(item.getKey().getValue()).build();
        GetContainerRepositoryResponse response = client.getContainerRepository(listContainerRepositoriesRequest);
        ContainerRepository cr = response.getContainerRepository();
        orig.setImageCount(cr.getImageCount());
    }

    public static ChildrenProvider.SessionAware<CompartmentItem, ContainerRepositoryItem> getContainerRepositories() {
        return (compartmentId, session) -> {
            ArtifactsClient client = session.newClient(ArtifactsClient.class);
            ListContainerRepositoriesRequest listContainerRepositoriesRequest = ListContainerRepositoriesRequest.builder().compartmentId(compartmentId.getKey().getValue()).build();
            String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
            return client.listContainerRepositories(listContainerRepositoriesRequest).getContainerRepositoryCollection().getItems().stream().map(d -> new ContainerRepositoryItem(OCID.of(d.getId(), "ContainerRepository"), compartmentId.getKey().getValue(), d.getDisplayName(), session.getRegion().getRegionCode(), d.getNamespace(), d.getIsPublic(), d.getImageCount(), tenancyId)).collect(Collectors.toList());
        };
    }
}

