/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.services.NbDialog;
import org.netbeans.core.windows.services.NbPresenter;
import org.netbeans.core.windows.services.PresenterDecorator;
import org.netbeans.core.windows.view.ui.DefaultSeparateContainer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DialogDisplayerImpl
extends DialogDisplayer {
    private static List<Runnable> run = Collections.synchronizedList(new ArrayList());
    private Object testResult;

    public DialogDisplayerImpl() {
        this(null);
    }

    DialogDisplayerImpl(Object testResult) {
        this.testResult = testResult;
    }

    public static void runDelayed() {
        NbPresenter.LOG.fine("runDelayed");
        List<Runnable> local = run;
        run = null;
        if (local == null) {
            NbPresenter.LOG.fine("runDelayed, nothing");
            return;
        }
        assert (EventQueue.isDispatchThread());
        for (Runnable r : local) {
            NbPresenter.LOG.fine("runDelayed, run = " + r);
            r.run();
        }
        NbPresenter.LOG.fine("runDelayed, done");
    }

    public Dialog createDialog(DialogDescriptor d) {
        return this.createDialog(d, null);
    }

    public Dialog createDialog(final DialogDescriptor d, final Frame preferredParent) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return (Dialog)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Dialog>(){
            final /* synthetic */ DialogDisplayerImpl this$0;
            {
                this.this$0 = this$0;
            }

            public Dialog run() {
                Component p;
                Window w = preferredParent;
                if (w != null && (p = Utilities.findDialogParent((Component)w)) != w) {
                    w = null;
                }
                if (!(w != null || (w = this.this$0.findDialogParent()) instanceof NbPresenter && w.isVisible() || w instanceof DefaultSeparateContainer.ModeUIBase)) {
                    Container cont = SwingUtilities.getAncestorOfClass(Window.class, w);
                    w = cont instanceof DefaultSeparateContainer.ModeUIBase ? (Window)cont : WindowManager.getDefault().getMainWindow();
                }
                NbDialog dlg = w instanceof Frame ? new NbDialog(d, (Frame)w) : (w instanceof Dialog ? new NbDialog(d, (Dialog)w) : new NbDialog(d, WindowManager.getDefault().getMainWindow()));
                DialogDisplayerImpl.customizeDlg(dlg);
                dlg.requestFocusInWindow();
                return dlg;
            }
        });
    }

    private Window findDialogParent() {
        Component parentComponent = Utilities.findDialogParent(null);
        Window parent = this.findDialogParent(parentComponent);
        if (parent == null || parent == JOptionPane.getRootFrame() || parent instanceof NbPresenter && ((NbPresenter)parent).isLeaf()) {
            return WindowManager.getDefault().getMainWindow();
        }
        return parent;
    }

    private Window findDialogParent(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return this.findDialogParent(component.getParent());
    }

    public Object notify(NotifyDescriptor descriptor) {
        return this.notify(descriptor, new AWTQuery(descriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object notify(NotifyDescriptor descriptor, AWTQuery query) {
        if (GraphicsEnvironment.isHeadless()) {
            return NotifyDescriptor.CLOSED_OPTION;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            query.showDialog();
            return descriptor.getValue();
        }
        AWTQuery aWTQuery = query;
        synchronized (aWTQuery) {
            SwingUtilities.invokeLater(query);
            try {
                query.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (query.running) {
                while (query.result == null) {
                    try {
                        query.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return query.result;
            }
            return NotifyDescriptor.CLOSED_OPTION;
        }
    }

    public void notifyLater(NotifyDescriptor descriptor) {
        this.notifyLater(new AWTQuery(descriptor));
    }

    private void notifyLater(AWTQuery q) {
        Runnable r = () -> this.notify(q.descriptor, q);
        List<Runnable> local = run;
        if (local != null) {
            q.noParent = true;
            local.add(r);
        } else {
            Mutex.EVENT.postReadRequest(r);
        }
    }

    private static void customizeDlg(NbPresenter presenter) {
        for (PresenterDecorator p : Lookup.getDefault().lookupAll(PresenterDecorator.class)) {
            p.customizePresenter(presenter);
        }
    }

    public <T extends NotifyDescriptor> CompletableFuture<T> notifyFuture(T descriptor) {
        class AWTQuery2
        extends AWTQuery {
            volatile CompletableFuture res;

            public AWTQuery2(NotifyDescriptor descriptor) {
                super(descriptor);
            }

            @Override
            public void showDialog() {
                try {
                    super.showDialog();
                    Object r = this.descriptor.getValue();
                    if (this.cancelled || r == NotifyDescriptor.CLOSED_OPTION || r == NotifyDescriptor.CANCEL_OPTION) {
                        this.res.completeExceptionally(new CancellationException());
                    } else {
                        this.res.complete(this.descriptor);
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    this.res.completeExceptionally(t);
                }
            }
        }
        final AWTQuery2 q = new AWTQuery2(descriptor);
        class CF
        extends CompletableFuture<T> {
            final /* synthetic */ DialogDisplayerImpl this$0;

            CF() {
                this.this$0 = this$0;
                q.res = this;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (this.isDone()) {
                    return false;
                }
                q.cancel(mayInterruptIfRunning);
                return super.cancel(mayInterruptIfRunning);
            }
        }
        CF cf = new CF();
        q.res = cf;
        this.notifyLater(q);
        return cf;
    }

    class AWTQuery
    implements Runnable {
        public final NotifyDescriptor descriptor;
        public Object result;
        public boolean running;
        public volatile boolean noParent;
        public volatile boolean cancelled;
        NbPresenter presenter;

        public AWTQuery(NotifyDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AWTQuery aWTQuery = this;
            synchronized (aWTQuery) {
                this.notify();
                this.running = true;
            }
            this.showDialog();
            aWTQuery = this;
            synchronized (aWTQuery) {
                this.result = this.descriptor.getValue();
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean cancel(boolean cancelIfRunning) {
            NbPresenter p;
            AWTQuery aWTQuery = this;
            synchronized (aWTQuery) {
                if (this.cancelled) {
                    return false;
                }
                if (this.running && !cancelIfRunning) {
                    return false;
                }
                this.cancelled = true;
                p = this.presenter;
                if (p == null) {
                    return true;
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                p.setVisible(false);
            } else {
                SwingUtilities.invokeLater(() -> p.setVisible(false));
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showDialog() {
            Window parent;
            Object win;
            if (this.cancelled) {
                this.descriptor.setValue(NotifyDescriptor.CLOSED_OPTION);
                return;
            }
            if (DialogDisplayerImpl.this.testResult != null) {
                this.descriptor.setValue(DialogDisplayerImpl.this.testResult);
                return;
            }
            Component focusOwner = null;
            TopComponent comp = TopComponent.getRegistry().getActivated();
            for (win = comp; win != null && !(win instanceof Window); win = ((Component)win).getParent()) {
            }
            if (win != null) {
                focusOwner = ((Window)win).getFocusOwner();
            }
            Window window = parent = this.noParent ? null : DialogDisplayerImpl.this.findDialogParent();
            NbPresenter presenter = this.descriptor instanceof DialogDescriptor ? (parent instanceof Dialog ? new NbDialog((DialogDescriptor)this.descriptor, (Dialog)parent) : (parent instanceof Frame ? new NbDialog((DialogDescriptor)this.descriptor, (Frame)parent) : new NbDialog((DialogDescriptor)this.descriptor, (Frame)null))) : (parent instanceof Dialog ? new NbPresenter(this.descriptor, (Dialog)parent, true) : (parent instanceof Frame ? new NbPresenter(this.descriptor, (Frame)parent, true) : new NbPresenter(this.descriptor, (Frame)null, true)));
            AWTQuery aWTQuery = this;
            synchronized (aWTQuery) {
                this.presenter = presenter;
            }
            if ("true".equals(System.getProperty("javahelp.ignore.modality"))) {
                presenter.getRootPane().putClientProperty("javahelp.ignore.modality", "true");
                System.setProperty("javahelp.ignore.modality", "false");
            }
            DialogDisplayerImpl.customizeDlg(presenter);
            presenter.getRootPane().requestDefaultFocus();
            presenter.setVisible(true);
            if (focusOwner != null) {
                ((Component)win).requestFocusInWindow();
                comp.requestFocusInWindow();
                if (!(focusOwner instanceof JRootPane)) {
                    focusOwner.requestFocusInWindow();
                }
            }
        }
    }
}

