/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.queriesimpl;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class TemplateWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    private transient WizardDescriptor wiz;
    private transient WizardDescriptor.Panel superclassPanel;
    private transient boolean superclassPanelCurrent;
    private transient WizardDescriptor.InstantiatingIterator delegateIterator = JavaTemplates.createJavaTemplateIterator();
    private boolean specifySuperclass;

    public static TemplateWizardIterator createForSuperclass() {
        return new TemplateWizardIterator(true);
    }

    public static TemplateWizardIterator create() {
        return new TemplateWizardIterator(false);
    }

    public TemplateWizardIterator(boolean specifySuperclass) {
        this.specifySuperclass = specifySuperclass;
    }

    public void initialize(WizardDescriptor wizard) {
        this.wiz = wizard;
        this.delegateIterator.initialize(wizard);
        this.superclassPanelCurrent = false;
        if (this.superclassPanel == null && this.specifySuperclass) {
            this.superclassPanel = new SuperclassWizardPanel();
            ResourceBundle bundle = NbBundle.getBundle(TemplateWizardIterator.class);
            JComponent comp = (JComponent)this.delegateIterator.current().getComponent();
            String[] contentData = (String[])comp.getClientProperty("WizardPanel_contentData");
            String[] newContentData = new String[contentData.length + 1];
            System.arraycopy(contentData, 0, newContentData, 0, contentData.length);
            newContentData[contentData.length] = bundle.getString("CTL_SuperclassTitle");
            comp.putClientProperty("WizardPanel_contentData", newContentData);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.delegateIterator.uninitialize(wizard);
        this.superclassPanel = null;
    }

    public Set instantiate() throws IOException, IllegalArgumentException {
        Set set = this.delegateIterator.instantiate();
        FileObject template = (FileObject)set.iterator().next();
        if (this.wiz instanceof TemplateWizard) {
            Logger logger = Logger.getLogger("org.netbeans.ui.metrics.form");
            LogRecord rec = new LogRecord(Level.INFO, "USG_FORM_CREATED");
            rec.setLoggerName(logger.getName());
            rec.setParameters(new Object[]{((TemplateWizard)this.wiz).getTemplate().getName()});
            logger.log(rec);
        }
        if (this.specifySuperclass) {
            final String className = template.getName();
            final String superclassName = ((SuperclassWizardPanel)this.superclassPanel).getSuperclassName();
            JavaSource js = JavaSource.forFileObject((FileObject)template);
            js.runModificationTask((Task)new CancellableTask<WorkingCopy>(){
                final /* synthetic */ TemplateWizardIterator this$0;
                {
                    this.this$0 = this$0;
                }

                public void cancel() {
                }

                public void run(WorkingCopy wcopy) throws Exception {
                    wcopy.toPhase(JavaSource.Phase.RESOLVED);
                    for (Tree tree : wcopy.getCompilationUnit().getTypeDecls()) {
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !className.equals(((ClassTree)tree).getSimpleName().toString())) continue;
                        ClassTree orig = (ClassTree)tree;
                        TreeMaker maker = wcopy.getTreeMaker();
                        TypeElement superclassElm = wcopy.getElements().getTypeElement(superclassName);
                        ExpressionTree extendsTree = superclassElm != null ? maker.QualIdent((Element)superclassElm) : maker.Identifier((CharSequence)superclassName);
                        ClassTree copy = maker.setExtends(orig, extendsTree);
                        wcopy.rewrite((Tree)orig, (Tree)copy);
                        break;
                    }
                }
            }).commit();
        }
        template.setAttribute("justCreatedByNewWizard", (Object)Boolean.TRUE);
        return set;
    }

    public WizardDescriptor.Panel current() {
        return this.superclassPanelCurrent ? this.superclassPanel : this.delegateIterator.current();
    }

    public boolean hasNext() {
        return this.delegateIterator.hasNext() || !this.superclassPanelCurrent && this.superclassPanel != null;
    }

    public boolean hasPrevious() {
        return this.superclassPanelCurrent ? true : this.delegateIterator.hasPrevious();
    }

    public void nextPanel() {
        if (this.delegateIterator.hasNext()) {
            this.delegateIterator.nextPanel();
        } else {
            if (this.superclassPanelCurrent || this.superclassPanel == null) {
                throw new NoSuchElementException();
            }
            this.superclassPanelCurrent = true;
        }
    }

    public void previousPanel() {
        if (this.superclassPanelCurrent) {
            this.superclassPanelCurrent = false;
        } else {
            this.delegateIterator.previousPanel();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.delegateIterator.addChangeListener(l);
    }

    public String name() {
        return this.superclassPanelCurrent ? "" : this.delegateIterator.name();
    }

    public void removeChangeListener(ChangeListener l) {
        this.delegateIterator.removeChangeListener(l);
    }

    static class SuperclassWizardPanel
    implements WizardDescriptor.FinishablePanel {
        private SuperclassPanel panelUI;

        SuperclassWizardPanel() {
        }

        String getSuperclassName() {
            String name = this.panelUI != null ? this.panelUI.superclassTextField.getText() : null;
            return name != null && !"".equals(name) ? name : "java.lang.Object";
        }

        public Component getComponent() {
            if (this.panelUI == null) {
                this.panelUI = new SuperclassPanel();
            }
            return this.panelUI;
        }

        public boolean isValid() {
            return true;
        }

        public void readSettings(Object settings) {
        }

        public void storeSettings(Object settings) {
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public HelpCtx getHelp() {
            return new HelpCtx("gui.creatingforms");
        }

        public boolean isFinishPanel() {
            return true;
        }
    }

    static class SuperclassPanel
    extends JPanel {
        private JLabel label1;
        private JTextField superclassTextField;

        SuperclassPanel() {
            ResourceBundle bundle = NbBundle.getBundle(TemplateWizardIterator.class);
            this.setName(bundle.getString("CTL_SuperclassTitle"));
            this.putClientProperty("WizardPanel_contentSelectedIndex", 1);
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SuperclassPanel"));
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(8, 8, 8, 8));
            this.label1 = new JLabel();
            this.superclassTextField = new JTextField();
            this.label1.setLabelFor(this.superclassTextField);
            this.label1.setText(bundle.getString("CTL_SuperclassName"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            this.add((Component)this.label1, gridBagConstraints);
            this.superclassTextField.setText("java.lang.Object");
            this.superclassTextField.setToolTipText(bundle.getString("CTL_SuperclassName_Hint"));
            this.superclassTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_SuperclassTextField"));
            this.superclassTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    superclassTextField.selectAll();
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.superclassTextField, gridBagConstraints);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.superclassTextField.requestFocus();
        }
    }
}

