/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.BookmarkUtils;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BookmarksPersistence
implements PropertyChangeListener,
Runnable {
    private static final String EDITOR_BOOKMARKS_1_NAMESPACE_URI = "http://www.netbeans.org/ns/editor-bookmarks/1";
    private static final String EDITOR_BOOKMARKS_2_NAMESPACE_URI = "http://www.netbeans.org/ns/editor-bookmarks/2";
    private static final BookmarksPersistence INSTANCE = new BookmarksPersistence();
    private static RequestProcessor RP = new RequestProcessor("Bookmarks loader and saver", 1, false, false);
    private static final Logger LOG = Logger.getLogger(BookmarksPersistence.class.getName());
    private final Set<Project> activeProjects = new HashSet<Project>();
    private final List<Project> lastOpenProjects = new ArrayList<Project>();
    private boolean openProjectsListening;
    private boolean keepOpenProjectsBookmarksLoaded;

    public static BookmarksPersistence get() {
        return INSTANCE;
    }

    private BookmarksPersistence() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RequestProcessor.Task postTask(Runnable run) {
        boolean listening;
        List<Project> list = this.lastOpenProjects;
        synchronized (list) {
            listening = this.openProjectsListening;
            this.openProjectsListening = true;
        }
        if (!listening) {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Future openProjectsFuture = OpenProjects.getDefault().openProjects();
                    try {
                        openProjectsFuture.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    OpenProjects openProjects = OpenProjects.getDefault();
                    List<Project> projects = Arrays.asList(openProjects.getOpenProjects());
                    List list = BookmarksPersistence.this.lastOpenProjects;
                    synchronized (list) {
                        BookmarksPersistence.this.lastOpenProjects.addAll(projects);
                    }
                    openProjects.addPropertyChangeListener((PropertyChangeListener)BookmarksPersistence.this);
                }
            });
        }
        return RP.post(run);
    }

    RequestProcessor.Task createTask(Runnable r) {
        return RP.create(r, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endProjectsListening() {
        boolean listening;
        List<Project> list = this.lastOpenProjects;
        synchronized (list) {
            this.keepOpenProjectsBookmarksLoaded = false;
            listening = this.openProjectsListening;
        }
        if (listening) {
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            this.postTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
                    try {
                        List<ProjectBookmarks> activeProjectBookmarks = lockedBookmarkManager.activeProjectBookmarks();
                        for (ProjectBookmarks projectBookmarks : activeProjectBookmarks) {
                            URI projectURI = projectBookmarks.getProjectURI();
                            Project project = BookmarkUtils.findProject(projectURI);
                            if (project == null) continue;
                            BookmarksPersistence.this.saveProjectBookmarks(project, projectBookmarks);
                            lockedBookmarkManager.releaseProjectBookmarks(projectBookmarks);
                        }
                    }
                    finally {
                        lockedBookmarkManager.unlock();
                    }
                    List list = BookmarksPersistence.this.lastOpenProjects;
                    synchronized (list) {
                        BookmarksPersistence.this.activeProjects.clear();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Project> lastOpenProjects() {
        List<Project> list = this.lastOpenProjects;
        synchronized (list) {
            return new ArrayList<Project>(this.lastOpenProjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keepOpenProjectsBookmarksLoaded() {
        List<Project> list = this.lastOpenProjects;
        synchronized (list) {
            this.keepOpenProjectsBookmarksLoaded = true;
        }
        this.postTask(new Runnable(){

            @Override
            public void run() {
                BookmarksPersistence.this.loadBookmarksUnderLock(BookmarksPersistence.this.lastOpenProjects());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBookmarksUnderLock(List<Project> prjs) {
        BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            for (Project project : prjs) {
                lockedBookmarkManager.getProjectBookmarks(project, true, true);
            }
        }
        finally {
            lockedBookmarkManager.unlock();
        }
    }

    private void checkRPThread() {
        assert (RP.isRequestProcessorThread()) : "Not a dedicated RequestProcessor thread.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadProjectBookmarks(final ProjectBookmarks projectBookmarks, final Project project) {
        this.checkRPThread();
        if (projectBookmarks.isLoaded()) {
            return;
        }
        projectBookmarks.markLoaded();
        final BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            ProjectManager.mutex().readAccess(new Runnable(){
                final /* synthetic */ BookmarksPersistence this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.loadProjectBookmarksImpl(lockedBookmarkManager, projectBookmarks, project);
                }
            });
        }
        finally {
            lockedBookmarkManager.unlock();
        }
    }

    private void loadProjectBookmarksImpl(BookmarkManager lockedBookmarkManager, ProjectBookmarks projectBookmarks, Project project) {
        int version = 2;
        URI projectURI = project.getProjectDirectory().toURI();
        AuxiliaryConfiguration ac = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        if (LOG.isLoggable(Level.FINE)) {
            int pbIHC = System.identityHashCode(projectBookmarks);
            int projectHashCode = project != null ? project.hashCode() : 0;
            int ihc = System.identityHashCode(project);
            LOG.log(Level.FINE, "Loading ProjectBookmarks(IHC={0,number,#}) for project={1} hashCode={2,number,#}, IHC={3,number,#}\n  URI={4}, AuxiliaryConfiguration: {5}\n", new Object[]{pbIHC, project, projectHashCode, ihc, projectURI, ac});
        }
        Element bookmarksElement = ac.getConfigurationFragment("editor-bookmarks", EDITOR_BOOKMARKS_2_NAMESPACE_URI, false);
        int lastBookmarkId = 0;
        if (bookmarksElement != null) {
            String lastBookmarkIdText = bookmarksElement.getAttribute("lastBookmarkId");
            try {
                lastBookmarkId = Integer.parseInt(lastBookmarkIdText);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "  Found lastBookmarkId={0}\n", lastBookmarkId);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            version = 1;
            bookmarksElement = ac.getConfigurationFragment("editor-bookmarks", EDITOR_BOOKMARKS_1_NAMESPACE_URI, false);
            if (bookmarksElement == null) {
                return;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "  Will use lastBookmarkId={0}\n", lastBookmarkId);
        }
        projectBookmarks.setLastBookmarkId(lastBookmarkId);
        Node fileElem = BookmarksPersistence.skipNonElementNode(bookmarksElement.getFirstChild());
        while (fileElem != null) {
            assert ("file".equals(fileElem.getNodeName()));
            Node urlElem = BookmarksPersistence.skipNonElementNode(fileElem.getFirstChild());
            assert ("url".equals(urlElem.getNodeName()));
            Node lineOrBookmarkElem = BookmarksPersistence.skipNonElementNode(urlElem.getNextSibling());
            ArrayList<BookmarkInfo> bookmarks = new ArrayList<BookmarkInfo>();
            while (lineOrBookmarkElem != null) {
                String nodeName = lineOrBookmarkElem.getNodeName();
                try {
                    BookmarkInfo bookmarkInfo;
                    int id;
                    if (version == 2) {
                        assert ("bookmark".equals(nodeName));
                        assert (lineOrBookmarkElem.getNodeType() == 1);
                        Element bookmarkElem = (Element)lineOrBookmarkElem;
                        id = -1;
                        if (bookmarkElem.hasAttributes()) {
                            String idText = bookmarkElem.getAttribute("id");
                            try {
                                id = Integer.parseInt(idText);
                                projectBookmarks.ensureBookmarkIdIsSkipped(id);
                                if (LOG.isLoggable(Level.FINER)) {
                                    LOG.log(Level.FINER, "  id={0}\n", id);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (id == -1) {
                            id = projectBookmarks.generateBookmarkId();
                            if (LOG.isLoggable(Level.FINER)) {
                                LOG.log(Level.FINER, "  id-generated:{0}\n", id);
                            }
                        }
                        Node nameElem = BookmarksPersistence.skipNonElementNode(lineOrBookmarkElem.getFirstChild());
                        assert ("name".equals(nameElem.getNodeName()));
                        Node nameTextNode = nameElem.getFirstChild();
                        String name = nameTextNode != null ? nameTextNode.getNodeValue() : "";
                        Node lineElem = BookmarksPersistence.skipNonElementNode(nameElem.getNextSibling());
                        int lineIndex = BookmarksPersistence.parseLineIndex(lineElem);
                        Node keyElem = BookmarksPersistence.skipNonElementNode(lineElem.getNextSibling());
                        Node keyTextNode = keyElem.getFirstChild();
                        String key = keyTextNode != null ? keyTextNode.getNodeValue() : "";
                        bookmarkInfo = BookmarkInfo.create(id, name, lineIndex, key);
                    } else {
                        int lineIndex = BookmarksPersistence.parseLineIndex(lineOrBookmarkElem);
                        id = projectBookmarks.getLastBookmarkId();
                        bookmarkInfo = BookmarkInfo.create(id, "", lineIndex, "");
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "    Bookmark found: {0}\n", bookmarkInfo);
                    }
                    bookmarks.add(bookmarkInfo);
                }
                catch (DOMException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                catch (NumberFormatException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                lineOrBookmarkElem = BookmarksPersistence.skipNonElementNode(lineOrBookmarkElem.getNextSibling());
            }
            bookmarks.trimToSize();
            try {
                try {
                    Node urlElemText = urlElem.getFirstChild();
                    String relOrAbsURLString = urlElemText.getNodeValue();
                    URI uri = new URI(relOrAbsURLString);
                    FileBookmarks fileBookmarks = lockedBookmarkManager.getOrAddFileBookmarks(projectBookmarks, uri);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "  File URI: {0} found and paired with preceding bookmarks\n", uri);
                    }
                    for (BookmarkInfo bookmark : bookmarks) {
                        lockedBookmarkManager.addBookmark(fileBookmarks, bookmark);
                    }
                }
                catch (URISyntaxException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            catch (DOMException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            fileElem = BookmarksPersistence.skipNonElementNode(fileElem.getNextSibling());
        }
    }

    static int parseLineIndex(Node lineElem) {
        assert ("line".equals(lineElem.getNodeName()));
        Node lineElemText = lineElem.getFirstChild();
        String lineIndexString = lineElemText.getNodeValue();
        return Integer.parseInt(lineIndexString);
    }

    private static Node skipNonElementNode(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return node;
    }

    private void saveProjectBookmarks(Project project, ProjectBookmarks projectBookmarks) {
        this.checkRPThread();
        if (!projectBookmarks.isModified()) {
            return;
        }
        if (!projectBookmarks.isLoaded()) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Saving bookmarks for project={0} ...\n", projectBookmarks.getProjectURI());
        }
        if (project == null) {
            return;
        }
        if (!ProjectManager.getDefault().isValid(project)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "  Bookmarks not saved! Project is not valid.\n");
            }
            return;
        }
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        boolean legacy = false;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            String namespaceURI = legacy ? EDITOR_BOOKMARKS_1_NAMESPACE_URI : EDITOR_BOOKMARKS_2_NAMESPACE_URI;
            Element bookmarksElem = document.createElementNS(namespaceURI, "editor-bookmarks");
            bookmarksElem.setAttribute("lastBookmarkId", String.valueOf(projectBookmarks.getLastBookmarkId()));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "  lastBookmarkId: {0}\n", projectBookmarks.getLastBookmarkId());
            }
            for (FileBookmarks fileBookmarks : projectBookmarks.getFileBookmarks()) {
                List<BookmarkInfo> bookmarkInfos = fileBookmarks.getBookmarks();
                if (bookmarkInfos.isEmpty()) continue;
                Element fileElem = document.createElementNS(namespaceURI, "file");
                Element urlElem = document.createElementNS(namespaceURI, "url");
                String uri = fileBookmarks.getRelativeURI().toString();
                urlElem.appendChild(document.createTextNode(uri));
                fileElem.appendChild(urlElem);
                for (BookmarkInfo bookmarkInfo : bookmarkInfos) {
                    if (legacy) {
                        Element lineElem = document.createElementNS(namespaceURI, "line");
                        lineElem.appendChild(document.createTextNode(Integer.toString(bookmarkInfo.getLineIndex())));
                        fileElem.appendChild(lineElem);
                    } else {
                        Element nameElem = document.createElementNS(namespaceURI, "name");
                        nameElem.appendChild(document.createTextNode(bookmarkInfo.getName()));
                        Element lineElem = document.createElementNS(namespaceURI, "line");
                        lineElem.appendChild(document.createTextNode(Integer.toString(bookmarkInfo.getLineIndex())));
                        Element keyElem = document.createElementNS(namespaceURI, "key");
                        keyElem.appendChild(document.createTextNode(String.valueOf(bookmarkInfo.getKey())));
                        Element bookmarkElem = document.createElementNS(namespaceURI, "bookmark");
                        bookmarkElem.setAttribute("id", String.valueOf(bookmarkInfo.getId()));
                        bookmarkElem.appendChild(nameElem);
                        bookmarkElem.appendChild(lineElem);
                        bookmarkElem.appendChild(keyElem);
                        fileElem.appendChild(bookmarkElem);
                    }
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.log(Level.FINE, "    Bookmark written: {0}\n", bookmarkInfo);
                }
                bookmarksElem.appendChild(fileElem);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "  File URI written: {0}\n", uri);
            }
            auxiliaryConfiguration.putConfigurationFragment(bookmarksElem, false);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "  Bookmarks for project={0} written successfully\n", projectBookmarks.getProjectURI());
            }
        }
        catch (ParserConfigurationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    @Override
    public void run() {
        final BookmarkManager lockedBookmarkManager = BookmarkManager.getLocked();
        try {
            ProjectManager.mutex().writeAccess(new Runnable(){
                final /* synthetic */ BookmarksPersistence this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean keepLoaded;
                    ArrayList projectsToSave;
                    List<Project> openProjects = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
                    List list = this.this$0.lastOpenProjects;
                    synchronized (list) {
                        this.this$0.lastOpenProjects.removeAll(openProjects);
                        projectsToSave = new ArrayList(this.this$0.lastOpenProjects);
                        this.this$0.lastOpenProjects.clear();
                        this.this$0.lastOpenProjects.addAll(openProjects);
                        keepLoaded = this.this$0.keepOpenProjectsBookmarksLoaded;
                    }
                    for (Project p : projectsToSave) {
                        ProjectBookmarks projectBookmarks = lockedBookmarkManager.getProjectBookmarks(p, false, false);
                        if (projectBookmarks == null || projectBookmarks.hasActiveClients()) continue;
                        this.this$0.saveProjectBookmarks(p, projectBookmarks);
                    }
                    if (keepLoaded) {
                        this.this$0.postTask(new Runnable(){

                            @Override
                            public void run() {
                                this$0.loadBookmarksUnderLock(this$0.lastOpenProjects());
                            }
                        });
                    }
                }
            });
        }
        finally {
            lockedBookmarkManager.unlock();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.postTask(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("Opened Projects:\n");
        List<Project> list = this.lastOpenProjects;
        synchronized (list) {
            for (Project p : this.lastOpenProjects) {
                sb.append("Project ").append(p).append('\n');
            }
        }
        sb.append("------------------------");
        return sb.toString();
    }
}

