/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.checkout;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.checkout.RevertChangesPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RevertChanges
implements ActionListener {
    private RevertChangesPanel panel;
    private final File[] roots;

    RevertChanges(File[] roots) {
        this.roots = roots;
        this.panel = new RevertChangesPanel();
        this.loadSettings();
        this.panel.revertAllRadioButton.addActionListener(this);
        this.panel.revertWTRadioButton.addActionListener(this);
        this.panel.revertIndexRadioButton.addActionListener(this);
        this.enableFields();
    }

    private void loadSettings() {
        GitModuleConfig config = GitModuleConfig.getDefault();
        this.panel.revertWTRadioButton.setSelected(config.getRevertWT());
        this.panel.removeWTNewCheckBox.setSelected(config.getRemoveWTNew());
        this.panel.revertAllRadioButton.setSelected(config.getRevertAll());
        this.panel.removeAllNewCheckBox.setSelected(config.getRemoveAllNew());
        this.panel.revertIndexRadioButton.setSelected(config.getRevertIndex());
    }

    void storeSettings() {
        GitModuleConfig config = GitModuleConfig.getDefault();
        config.putRevertAll(this.panel.revertAllRadioButton.isSelected());
        config.putRevertIndex(this.panel.revertIndexRadioButton.isSelected());
        config.putRevertWT(this.panel.revertWTRadioButton.isSelected());
        config.putRemoveAllNew(this.panel.removeAllNewCheckBox.isSelected());
        config.putRemoveWTNew(this.panel.removeWTNewCheckBox.isSelected());
    }

    boolean show() {
        JButton okButton = new JButton(NbBundle.getMessage(RevertChanges.class, (String)"LBL_RevertChanges.OKButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)okButton.getText());
        String label = this.roots.length != 1 ? NbBundle.getMessage(RevertChanges.class, (String)"CTL_RevertChanges.title.files", (Object)this.roots.length) : (Git.getInstance().getFileStatusCache().getStatus(this.roots[0]).isDirectory() ? NbBundle.getMessage(RevertChanges.class, (String)"CTL_RevertChanges.title.dir", (Object)this.roots[0].getName()) : NbBundle.getMessage(RevertChanges.class, (String)"CTL_RevertChanges.title.file", (Object)this.roots[0].getName()));
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(RevertChanges.class, (String)"CTL_RevertChanges.title", (Object)label), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, new HelpCtx(RevertChanges.class), null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        return okButton == dd.getValue();
    }

    boolean isRevertWT() {
        return this.panel.revertWTRadioButton.isSelected();
    }

    boolean isRevertAll() {
        return this.panel.revertAllRadioButton.isSelected();
    }

    boolean isRevertIndex() {
        return this.panel.revertIndexRadioButton.isSelected();
    }

    boolean isRemove() {
        return this.panel.removeAllNewCheckBox.isEnabled() && this.panel.removeAllNewCheckBox.isSelected() || this.panel.removeWTNewCheckBox.isEnabled() && this.panel.removeWTNewCheckBox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.revertAllRadioButton || e.getSource() == this.panel.revertWTRadioButton || e.getSource() == this.panel.revertIndexRadioButton) {
            this.enableFields();
        }
    }

    private void enableFields() {
        this.panel.removeAllNewCheckBox.setEnabled(this.panel.revertAllRadioButton.isSelected());
        this.panel.removeWTNewCheckBox.setEnabled(this.panel.revertWTRadioButton.isSelected());
    }
}

