/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text;

import java.awt.Component;
import java.awt.Point;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xml.sync.Synchronizator;
import org.netbeans.modules.xml.text.TextEditorSupport;
import org.netbeans.modules.xml.text.TextRepresentation;
import org.netbeans.modules.xml.util.Util;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.text.NbDocument;

public class XMLTextRepresentation
extends TextRepresentation {
    public XMLTextRepresentation(TextEditorSupport editor, Synchronizator sync) {
        super(editor, sync);
    }

    public void updateText(Object input) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("XMLTextRepresentation::updateText");
        }
        String in = (String)input;
        TextEditorSupport es = this.editor;
        if (es == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ EditorCookie val$es;
            final /* synthetic */ String val$in;
            final /* synthetic */ XMLTextRepresentation this$0;
            {
                this.val$es = editorCookie;
                this.val$in = string;
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.updateTextInAWT(this.val$es, this.val$in);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }

    private void updateTextInAWT(EditorCookie es, final String in) throws IOException, BadLocationException {
        StyledDocument tmpdoc = es.getDocument();
        if (tmpdoc == null) {
            tmpdoc = es.openDocument();
        }
        JEditorPane[] eps = es.getOpenedPanes();
        JEditorPane pane = null;
        JViewport port = null;
        int caretPosition = 0;
        Point viewPosition = null;
        if (eps != null) {
            pane = eps[0];
            caretPosition = pane.getCaretPosition();
            port = this.getParentViewport(pane);
            if (port != null) {
                viewPosition = port.getViewPosition();
            }
        }
        final Exception[] taskEx = new Exception[]{null};
        final StyledDocument sdoc = tmpdoc;
        Runnable task = new Runnable(){
            final /* synthetic */ XMLTextRepresentation this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    sdoc.remove(0, sdoc.getLength());
                    sdoc.insertString(0, in, null);
                }
                catch (Exception iex) {
                    taskEx[0] = iex;
                }
            }
        };
        NbDocument.runAtomicAsUser((StyledDocument)sdoc, (Runnable)task);
        if (eps != null) {
            try {
                pane.setCaretPosition(caretPosition);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            port.setViewPosition(viewPosition);
        }
        if (taskEx[0] != null) {
            if (taskEx[0] instanceof IOException) {
                throw (IOException)taskEx[0];
            }
            throw new IOException(taskEx[0]);
        }
    }

    @Override
    public void update(Object change) {
        if (change instanceof String) {
            String update = (String)change;
            this.updateText(update);
        }
    }

    @Override
    public boolean isModified() {
        return false;
    }

    private JViewport getParentViewport(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JViewport) {
            return (JViewport)component;
        }
        return this.getParentViewport(component.getParent());
    }
}

