/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeProcessingInstruction;

public class TreeProcessingInstructionCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = 1151841201717291218L;
    private JTextArea dataTextArea;
    private JLabel targetLabel;
    private JPanel dataPanel;
    private JTextField targetField;
    private JScrollPane dataScroll;

    public TreeProcessingInstructionCustomizer() {
        this.initComponents();
        this.targetLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_xmlTarget"));
        this.initAccessibility();
    }

    protected final TreeProcessingInstruction getProcessingInstruction() {
        return (TreeProcessingInstruction)this.getTreeObject();
    }

    @Override
    protected final void safePropertyChange(PropertyChangeEvent pche) {
        super.safePropertyChange(pche);
        if (pche.getPropertyName().equals("target")) {
            this.updateTargetComponent();
        } else if (pche.getPropertyName().equals("data")) {
            this.updateDataComponent();
        }
    }

    protected final void updateProcessingInstructionTarget() {
        try {
            this.getProcessingInstruction().setTarget(this.targetField.getText());
        }
        catch (TreeException exc) {
            this.updateTargetComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateTargetComponent() {
        this.targetField.setText(this.getProcessingInstruction().getTarget());
    }

    protected final void updateProcessingInstructionData() {
        try {
            this.getProcessingInstruction().setData(this.dataTextArea.getText());
        }
        catch (TreeException exc) {
            this.updateDataComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateDataComponent() {
        this.dataTextArea.setText(this.getProcessingInstruction().getData());
    }

    @Override
    protected final void initComponentValues() {
        this.updateTargetComponent();
        this.updateDataComponent();
    }

    @Override
    protected void updateReadOnlyStatus(boolean editable) {
        this.targetField.setEditable(editable);
        this.dataTextArea.setEditable(editable);
    }

    private void initComponents() {
        this.targetLabel = new JLabel();
        this.targetField = new JTextField();
        this.dataPanel = new JPanel();
        this.dataScroll = new JScrollPane();
        this.dataTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(350, 230));
        this.targetLabel.setText(Util.THIS.getString("PROP_xmlTarget"));
        this.targetLabel.setLabelFor(this.targetField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.targetLabel, gridBagConstraints);
        this.targetField.setColumns(20);
        this.targetField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeProcessingInstructionCustomizer.this.targetFieldActionPerformed(evt);
            }
        });
        this.targetField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TreeProcessingInstructionCustomizer.this.targetFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                TreeProcessingInstructionCustomizer.this.targetFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.targetField, gridBagConstraints);
        this.dataPanel.setLayout(new BorderLayout());
        this.dataPanel.setPreferredSize(new Dimension(350, 230));
        this.dataTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TreeProcessingInstructionCustomizer.this.dataTextAreaFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                TreeProcessingInstructionCustomizer.this.dataTextAreaFocusLost(evt);
            }
        });
        this.dataTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                TreeProcessingInstructionCustomizer.this.dataTextAreaKeyPressed(evt);
            }
        });
        this.dataScroll.setViewportView(this.dataTextArea);
        this.dataPanel.add((Component)this.dataScroll, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.dataPanel, gridBagConstraints);
    }

    private void dataTextAreaFocusGained(FocusEvent evt) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.dataTextArea.selectAll();
        }
    }

    private void targetFieldFocusGained(FocusEvent evt) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.targetField.selectAll();
        }
    }

    private void dataTextAreaKeyPressed(KeyEvent evt) {
        if (TreeProcessingInstructionCustomizer.applyKeyPressed(evt)) {
            this.updateProcessingInstructionData();
        }
    }

    private void dataTextAreaFocusLost(FocusEvent evt) {
        this.updateProcessingInstructionData();
    }

    private void targetFieldFocusLost(FocusEvent evt) {
        this.updateProcessingInstructionTarget();
    }

    private void targetFieldActionPerformed(ActionEvent evt) {
        this.updateProcessingInstructionTarget();
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeProcessingInstructionCustomizer"));
        this.targetField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_targetField"));
        this.dataTextArea.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_dataPanel1"));
        this.dataTextArea.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_dataPanel1"));
    }
}

