/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.Utils;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;

public class CompletionContextFinder {
    private static final List<JsTokenId> WHITESPACES_TOKENS = Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL);
    private static final List<JsTokenId> CHANGE_CONTEXT_TOKENS = Arrays.asList(JsTokenId.OPERATOR_SEMICOLON, JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.BRACKET_RIGHT_CURLY);
    private static final List<Object[]> OBJECT_PROPERTY_TOKENCHAINS = Arrays.asList({JsTokenId.OPERATOR_DOT}, {JsTokenId.OPERATOR_DOT, JsTokenId.IDENTIFIER}, {JsTokenId.OPERATOR_DOT, JsTokenId.PRIVATE_IDENTIFIER}, {JsTokenId.OPERATOR_OPTIONAL_ACCESS}, {JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.IDENTIFIER}, {JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.PRIVATE_IDENTIFIER});
    private static final List<Object[]> OBJECT_THIS_TOKENCHAINS = Arrays.asList({JsTokenId.KEYWORD_THIS, JsTokenId.OPERATOR_DOT}, {JsTokenId.KEYWORD_THIS, JsTokenId.OPERATOR_DOT, JsTokenId.IDENTIFIER}, {JsTokenId.KEYWORD_THIS, JsTokenId.OPERATOR_DOT, JsTokenId.PRIVATE_IDENTIFIER}, {JsTokenId.KEYWORD_THIS, JsTokenId.OPERATOR_OPTIONAL_ACCESS}, {JsTokenId.KEYWORD_THIS, JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.IDENTIFIER}, {JsTokenId.KEYWORD_THIS, JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.PRIVATE_IDENTIFIER});
    private static final List<Object[]> NUMBER_TOKENCHAINS = Arrays.asList({JsTokenId.NUMBER, JsTokenId.OPERATOR_DOT}, {JsTokenId.NUMBER, JsTokenId.OPERATOR_DOT, JsTokenId.IDENTIFIER}, {JsTokenId.NUMBER, JsTokenId.OPERATOR_DOT, JsTokenId.PRIVATE_IDENTIFIER}, {JsTokenId.NUMBER, JsTokenId.OPERATOR_OPTIONAL_ACCESS}, {JsTokenId.NUMBER, JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.IDENTIFIER}, {JsTokenId.NUMBER, JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.PRIVATE_IDENTIFIER});
    private static final List<Object[]> STRING_TOKENCHAINS = Arrays.asList({JsTokenId.STRING_END, JsTokenId.OPERATOR_DOT}, {JsTokenId.STRING_END, JsTokenId.OPERATOR_DOT, JsTokenId.IDENTIFIER}, {JsTokenId.STRING_END, JsTokenId.OPERATOR_DOT, JsTokenId.PRIVATE_IDENTIFIER}, {JsTokenId.STRING_END, JsTokenId.OPERATOR_OPTIONAL_ACCESS}, {JsTokenId.STRING_END, JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.IDENTIFIER}, {JsTokenId.STRING_END, JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.PRIVATE_IDENTIFIER});
    private static final List<Object[]> REGEXP_TOKENCHAINS = Arrays.asList({JsTokenId.REGEXP_END, JsTokenId.OPERATOR_DOT}, {JsTokenId.REGEXP_END, JsTokenId.OPERATOR_DOT, JsTokenId.IDENTIFIER}, {JsTokenId.REGEXP_END, JsTokenId.OPERATOR_DOT, JsTokenId.PRIVATE_IDENTIFIER}, {JsTokenId.REGEXP_END, JsTokenId.OPERATOR_OPTIONAL_ACCESS}, {JsTokenId.REGEXP_END, JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.IDENTIFIER}, {JsTokenId.REGEXP_END, JsTokenId.OPERATOR_OPTIONAL_ACCESS, JsTokenId.PRIVATE_IDENTIFIER});

    @NonNull
    static CompletionContext findCompletionContext(ParserResult info, int offset) {
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return CompletionContext.NONE;
        }
        TokenSequence ts = th.tokenSequence(JsTokenId.javascriptLanguage());
        if (ts == null) {
            return CompletionContext.NONE;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return CompletionContext.NONE;
        }
        Token token = ts.token();
        JsTokenId tokenId = (JsTokenId)token.id();
        if (tokenId == JsTokenId.DOC_COMMENT) {
            return CompletionContext.DOCUMENTATION;
        }
        if ((tokenId == JsTokenId.OPERATOR_DOT || tokenId == JsTokenId.OPERATOR_OPTIONAL_ACCESS) && ts.moveNext()) {
            ts.movePrevious();
            ts.movePrevious();
            token = ts.token();
            tokenId = (JsTokenId)token.id();
        }
        if (tokenId == JsTokenId.STRING || tokenId == JsTokenId.STRING_END) {
            token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.STRING, JsTokenId.STRING_BEGIN, JsTokenId.STRING_END));
            if (token == null) {
                return CompletionContext.IN_STRING;
            }
            token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts);
            if (token.id() == JsTokenId.BRACKET_LEFT_PAREN && ts.movePrevious() && (tokenId = (JsTokenId)(token = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts)).id()) == JsTokenId.IDENTIFIER) {
                if ("getElementById".equals(token.text().toString())) {
                    return CompletionContext.STRING_ELEMENTS_BY_ID;
                }
                if ("getElementsByClassName".equals(token.text().toString())) {
                    return CompletionContext.STRING_ELEMENTS_BY_CLASS_NAME;
                }
            }
            if ((token = LexUtilities.findPreviousToken((TokenSequence)ts, Utils.LOOK_FOR_IMPORT_EXPORT_TOKENS)).id() == JsTokenId.KEYWORD_EXPORT || token.id() == JsTokenId.KEYWORD_IMPORT) {
                return CompletionContext.IMPORT_EXPORT_MODULE;
            }
            return CompletionContext.IN_STRING;
        }
        if (CompletionContextFinder.acceptTokenChains(ts, OBJECT_THIS_TOKENCHAINS, true)) {
            return CompletionContext.OBJECT_MEMBERS;
        }
        if (CompletionContextFinder.acceptTokenChains(ts, NUMBER_TOKENCHAINS, tokenId != JsTokenId.OPERATOR_DOT && tokenId != JsTokenId.OPERATOR_OPTIONAL_ACCESS)) {
            return CompletionContext.NUMBER;
        }
        if (CompletionContextFinder.acceptTokenChains(ts, STRING_TOKENCHAINS, tokenId != JsTokenId.OPERATOR_DOT && tokenId != JsTokenId.OPERATOR_OPTIONAL_ACCESS)) {
            return CompletionContext.STRING;
        }
        if (CompletionContextFinder.acceptTokenChains(ts, REGEXP_TOKENCHAINS, tokenId != JsTokenId.OPERATOR_DOT && tokenId != JsTokenId.OPERATOR_OPTIONAL_ACCESS)) {
            return CompletionContext.REGEXP;
        }
        if (CompletionContextFinder.acceptTokenChains(ts, OBJECT_PROPERTY_TOKENCHAINS, tokenId != JsTokenId.OPERATOR_DOT && tokenId != JsTokenId.OPERATOR_OPTIONAL_ACCESS)) {
            return CompletionContext.OBJECT_PROPERTY;
        }
        ts.move(offset);
        if (ts.moveNext()) {
            if (CompletionContextFinder.isCallArgumentContext((TokenSequence<JsTokenId>)ts)) {
                return CompletionContext.CALL_ARGUMENT;
            }
            ts.move(offset);
            ts.moveNext();
            if (CompletionContextFinder.isPropertyNameContext((TokenSequence<JsTokenId>)ts)) {
                return CompletionContext.OBJECT_PROPERTY_NAME;
            }
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return CompletionContext.GLOBAL;
        }
        token = ts.token();
        tokenId = (JsTokenId)token.id();
        if (tokenId == JsTokenId.EOL && ts.movePrevious()) {
            token = ts.token();
            tokenId = (JsTokenId)token.id();
        }
        if (tokenId == JsTokenId.IDENTIFIER || tokenId == JsTokenId.PRIVATE_IDENTIFIER || WHITESPACES_TOKENS.contains(tokenId)) {
            if (!ts.movePrevious()) {
                return CompletionContext.GLOBAL;
            }
            token = LexUtilities.findPrevious((TokenSequence)ts, WHITESPACES_TOKENS);
        }
        if (CHANGE_CONTEXT_TOKENS.contains(token.id()) || WHITESPACES_TOKENS.contains(token.id()) && !ts.movePrevious()) {
            return CompletionContext.GLOBAL;
        }
        token = LexUtilities.findPreviousToken((TokenSequence)ts, Utils.LOOK_FOR_IMPORT_EXPORT_TOKENS);
        if (token.id() == JsTokenId.KEYWORD_EXPORT || token.id() == JsTokenId.KEYWORD_IMPORT) {
            return CompletionContext.IMPORT_EXPORT_SPECIAL_TOKENS;
        }
        if (tokenId == JsTokenId.DOC_COMMENT) {
            return CompletionContext.DOCUMENTATION;
        }
        return CompletionContext.EXPRESSION;
    }

    protected static boolean isCallArgumentContext(TokenSequence<JsTokenId> ts) {
        Token token;
        if (ts.movePrevious() && (token = LexUtilities.findPreviousNonWsNonComment(ts)) != null && (token.id() == JsTokenId.BRACKET_LEFT_PAREN || token.id() == JsTokenId.OPERATOR_COMMA)) {
            int balanceParen = token.id() == JsTokenId.BRACKET_LEFT_PAREN ? 0 : 1;
            int balanceCurly = 0;
            int balanceBracket = 0;
            while (balanceParen != 0 && ts.movePrevious()) {
                token = ts.token();
                if (token.id() == JsTokenId.BRACKET_LEFT_PAREN) {
                    --balanceParen;
                    continue;
                }
                if (token.id() == JsTokenId.BRACKET_RIGHT_PAREN) {
                    ++balanceParen;
                    continue;
                }
                if (token.id() == JsTokenId.BRACKET_LEFT_CURLY) {
                    --balanceCurly;
                    continue;
                }
                if (token.id() == JsTokenId.BRACKET_RIGHT_CURLY) {
                    ++balanceCurly;
                    continue;
                }
                if (token.id() == JsTokenId.BRACKET_LEFT_BRACKET) {
                    --balanceBracket;
                    continue;
                }
                if (token.id() != JsTokenId.BRACKET_RIGHT_BRACKET) continue;
                ++balanceBracket;
            }
            if (balanceParen == 0 && balanceCurly == 0 && balanceBracket == 0 && ts.movePrevious() && token.id() == JsTokenId.BRACKET_LEFT_PAREN && ((token = LexUtilities.findPreviousNonWsNonComment(ts)).id() == JsTokenId.IDENTIFIER || token.id() == JsTokenId.PRIVATE_IDENTIFIER)) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isPropertyNameContext(TokenSequence<JsTokenId> ts) {
        JsTokenId tokenId = (JsTokenId)ts.token().id();
        if (tokenId == JsTokenId.OPERATOR_COMMA) {
            ts.movePrevious();
        }
        List<JsTokenId> listIds = Arrays.asList(JsTokenId.OPERATOR_COMMA, JsTokenId.OPERATOR_COLON, JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.OPERATOR_SEMICOLON);
        Token token = LexUtilities.findPreviousToken(ts, listIds);
        tokenId = (JsTokenId)token.id();
        boolean commaFirst = false;
        if (tokenId == JsTokenId.OPERATOR_COMMA && ts.movePrevious()) {
            ArrayList<JsTokenId> checkParentList = new ArrayList<JsTokenId>(listIds);
            List<JsTokenId> parentList = Arrays.asList(JsTokenId.BRACKET_LEFT_PAREN, JsTokenId.BRACKET_RIGHT_PAREN, JsTokenId.BRACKET_RIGHT_CURLY);
            checkParentList.addAll(parentList);
            token = LexUtilities.findPreviousToken(ts, checkParentList);
            tokenId = (JsTokenId)token.id();
            commaFirst = true;
            if (tokenId == JsTokenId.BRACKET_RIGHT_PAREN || tokenId == JsTokenId.BRACKET_RIGHT_CURLY) {
                CompletionContextFinder.balanceBracketBack(ts);
                token = ts.token();
                tokenId = (JsTokenId)token.id();
            } else {
                if (tokenId == JsTokenId.BRACKET_LEFT_PAREN) {
                    return false;
                }
                if (tokenId == JsTokenId.OPERATOR_COLON) {
                    return true;
                }
            }
        }
        if (tokenId == JsTokenId.BRACKET_LEFT_CURLY && ts.movePrevious()) {
            List<JsTokenId> emptyIds = Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT);
            token = LexUtilities.findPrevious(ts, emptyIds);
            tokenId = (JsTokenId)token.id();
            if (tokenId == JsTokenId.BRACKET_LEFT_PAREN || tokenId == JsTokenId.OPERATOR_COMMA || tokenId == JsTokenId.OPERATOR_EQUALS || tokenId == JsTokenId.OPERATOR_COLON) {
                return true;
            }
            if (tokenId == JsTokenId.BRACKET_RIGHT_PAREN) {
                CompletionContextFinder.balanceBracketBack(ts);
                token = ts.token();
                tokenId = (JsTokenId)token.id();
                if (tokenId == JsTokenId.BRACKET_LEFT_PAREN && ts.movePrevious() && (tokenId = (JsTokenId)(token = LexUtilities.findPrevious(ts, emptyIds)).id()) == JsTokenId.KEYWORD_FUNCTION && ts.movePrevious() && (tokenId = (JsTokenId)(token = LexUtilities.findPrevious(ts, emptyIds)).id()) == JsTokenId.OPERATOR_COLON) {
                    return commaFirst;
                }
            }
        }
        return false;
    }

    private static boolean acceptTokenChains(TokenSequence tokenSequence, List<Object[]> tokenIdChains, boolean movePrevious) {
        for (Object[] tokenIDChain : tokenIdChains) {
            if (!CompletionContextFinder.acceptTokenChain(tokenSequence, tokenIDChain, movePrevious)) continue;
            return true;
        }
        return false;
    }

    private static boolean acceptTokenChain(TokenSequence tokenSequence, Object[] tokenIdChain, boolean movePrevious) {
        boolean moreTokens;
        int orgTokenSequencePos = tokenSequence.offset();
        boolean accept = true;
        boolean bl = moreTokens = movePrevious ? tokenSequence.movePrevious() : true;
        while ((tokenSequence.token().id() == JsTokenId.BLOCK_COMMENT || tokenSequence.token().id() == JsTokenId.LINE_COMMENT) && (moreTokens = tokenSequence.movePrevious())) {
        }
        for (int i = tokenIdChain.length - 1; i >= 0; --i) {
            Object tokenID = tokenIdChain[i];
            if (!moreTokens) {
                accept = false;
                break;
            }
            if (tokenID instanceof JsTokenId) {
                if (tokenSequence.token().id() == tokenID) {
                    moreTokens = tokenSequence.movePrevious();
                    while ((tokenSequence.token().id() == JsTokenId.BLOCK_COMMENT || tokenSequence.token().id() == JsTokenId.LINE_COMMENT) && (moreTokens = tokenSequence.movePrevious())) {
                    }
                    continue;
                }
                accept = false;
                break;
            }
            assert (false) : "Unsupported token type: " + tokenID.getClass().getName();
        }
        tokenSequence.move(orgTokenSequencePos);
        tokenSequence.moveNext();
        return accept;
    }

    private static void balanceBracketBack(TokenSequence<JsTokenId> ts) {
        List<JsTokenId> lookingFor;
        JsTokenId tokenId = (JsTokenId)ts.token().id();
        JsTokenId tokenIdOriginal = (JsTokenId)ts.token().id();
        if (tokenId == JsTokenId.BRACKET_RIGHT_CURLY) {
            lookingFor = Arrays.asList(JsTokenId.BRACKET_LEFT_CURLY);
        } else if (tokenId == JsTokenId.BRACKET_RIGHT_PAREN) {
            lookingFor = Arrays.asList(JsTokenId.BRACKET_LEFT_PAREN);
        } else {
            return;
        }
        int balance = -1;
        while (balance != 0 && ts.movePrevious()) {
            Token token = LexUtilities.findPreviousToken(ts, lookingFor);
            tokenId = (JsTokenId)token.id();
            if (lookingFor.contains(tokenIdOriginal)) {
                --balance;
                continue;
            }
            if (!lookingFor.contains(tokenId)) continue;
            ++balance;
        }
    }
}

