/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import java.util.List;
import java.util.concurrent.Flow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.ai.AIAssistant;
import org.jkiss.dbeaver.model.ai.AICommandRequest;
import org.jkiss.dbeaver.model.ai.AICommandResult;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.ai.AITranslateRequest;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.engine.TooManyRequestsException;
import org.jkiss.dbeaver.model.ai.impl.AIDatabaseSnapshotService;
import org.jkiss.dbeaver.model.ai.impl.AIEngineRequestFactory;
import org.jkiss.dbeaver.model.ai.impl.AIPromptBuilder;
import org.jkiss.dbeaver.model.ai.impl.DummyTokenCounter;
import org.jkiss.dbeaver.model.ai.impl.LogSubscriber;
import org.jkiss.dbeaver.model.ai.impl.MessageChunk;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISchemaGeneratorRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISqlFormatterRegistry;
import org.jkiss.dbeaver.model.ai.utils.ThrowableSupplier;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class AIAssistantImpl
implements AIAssistant {
    private static final Log log = Log.getLog(AIAssistantImpl.class);
    private static final int MANY_REQUESTS_RETRIES = 3;
    private static final int MANY_REQUESTS_TIMEOUT = 500;
    public static final String LOG_INDENT = "\t";
    protected final AISettingsRegistry settingsRegistry;
    protected final AIEngineRegistry engineRegistry;
    protected final AISqlFormatterRegistry formatterRegistry;
    protected final AIEngineRequestFactory requestFactory;

    public AIAssistantImpl() {
        this(AISettingsRegistry.getInstance(), AIEngineRegistry.getInstance(), AISqlFormatterRegistry.getInstance(), new AIEngineRequestFactory(new AIDatabaseSnapshotService(AISchemaGeneratorRegistry.getInstance()), new DummyTokenCounter()));
    }

    public AIAssistantImpl(AISettingsRegistry settingsRegistry, AIEngineRegistry engineRegistry, AISqlFormatterRegistry formatterRegistry, AIEngineRequestFactory requestFactory) {
        this.settingsRegistry = settingsRegistry;
        this.engineRegistry = engineRegistry;
        this.formatterRegistry = formatterRegistry;
        this.requestFactory = requestFactory;
    }

    @Override
    public void initialize(@NotNull DBPWorkspace workspace) {
    }

    @Override
    @NotNull
    public String translateTextToSql(@NotNull DBRProgressMonitor monitor, @NotNull AITranslateRequest request) throws DBException {
        AIEngine engine = request.engine() != null ? request.engine() : this.getActiveEngine();
        AIMessage userMessage = new AIMessage(AIMessageType.USER, request.text());
        AIPromptBuilder promptBuilder = this.createPromptBuilder();
        promptBuilder.addContexts(AIPromptBuilder.describeContext(request.context().getDataSource())).addInstructions(AIPromptBuilder.createInstructionList(request.context().getDataSource())).addGoals("Translate natural language text to SQL.").addOutputFormats("Place any explanation or comments before the SQL code block.", "Provide the SQL query in a fenced Markdown code block.");
        this.addSqlCompletionInstructions(promptBuilder);
        String prompt = promptBuilder.build();
        AIEngineRequest completionRequest = this.requestFactory.build(monitor, prompt, request.context(), List.of(userMessage), engine.getContextWindowSize(monitor));
        AIEngineResponse completionResponse = this.requestCompletion(engine, monitor, completionRequest);
        MessageChunk[] messageChunks = this.processAndSplitCompletion(monitor, request.context(), completionResponse.variants().getFirst());
        return AITextUtils.convertToSQL(userMessage, messageChunks, request.context().getExecutionContext().getDataSource());
    }

    @Override
    @NotNull
    public AICommandResult command(@NotNull DBRProgressMonitor monitor, @NotNull AICommandRequest request) throws DBException {
        AIEngine engine = request.engine() != null ? request.engine() : this.getActiveEngine();
        AIPromptBuilder promptBuilder = this.createPromptBuilder();
        promptBuilder.addContexts(AIPromptBuilder.describeContext(request.context().getDataSource())).addInstructions(AIPromptBuilder.createInstructionList(request.context().getDataSource())).addGoals("Translate natural language text to SQL.").addOutputFormats("Place any explanation or comments before the SQL code block.", "Provide the SQL query in a fenced Markdown code block.");
        this.addSqlCompletionInstructions(promptBuilder);
        String prompt = promptBuilder.build();
        AIEngineRequest completionRequest = this.requestFactory.build(monitor, prompt, request.context(), List.of(AIMessage.userMessage(request.text())), engine.getContextWindowSize(monitor));
        List.of(AIMessage.systemMessage(prompt), AIMessage.userMessage(request.text()));
        AIEngineResponse completionResponse = this.requestCompletion(engine, monitor, completionRequest);
        MessageChunk[] messageChunks = this.processAndSplitCompletion(monitor, request.context(), completionResponse.variants().getFirst());
        String finalSQL = null;
        StringBuilder messages = new StringBuilder();
        MessageChunk[] messageChunkArray = messageChunks;
        int n = messageChunks.length;
        int n2 = 0;
        while (n2 < n) {
            MessageChunk chunk = messageChunkArray[n2];
            if (chunk instanceof MessageChunk.Code) {
                MessageChunk.Code code = (MessageChunk.Code)chunk;
                finalSQL = code.text();
            } else if (chunk instanceof MessageChunk.Text) {
                MessageChunk.Text textChunk = (MessageChunk.Text)chunk;
                messages.append(textChunk.text());
            }
            ++n2;
        }
        return new AICommandResult(finalSQL, messages.toString());
    }

    @Override
    public boolean hasValidConfiguration() throws DBException {
        AIEngineSettings<?> activeEngineConfiguration = this.getActiveEngineConfiguration();
        if (activeEngineConfiguration == null) {
            log.warn((Object)"No active AI engine configuration found");
            return false;
        }
        return activeEngineConfiguration.isValid();
    }

    protected MessageChunk[] processAndSplitCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIDatabaseContext context, @NotNull String completion) throws DBException {
        String processedCompletion = this.formatterRegistry.getSqlPostProcessor().formatGeneratedQuery(monitor, context.getExecutionContext(), context.getScopeObject(), completion);
        return AITextUtils.splitIntoChunks(SQLUtils.getDialectFromDataSource((DBPDataSource)context.getExecutionContext().getDataSource()), processedCompletion);
    }

    private static <T> T callWithRetry(ThrowableSupplier<T, DBException> supplier) throws DBException {
        int retry = 0;
        while (retry < 3) {
            try {
                return supplier.get();
            }
            catch (TooManyRequestsException tooManyRequestsException) {
                if (++retry >= 3) continue;
                log.debug((Object)"Too many engine requests. Retry after 500ms");
                RuntimeUtils.pause((int)500);
            }
        }
        throw new DBException("Request failed after 3 attempts");
    }

    @Override
    @NotNull
    public AIEngine getActiveEngine() throws DBException {
        return this.engineRegistry.getCompletionEngine(this.settingsRegistry.getSettings().activeEngine());
    }

    @Override
    @Nullable
    public AIEngineDescriptor getActiveEngineDescriptor() {
        return this.engineRegistry.getEngineDescriptor(this.settingsRegistry.getSettings().activeEngine());
    }

    protected AIEngineResponse requestCompletion(@NotNull AIEngine engine, @NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        try {
            boolean loggingEnabled = this.isLoggingEnabled();
            if (loggingEnabled) {
                log.debug((Object)("AI request:\n" + CommonUtils.addTextIndent((String)request.toString(), (String)LOG_INDENT)));
            }
            AIEngineResponse completionResponse = AIAssistantImpl.callWithRetry(() -> engine.requestCompletion(monitor, request));
            if (loggingEnabled) {
                log.debug((Object)("AI response:\n" + CommonUtils.addTextIndent((String)completionResponse.toString(), (String)LOG_INDENT)));
            }
            return completionResponse;
        }
        catch (Exception e) {
            if (e instanceof DBException) {
                throw (DBException)((Object)e);
            }
            throw new DBException("Error requesting completion", (Throwable)e);
        }
    }

    protected Flow.Publisher<AIEngineResponseChunk> requestCompletionStream(@NotNull AIEngine engine, @NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        try {
            Flow.Publisher publisher = AIAssistantImpl.callWithRetry(() -> engine.requestCompletionStream(monitor, request));
            boolean loggingEnabled = this.isLoggingEnabled();
            return subscriber -> {
                if (loggingEnabled) {
                    log.debug((Object)("AI stream request:\n" + CommonUtils.addTextIndent((String)request.toString(), (String)LOG_INDENT)));
                    publisher.subscribe(new LogSubscriber(log, subscriber));
                } else {
                    publisher.subscribe(subscriber);
                }
            };
        }
        catch (Exception e) {
            log.error((Object)"Error requesting completion stream", (Throwable)e);
            if (e instanceof DBException) {
                throw (DBException)((Object)e);
            }
            throw new DBException("Error requesting completion stream", (Throwable)e);
        }
    }

    protected AIPromptBuilder createPromptBuilder() throws DBException {
        return AIPromptBuilder.create();
    }

    protected void addSqlCompletionInstructions(AIPromptBuilder promptBuilder) {
    }

    private boolean isLoggingEnabled() throws DBException {
        AIEngineSettings<?> activeEngineConfiguration = this.getActiveEngineConfiguration();
        if (activeEngineConfiguration == null) {
            log.warn((Object)"No active AI engine configuration found");
            return false;
        }
        return activeEngineConfiguration.isLoggingEnabled();
    }

    @Nullable
    private AIEngineSettings<?> getActiveEngineConfiguration() throws DBException {
        String activeEngine = this.settingsRegistry.getSettings().activeEngine();
        if (activeEngine == null || activeEngine.isEmpty()) {
            log.warn((Object)"No active AI engine configured");
            return null;
        }
        return this.settingsRegistry.getSettings().getEngineConfiguration(activeEngine);
    }
}

