/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.databricks;

import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.databricks.DatabricksExecutionContext;
import org.jkiss.dbeaver.ext.databricks.DatabricksSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DatabricksDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(DatabricksDataSource.class);

    public DatabricksDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new DatabricksSQLDialect());
    }

    protected String getConnectionURL(DBPConnectionConfiguration connectionInfo) {
        String url = super.getConnectionURL(connectionInfo);
        if (!this.isLegacyDriver() && url.startsWith("jdbc:spark://")) {
            log.debug((Object)"Detected a legacy connection URL in the Databricks native driver. Updating to the native URL.");
            url = url.replaceFirst("jdbc:spark://", "jdbc:databricks://");
        }
        return url;
    }

    private boolean isLegacyDriver() {
        return CommonUtils.equalObjects((Object)"com.simba.spark.jdbc.Driver", (Object)this.getContainer().getDriver().getDriverClassName());
    }

    @NotNull
    protected Properties getAllConnectionProperties(@NotNull DBRProgressMonitor monitor, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        String userAgent = GeneralUtils.getProductName().replace(" ", "+") + "/" + String.valueOf(GeneralUtils.getProductVersion());
        connectionInfo.setProperty("UserAgentEntry", userAgent);
        return super.getAllConnectionProperties(monitor, context, purpose, connectionInfo);
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, @Nullable JDBCExecutionContext initFrom) throws DBException {
        GenericCatalog defaultCatalog;
        DBCExecutionContextDefaults contextDefaults = context.getContextDefaults();
        if (contextDefaults == null) {
            return;
        }
        if (initFrom == null) {
            contextDefaults.refreshDefaults(monitor, true);
            return;
        }
        DBCExecutionContextDefaults initFromDefaults = initFrom.getContextDefaults();
        if (initFromDefaults != null && (defaultCatalog = (GenericCatalog)initFromDefaults.getDefaultCatalog()) != null && contextDefaults.supportsCatalogChange()) {
            contextDefaults.setDefaultCatalog(monitor, (DBSCatalog)defaultCatalog, null);
        }
    }

    public JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new DatabricksExecutionContext(instance, type);
    }
}

