/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolScriptable;

public class Delegator
implements Function,
SymbolScriptable {
    protected Scriptable obj = null;

    public Delegator() {
    }

    public Delegator(Scriptable scriptable) {
        this.obj = scriptable;
    }

    protected Delegator newInstance() {
        try {
            return (Delegator)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    public Scriptable getDelegee() {
        return this.obj;
    }

    public void setDelegee(Scriptable scriptable) {
        this.obj = scriptable;
    }

    @Override
    public String getClassName() {
        return this.getDelegee().getClassName();
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        return this.getDelegee().get(string, scriptable);
    }

    @Override
    public Object get(Symbol symbol, Scriptable scriptable) {
        Scriptable scriptable2 = this.getDelegee();
        if (scriptable2 instanceof SymbolScriptable) {
            return ((SymbolScriptable)((Object)scriptable2)).get(symbol, scriptable);
        }
        return Scriptable.NOT_FOUND;
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        return this.getDelegee().get(n, scriptable);
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return this.getDelegee().has(string, scriptable);
    }

    @Override
    public boolean has(Symbol symbol, Scriptable scriptable) {
        Scriptable scriptable2 = this.getDelegee();
        if (scriptable2 instanceof SymbolScriptable) {
            return ((SymbolScriptable)((Object)scriptable2)).has(symbol, scriptable);
        }
        return false;
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return this.getDelegee().has(n, scriptable);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        this.getDelegee().put(string, scriptable, object);
    }

    @Override
    public void put(Symbol symbol, Scriptable scriptable, Object object) {
        Scriptable scriptable2 = this.getDelegee();
        if (scriptable2 instanceof SymbolScriptable) {
            ((SymbolScriptable)((Object)scriptable2)).put(symbol, scriptable, object);
        }
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        this.getDelegee().put(n, scriptable, object);
    }

    @Override
    public void delete(String string) {
        this.getDelegee().delete(string);
    }

    @Override
    public void delete(Symbol symbol) {
        Scriptable scriptable = this.getDelegee();
        if (scriptable instanceof SymbolScriptable) {
            ((SymbolScriptable)((Object)scriptable)).delete(symbol);
        }
    }

    @Override
    public void delete(int n) {
        this.getDelegee().delete(n);
    }

    @Override
    public Scriptable getPrototype() {
        return this.getDelegee().getPrototype();
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.getDelegee().setPrototype(scriptable);
    }

    @Override
    public Scriptable getParentScope() {
        return this.getDelegee().getParentScope();
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.getDelegee().setParentScope(scriptable);
    }

    @Override
    public Object[] getIds() {
        return this.getDelegee().getIds();
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return clazz == null || clazz == ScriptRuntime.ScriptableClass || clazz == ScriptRuntime.FunctionClass ? this : this.getDelegee().getDefaultValue(clazz);
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return this.getDelegee().hasInstance(scriptable);
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return ((Function)this.getDelegee()).call(context, scriptable, scriptable2, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        Scriptable scriptable2 = this.getDelegee();
        if (scriptable2 == null) {
            Delegator delegator = this.newInstance();
            Scriptable scriptable3 = objectArray.length == 0 ? context.newObject(scriptable) : ScriptRuntime.toObject(context, scriptable, objectArray[0]);
            delegator.setDelegee(scriptable3);
            return delegator;
        }
        return ((Function)scriptable2).construct(context, scriptable, objectArray);
    }
}

