---
stage: Software Supply Chain Security
group: Authorization
info: "To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments"
title: カスタム権限
description: きめ細かなアクセス制御のために、特定の権限を持つ詳細な権限を構成します。
---

<!--
  This documentation is auto generated by a Rake task.

  Please do not edit this file directly. To update this file, run:
  `bundle exec rake gitlab:custom_roles:compile_docs`

  To make changes to the output of the Rake task,
  edit `tooling/custom_roles/docs/templates/custom_abilities.md.erb`.
-->

{{< history >}}

- カスタム管理者ロールは、GitLab 17.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181346)されました。`custom_admin_roles`という名前の[フラグ付き](../../administration/feature_flags/_index.md)。デフォルトでは無効になっています。
- カスタム管理者ロールは、GitLab 18.3で[一般提供](https://gitlab.com/groups/gitlab-org/-/epics/15957)されています。機能フラグ`custom_admin_roles`がデフォルトで有効になっています。

{{< /history >}}

ベースロールに1つ以上のカスタム権限を追加して、[カスタムロール](_index.md)を作成できます。

{{< alert type="note" >}}

一部の権限は他の権限に依存します。たとえば、`admin_vulnerability`権限を使用するには、`read_vulnerability`権限も含める必要があります。依存関係は、各権限の`Description`列に記載されています。

{{< /alert >}}

## 管理者 {#admin}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| CI/CDの表示 | 管理者エリアでRunnerとジョブのCI/CDの詳細を読み取ります。 | [`read_admin_cicd`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177233) | インスタンス | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/507960) |
| 管理者エリアでグループの詳細を表示します。 | 管理者エリアでグループの詳細を読み取ります。 | [`read_admin_groups`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197777) | インスタンス | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/534449) |
| プロジェクトの表示 | 管理者エリアでプロジェクトの詳細を読み取ります。 | [`read_admin_projects`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197777) | インスタンス | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/534449) |
| サブスクリプション詳細の表示 | 管理者エリアでサブスクリプションの詳細を読み取ります。 | [`read_admin_subscription`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178230) | インスタンス | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/507961) |
| システムモニタリングの表示 | 管理者エリアで、バックグラウンド移行、ヘルスチェック、Gitalyなどのシステム情報を読み取ります。 | [`read_admin_monitoring`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179439) | インスタンス | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/507959) |
| ユーザーを表示する | 管理者エリアで、ユーザーリストとユーザーの詳細を読み取ります。 | [`read_admin_users`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177514) | インスタンス | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/508782) |

## コードレビューワークフロー {#code-review-workflow}

| 権限 | 説明 | API属性 | スコープ | 導入|
|:-----------|:------------|:--------------|:------|:-----------|
| マージリクエストの承認と設定を管理 | グループまたはプロジェクトレベルでマージリクエストを設定します。グループアクションには、マージチェックと承認設定の管理が含まれます。プロジェクトアクションには、MRの設定、承認ルールと設定、ブランチターゲットが含まれます。レビュアーの推奨を有効にするには、「プロジェクトアクセストークンの管理」カスタム権限を有効にする必要があります。 | [`manage_merge_request_settings`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151586) | グループ<br> プロジェクト | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/443235) |

## コンプライアンスフレームワークの管理 {#compliance-management}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| コンプライアンスフレームワークの管理と割り当て | コンプライアンスフレームワークの作成、読み取り、更新、削除。この権限を付与されたユーザーは、コンプライアンスフレームワークのラベルをプロジェクトに割り当てたり、グループのデフォルトフレームワークを設定したりすることもできます。 | [`admin_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144183) | グループ<br> プロジェクト | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/411502) |
| コンプライアンスダッシュボードの読み取り | グループとプロジェクトの準拠、違反、およびフレームワークなど、コンプライアンスさまざまな機能の読み取り。 | [`read_compliance_dashboard`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175066) | グループ<br> プロジェクト | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/465324) |

## 継続的デリバリー {#continuous-delivery}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| デプロイトークンを管理 | グループまたはプロジェクトレベルでデプロイトークンを管理します。 | [`manage_deploy_tokens`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151677) | グループ<br> プロジェクト | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/448843) |
| 保護環境を管理 | 保護環境を作成、読み取り、更新、削除します。 | [`admin_protected_environments`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178283) | グループ<br> プロジェクト | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/471385) |

## グループとプロジェクト {#groups-and-projects}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| プロジェクトをアーカイブ | プロジェクトのアーカイブを許可します。 | [`archive_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134998) | プロジェクト | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/425957) |
| グループを削除 | グループを削除または復元する機能。この機能で、トップレベルグループを削除することはできません。誤って削除することがいよう、保持期間の設定を確認してください。 | [`remove_group`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145166) | グループ | GitLab [16.10](https://gitlab.com/gitlab-org/gitlab/-/issues/425962) |
| プロジェクトを削除 | プロジェクトの削除を許可します。 | [`remove_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139696) | プロジェクト | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/425959) |
| グループメンバーを管理 | グループ内のユーザーの追加や削除、およびユーザーへのロールの割り当て。ロールを割り当てる際に、このカスタム権限を付与されたユーザーは、カスタムロールのベースとして使用されるデフォルトロールと同じか、それよりも少ない権限のロールを選択する必要があります。 | [`admin_group_member`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131914) | グループ | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/17364) |

## Infrastructure as Code {#infrastructure-as-code}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| Terraformステートを管理 | Terraformコマンドの実行、Terraformステートファイルのロック/ロック解除、ファイルバージョンの削除。 | [`admin_terraform_state`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/140759) | プロジェクト | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/421789) |

## インテグレーション {#integrations}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| インテグレーションを管理 | 外部アプリケーションとのインテグレーションの作成、読み取り、更新、削除。 | [`admin_integrations`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154601) | グループ<br> プロジェクト | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/460522) |

## Runner {#runner}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| Runnerを管理する | グループまたはプロジェクトのRunnerの作成、表示、編集、削除。Runnerの設定が含まれます。 | [`admin_runners`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151825) | グループ<br> プロジェクト | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/442851) |
| Runnerを表示 | Runnerフリートダッシュボードなど、グループまたはプロジェクトRunnerへの読み取り専用アクセスを許可します。 | [`read_runners`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156798) | グループ<br> プロジェクト | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/468202) |

## シークレット管理 {#secrets-management}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| CI/CD変数を管理 | CI/CD変数の作成、読み取り、更新、削除。 | [`admin_cicd_variables`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143369) | グループ<br> プロジェクト | GitLab [16.10](https://gitlab.com/gitlab-org/gitlab/-/issues/437947) |

## セキュリティポリシー管理 {#security-policy-management}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| セキュリティポリシープロジェクトへのリンク | セキュリティポリシープロジェクトのリンクを許可します。 | [`manage_security_policy_link`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148371) | グループ<br> プロジェクト | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/440226) |

## ソースコード管理 {#source-code-management}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| マージリクエストを承認する | マージリクエストの承認を許可します。 | [`admin_merge_request`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128302) | プロジェクト | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/412708) |
| 保護ブランチを管理 | プロジェクトの保護ブランチの作成、読み取り、更新、削除。 | [`admin_protected_branch`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162208) | プロジェクト | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/448823) |
| プッシュルールを管理 | グループレベルまたはプロジェクトレベルでリポジトリのプッシュルールを設定します。 | [`admin_push_rules`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147872) | グループ<br> プロジェクト | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/421786) |
| リポジトリコードを表示 | ユーザーインターフェースでのソースコードへの読み取り専用アクセスを許可します。ユーザーが、リポジトリアーカイブの編集やダウンロード、リポジトリのクローンやプル、IDEでのソースコードの表示、非公開プロジェクトのマージリクエストの表示をすることはできません。読み取り専用アクセスでは、本質的にファイルのローカルコピーを作成することが可能であるため、個々のファイルをダウンロードすることはできます。 | [`read_code`](https://gitlab.com/gitlab-org/gitlab/-/issues/376180) | グループ<br> プロジェクト | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/20277) |

## システムアクセス制御 {#system-access}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| グループアクセストークンを管理 | グループアクセストークンの作成、読み取り、更新、削除。トークンを作成する際に、このカスタム権限を付与されたユーザーは、そのトークンのロールとして、カスタムロールのベースとして使用されるデフォルトロールと同じか、それよりも少ない権限のロールを選択する必要があります。 | [`manage_group_access_tokens`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/140115) | グループ | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/428353) |
| プロジェクトアクセストークンを管理 | プロジェクトアクセストークンの作成、読み取り、更新、削除。トークンを作成する際に、このカスタム権限を付与されたユーザーは、そのトークンのロールとして、カスタムロールのベースとして使用されるデフォルトロールと同じか、それよりも少ない権限のロールを選択する必要があります。 | [`manage_project_access_tokens`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132342) | プロジェクト | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/421778) |

## チーム計画 {#team-planning}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| CRMの連絡先を表示 | CRM連絡先の読み取り。 | [`read_crm_contact`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154017) | グループ | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/443268) |

## 脆弱性管理 {#vulnerability-management}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| 脆弱性を管理する | 脆弱性オブジェクトのステータス、リンクされたイシュー、重大度の編集。`read_vulnerability`権限も必要です。 | [`admin_vulnerability`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121534) | グループ<br> プロジェクト | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/412536) |
| 依存関係リストを表示 | 依存関係とライセンスへの読み取り専用アクセスを許可します。 | [`read_dependency`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/126247) | グループ<br> プロジェクト | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/415255) |
| 脆弱性レポートとダッシュボードを表示 | 脆弱性レポートとセキュリティダッシュボードの読み取り。 | [`read_vulnerability`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120704) | グループ<br> プロジェクト | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/399119) |

## Webhook {#webhooks}

| 権限 | 説明 | API属性 | スコープ | 導入 |
|:-----------|:------------|:--------------|:------|:-----------|
| Webhookを管理 | Webhookを管理する | [`admin_web_hook`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151551) | グループ<br> プロジェクト | GitLab [17.0](https://gitlab.com/gitlab-org/quality/triage-ops/-/issues/1373) |
