/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "tempIndex", "", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getSymbols", "()Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "getKPropertyImplConstructor", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "receiverTypes", "returnType", "isLocal", "", "isMutable", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "createKProperty", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "irBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "createLocalKProperty", "propertyName", "", "propertyType", "isKMutablePropertyType", "type", "Companion", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmPropertyReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmPropertyReferenceLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,309:1\n1#2:310\n350#3,12:311\n1056#4:323\n1563#4:324\n1634#4,3:325\n1563#4:343\n1634#4,3:344\n1869#4,2:347\n1878#4,3:349\n1878#4,3:352\n79#5,8:328\n223#6,6:336\n133#7:342\n134#7:355\n*S KotlinDebug\n*F\n+ 1 WasmPropertyReferenceLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering\n*L\n84#1:311,12\n172#1:323\n172#1:324\n172#1:325,3\n190#1:343\n190#1:344,3\n199#1:347,2\n216#1:349,3\n240#1:352,3\n188#1:328,8\n188#1:336,6\n188#1:342\n188#1:355\n*E\n"})
public final class WasmPropertyReferenceLowering
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WasmBackendContext context;
    private int tempIndex;
    @NotNull
    private final WasmSymbols symbols;
    @NotNull
    private static final IrDeclarationOriginImpl DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION = new IrDeclarationOriginImpl("KPROPERTIES_FOR_DELEGATION", false, 2, null);

    public WasmPropertyReferenceLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.symbols = this.context.getWasmSymbols();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmSymbols getSymbols() {
        return this.symbols;
    }

    private final Pair<IrConstructorSymbol, List<IrType>> getKPropertyImplConstructor(List<? extends IrType> receiverTypes, IrType returnType, boolean isLocal, boolean isMutable) {
        IrClassSymbol irClassSymbol;
        if (isLocal) {
            boolean bl = receiverTypes.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Local delegated property cannot have explicit receiver";
                throw new AssertionError((Object)string);
            }
            irClassSymbol = isMutable ? this.symbols.getKLocalDelegatedMutablePropertyImpl() : this.symbols.getKLocalDelegatedPropertyImpl();
        } else {
            switch (receiverTypes.size()) {
                case 0: {
                    if (isMutable) {
                        irClassSymbol = this.symbols.getKMutableProperty0Impl();
                        break;
                    }
                    irClassSymbol = this.symbols.getKProperty0Impl();
                    break;
                }
                case 1: {
                    if (isMutable) {
                        irClassSymbol = this.symbols.getKMutableProperty1Impl();
                        break;
                    }
                    irClassSymbol = this.symbols.getKProperty1Impl();
                    break;
                }
                case 2: {
                    if (isMutable) {
                        irClassSymbol = this.symbols.getKMutableProperty2Impl();
                        break;
                    }
                    irClassSymbol = this.symbols.getKProperty2Impl();
                    break;
                }
                default: {
                    throw new IllegalStateException("More than 2 receivers is not allowed".toString());
                }
            }
        }
        IrClassSymbol classSymbol = irClassSymbol;
        List arguments = CollectionsKt.plus((Collection)receiverTypes, (Iterable)CollectionsKt.listOf((Object)returnType));
        return TuplesKt.to((Object)SequencesKt.single(IrUtilsKt.getConstructors(classSymbol)), (Object)arguments);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Map kProperties = new LinkedHashMap();
        IrClass arrayClass = (IrClass)this.context.getIrBuiltIns().getArrayClass().getOwner();
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(arrayClass);
        boolean $i$f$single = false;
        IrType[] single$iv = null;
        boolean found$iv22 = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)Name.identifier("get"))) continue;
            if (found$iv22) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv22 = true;
        }
        if (!found$iv22) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction arrayItemGetter = (IrSimpleFunction)single$iv;
        IrType anyType = this.context.getIrBuiltIns().getAnyType();
        single$iv = new IrType[]{anyType, anyType};
        IrSimpleType kPropertyImplType = IrTypesKt.typeWith((IrClassifierSymbol)this.symbols.getKProperty1Impl(), single$iv);
        IrType[] found$iv22 = new IrType[]{kPropertyImplType};
        IrType kPropertiesFieldType = IrTypesKt.typeWith(arrayClass, found$iv22);
        IrDeclaration irDeclaration = (IrDeclaration)CollectionsKt.firstOrNull(irFile.getDeclarations());
        if (irDeclaration == null) {
            return;
        }
        IrDeclaration firstFileDeclaration = irDeclaration;
        IrField kPropertiesField = (IrField)this.context.getIrFactory().getStageController().restrictTo(firstFileDeclaration, () -> WasmPropertyReferenceLowering.lower$lambda$3(this, kPropertiesFieldType, irFile));
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoidWithContext(this, kProperties, arrayItemGetter, kPropertiesField){
            final /* synthetic */ WasmPropertyReferenceLowering this$0;
            final /* synthetic */ Map<IrDeclaration, Pair<IrExpression, Integer>> $kProperties;
            final /* synthetic */ IrSimpleFunction $arrayItemGetter;
            final /* synthetic */ IrField $kPropertiesField;
            {
                this.this$0 = $receiver;
                this.$kProperties = $kProperties;
                this.$arrayItemGetter = $arrayItemGetter;
                this.$kPropertiesField = $kPropertiesField;
            }

            /*
             * WARNING - void declaration
             */
            public IrExpression visitPropertyReference(IrPropertyReference expression2) {
                IrExpression irExpression;
                int n2;
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                LoweringContext loweringContext = this.this$0.getContext();
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(loweringContext, scopeWithIr.getScope().getScopeOwnerSymbol(), startOffset, endOffset);
                Map<IrDeclaration, Pair<IrExpression, Integer>> map = this.$kProperties;
                IrSimpleFunction irSimpleFunction = this.$arrayItemGetter;
                WasmPropertyReferenceLowering wasmPropertyReferenceLowering = this.this$0;
                IrField irField = this.$kPropertiesField;
                DeclarationIrBuilder $this$visitPropertyReference_u24lambda_u243 = declarationIrBuilder;
                boolean bl = false;
                Iterable $this$count$iv = expression2.getArguments();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        IrExpression it = (IrExpression)element$iv;
                        boolean bl2 = false;
                        if (!(it != null) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                int receiversCount = n2;
                switch (receiversCount) {
                    case 0: {
                        IrFunctionAccessExpression irFunctionAccessExpression;
                        Object object;
                        void $this$getOrPut$iv;
                        Map<IrDeclaration, Pair<IrExpression, Integer>> count$iv = map;
                        Owner key$iv = ((IrPropertySymbol)expression2.getSymbol()).getOwner();
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl3 = false;
                            Pair answer$iv = TuplesKt.to((Object)WasmPropertyReferenceLowering.access$createKProperty(wasmPropertyReferenceLowering, expression2, $this$visitPropertyReference_u24lambda_u243), (Object)map.size());
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        Pair field = (Pair)object;
                        IrFunctionAccessExpression $this$visitPropertyReference_u24lambda_u243_u24lambda_u242 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$visitPropertyReference_u24lambda_u243, irSimpleFunction);
                        boolean bl4 = false;
                        $this$visitPropertyReference_u24lambda_u243_u24lambda_u242.getArguments().set(0, ExpressionHelpersKt.irGetField$default($this$visitPropertyReference_u24lambda_u243, null, irField, null, 4, null));
                        $this$visitPropertyReference_u24lambda_u243_u24lambda_u242.getArguments().set(1, ExpressionHelpersKt.irInt$default($this$visitPropertyReference_u24lambda_u243, ((Number)field.getSecond()).intValue(), null, 2, null));
                        irExpression = irFunctionAccessExpression;
                        break;
                    }
                    case 1: {
                        irExpression = WasmPropertyReferenceLowering.access$createKProperty(wasmPropertyReferenceLowering, expression2, $this$visitPropertyReference_u24lambda_u243);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Callable reference to properties with two receivers is not allowed: " + ((IrProperty)((IrPropertySymbol)expression2.getSymbol()).getOwner()).getName()).toString());
                    }
                }
                return irExpression;
            }

            /*
             * WARNING - void declaration
             */
            public IrExpression visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                IrFunctionAccessExpression irFunctionAccessExpression;
                Object object;
                void $this$getOrPut$iv;
                int receiversCount;
                int n2;
                void $this$count$iv;
                DeclarationIrBuilder irBuilder;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                int startOffset = expression2.getStartOffset();
                int endOffset = expression2.getEndOffset();
                LoweringContext loweringContext = this.this$0.getContext();
                ScopeWithIr scopeWithIr = this.getCurrentScope();
                Intrinsics.checkNotNull((Object)scopeWithIr);
                DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder(loweringContext, scopeWithIr.getScope().getScopeOwnerSymbol(), startOffset, endOffset);
                Map<IrDeclaration, Pair<IrExpression, Integer>> map = this.$kProperties;
                IrSimpleFunction irSimpleFunction = this.$arrayItemGetter;
                WasmPropertyReferenceLowering wasmPropertyReferenceLowering = this.this$0;
                IrField irField = this.$kPropertiesField;
                DeclarationIrBuilder $this$visitLocalDelegatedPropertyReference_u24lambda_u247 = declarationIrBuilder;
                boolean bl = false;
                Iterable iterable = ((IrSimpleFunction)expression2.getGetter().getOwner()).getParameters();
                boolean $i$f$count22 = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl2 = false;
                        if (!(it.getKind() != IrParameterKind.Regular && it.getKind() != IrParameterKind.Context) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = receiversCount = count$iv;
                }
                if (receiversCount == 2) {
                    throw new IllegalStateException(("Callable reference to properties with two receivers is not allowed: " + expression2).toString());
                }
                Map<IrDeclaration, Pair<IrExpression, Integer>> $i$f$count22 = map;
                Owner key$iv = ((IrLocalDelegatedPropertySymbol)expression2.getSymbol()).getOwner();
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    String string = ((IrLocalDelegatedProperty)((IrLocalDelegatedPropertySymbol)expression2.getSymbol()).getOwner()).getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    Pair answer$iv = TuplesKt.to((Object)WasmPropertyReferenceLowering.access$createLocalKProperty(wasmPropertyReferenceLowering, string, ((IrSimpleFunction)expression2.getGetter().getOwner()).getReturnType(), $this$visitLocalDelegatedPropertyReference_u24lambda_u247), (Object)map.size());
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Pair field = (Pair)object;
                IrFunctionAccessExpression $this$visitLocalDelegatedPropertyReference_u24lambda_u247_u24lambda_u246 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$visitLocalDelegatedPropertyReference_u24lambda_u247, irSimpleFunction);
                boolean bl4 = false;
                $this$visitLocalDelegatedPropertyReference_u24lambda_u247_u24lambda_u246.getArguments().set(0, ExpressionHelpersKt.irGetField$default($this$visitLocalDelegatedPropertyReference_u24lambda_u247, null, irField, null, 4, null));
                $this$visitLocalDelegatedPropertyReference_u24lambda_u247_u24lambda_u246.getArguments().set(1, ExpressionHelpersKt.irInt$default($this$visitLocalDelegatedPropertyReference_u24lambda_u247, ((Number)field.getSecond()).intValue(), null, 2, null));
                return irFunctionAccessExpression;
            }
        });
        if (!kProperties.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedBy$iv = kProperties.values();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    Pair it = (Pair)a2;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getSecond();
                    it = (Pair)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
                }
            });
            boolean $i$f$map = false;
            void var13_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((IrExpression)it.getFirst());
            }
            List initializers = (List)destination$iv$iv;
            kPropertiesField.setInitializer(this.context.getIrFactory().createExpressionBody(-2, -2, org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createArrayOfExpression(this.context, -2, -2, kPropertyImplType, initializers)));
            irFile.getDeclarations().add(0, kPropertiesField);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression createKProperty(IrPropertyReference expression2, IrBuilderWithScope irBuilder) {
        IrFunctionReferenceImpl irFunctionReferenceImpl;
        IrFunctionReferenceImpl irFunctionReferenceImpl2;
        Object object;
        IrFunctionReferenceImpl getterCallableReference;
        IrFunctionReferenceImpl irFunctionReferenceImpl3;
        Object object2;
        Object returnType;
        void $this$mapTo$iv$iv;
        void this_$iv$iv$iv;
        int startOffset = expression2.getStartOffset();
        int endOffset = expression2.getEndOffset();
        IrGeneratorWithScope $this$irBlock_u24default$iv = irBuilder;
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = ((IrExpression)expression2).getType();
        int startOffset$iv = ((IrExpression)expression2).getStartOffset();
        int endOffset$iv = ((IrExpression)expression2).getEndOffset();
        boolean $i$f$irBlock = false;
        IrGeneratorWithScope $this$irBlock$iv$iv = $this$irBlock_u24default$iv;
        boolean $i$f$irBlock2 = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void $this$createKProperty_u24lambda_u2418 = this_$iv$iv$iv;
        boolean bl = false;
        List receiverTypes = new ArrayList();
        Iterable $this$map$iv = expression2.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrVariable irVariable;
            void argument;
            IrExpression irExpression = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (argument != null) {
                Iterator it;
                boolean bl3 = false;
                int n2 = this.tempIndex;
                this.tempIndex = n2 + 1;
                irVariable = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$createKProperty_u24lambda_u2418, (IrExpression)((Object)it), "$KPropertyArgument" + n2, null, false, null, 28, null);
            } else {
                irVariable = null;
            }
            collection.add(irVariable);
        }
        List temporaries = (List)destination$iv$iv;
        Object object3 = expression2.getGetter();
        if (object3 == null || (object3 = (IrSimpleFunction)object3.getOwner()) == null || (object3 = ((IrFunction)object3).getReturnType()) == null) {
            IrFieldSymbol irFieldSymbol = expression2.getField();
            Intrinsics.checkNotNull((Object)irFieldSymbol);
            object3 = returnType = ((IrField)irFieldSymbol.getOwner()).getType();
        }
        if ((object2 = expression2.getGetter()) != null && (object2 = (IrSimpleFunction)object2.getOwner()) != null) {
            Object getter2 = object2;
            boolean bl4 = false;
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)((IrFunction)getter2).getParameters(), (Iterable)temporaries);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl5 = false;
                IrValueParameter parameter = (IrValueParameter)pair.component1();
                IrVariable argument = (IrVariable)pair.component2();
                if (argument != null) continue;
                receiverTypes.add(parameter.getType());
            }
            IrSimpleType getterKFunctionType = IrUtilsKt.getKFunctionType(this.context.getIrBuiltIns(), (IrType)returnType, receiverTypes);
            IrType irType = getterKFunctionType;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrFunctionSymbol irFunctionSymbol = irSimpleFunctionSymbol;
            int n3 = getter2.getTypeParameters().size();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol2);
            IrFunctionReferenceImpl $this$createKProperty_u24lambda_u2418_u24lambda_u2412_u24lambda_u2411 = $i$f$forEach = BuildersKt.IrFunctionReferenceImpl$default(startOffset, endOffset, irType, irFunctionSymbol, n3, irSimpleFunctionSymbol2, null, 64, null);
            boolean bl6 = false;
            Iterable $this$forEachIndexed$iv = temporaries;
            int $i$f$forEachIndexed = 0;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                IrGetValueImpl irGetValueImpl;
                void argument;
                int n4;
                if ((n4 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrVariable irVariable = (IrVariable)item$iv;
                int index = n4;
                boolean bl7 = false;
                IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = $this$createKProperty_u24lambda_u2418_u24lambda_u2412_u24lambda_u2411.getArguments();
                int n5 = index;
                if (argument != null) {
                    void it;
                    int n6 = n5;
                    IrMemberAccessExpression.ValueArgumentsList valueArgumentsList2 = valueArgumentsList;
                    boolean bl8 = false;
                    IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet((IrBuilder)$this$createKProperty_u24lambda_u2418, (IrValueDeclaration)it);
                    valueArgumentsList = valueArgumentsList2;
                    n5 = n6;
                    irGetValueImpl = irGetValueImpl2;
                } else {
                    irGetValueImpl = null;
                }
                valueArgumentsList.set(n5, irGetValueImpl);
            }
            $i$f$forEachIndexed = ((Collection)expression2.getTypeArguments()).size();
            for (int index = 0; index < $i$f$forEachIndexed; ++index) {
                $this$createKProperty_u24lambda_u2418_u24lambda_u2412_u24lambda_u2411.getTypeArguments().set(index, expression2.getTypeArguments().get(index));
            }
            irFunctionReferenceImpl3 = $i$f$forEach;
        } else {
            irFunctionReferenceImpl3 = getterCallableReference = null;
        }
        if ((object = expression2.getSetter()) != null && (object = (IrSimpleFunction)object.getOwner()) != null) {
            Object setter2 = object;
            boolean bl9 = false;
            if (!this.isKMutablePropertyType(expression2.getType())) {
                irFunctionReferenceImpl2 = null;
            } else {
                IrSimpleType setterKFunctionType = IrUtilsKt.getKFunctionType(this.context.getIrBuiltIns(), $this$createKProperty_u24lambda_u2418.getContext().getIrBuiltIns().getUnitType(), CollectionsKt.plus((Collection)receiverTypes, (Object)returnType));
                IrType irType = setterKFunctionType;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getSetter();
                Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
                IrFunctionSymbol irFunctionSymbol = irSimpleFunctionSymbol;
                int n7 = setter2.getTypeParameters().size();
                IrSimpleFunctionSymbol irSimpleFunctionSymbol3 = expression2.getSetter();
                Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol3);
                IrFunctionReferenceImpl $this$createKProperty_u24lambda_u2418_u24lambda_u2416_u24lambda_u2415 = irFunctionReferenceImpl = BuildersKt.IrFunctionReferenceImpl$default(startOffset, endOffset, irType, irFunctionSymbol, n7, irSimpleFunctionSymbol3, null, 64, null);
                boolean bl10 = false;
                Iterable $this$forEachIndexed$iv = temporaries;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    IrGetValueImpl irGetValueImpl;
                    void argument;
                    int n8;
                    if ((n8 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    IrVariable index = (IrVariable)item$iv;
                    int index2 = n8;
                    boolean bl11 = false;
                    IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = $this$createKProperty_u24lambda_u2418_u24lambda_u2416_u24lambda_u2415.getArguments();
                    int n9 = index2;
                    if (argument != null) {
                        void it;
                        int n10 = n9;
                        IrMemberAccessExpression.ValueArgumentsList valueArgumentsList3 = valueArgumentsList;
                        boolean bl12 = false;
                        IrGetValueImpl irGetValueImpl3 = ExpressionHelpersKt.irGet((IrBuilder)$this$createKProperty_u24lambda_u2418, (IrValueDeclaration)it);
                        valueArgumentsList = valueArgumentsList3;
                        n9 = n10;
                        irGetValueImpl = irGetValueImpl3;
                    } else {
                        irGetValueImpl = null;
                    }
                    valueArgumentsList.set(n9, irGetValueImpl);
                }
                int n11 = ((Collection)expression2.getTypeArguments()).size();
                for (int index = 0; index < n11; ++index) {
                    $this$createKProperty_u24lambda_u2418_u24lambda_u2416_u24lambda_u2415.getTypeArguments().set(index, expression2.getTypeArguments().get(index));
                }
                irFunctionReferenceImpl2 = irFunctionReferenceImpl;
            }
        } else {
            irFunctionReferenceImpl2 = null;
        }
        IrFunctionReferenceImpl setterCallableReference = irFunctionReferenceImpl2;
        Pair<IrConstructorSymbol, List<IrType>> pair = this.getKPropertyImplConstructor(receiverTypes, (IrType)returnType, false, setterCallableReference != null);
        IrConstructorSymbol symbol = (IrConstructorSymbol)pair.component1();
        List constructorTypeArguments = (List)pair.component2();
        boolean capturedReceiver = expression2.getDispatchReceiver() != null || expression2.getDispatchReceiver() != null;
        IrSimpleType initializerType = IrTypesKt.typeWith(IrTypesKt.getClassifierOrFail(((IrConstructor)symbol.getOwner()).getReturnType()), (List<? extends IrType>)constructorTypeArguments);
        IrFunctionReferenceImpl $this$createKProperty_u24lambda_u2418_u24lambda_u2417 = irFunctionReferenceImpl = ExpressionHelpersKt.irCall((IrBuilder)$this$createKProperty_u24lambda_u2418, (IrFunctionSymbol)symbol, (IrType)initializerType, constructorTypeArguments);
        boolean bl13 = false;
        IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = $this$createKProperty_u24lambda_u2418_u24lambda_u2417.getArguments();
        IrBuilder irBuilder2 = (IrBuilder)$this$createKProperty_u24lambda_u2418;
        String string = ((IrProperty)((IrPropertySymbol)expression2.getSymbol()).getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        valueArgumentsList.set(0, ExpressionHelpersKt.irString(irBuilder2, string));
        $this$createKProperty_u24lambda_u2418_u24lambda_u2417.getArguments().set(1, ExpressionHelpersKt.irString((IrBuilder)$this$createKProperty_u24lambda_u2418, AdditionalIrUtilsKt.getKotlinFqName(((IrProperty)((IrPropertySymbol)expression2.getSymbol()).getOwner()).getParent()).asString()));
        $this$createKProperty_u24lambda_u2418_u24lambda_u2417.getArguments().set(2, ExpressionHelpersKt.irBoolean((IrBuilder)$this$createKProperty_u24lambda_u2418, capturedReceiver));
        if (getterCallableReference != null) {
            $this$createKProperty_u24lambda_u2418_u24lambda_u2417.getArguments().set(3, getterCallableReference);
        }
        if (setterCallableReference != null) {
            $this$createKProperty_u24lambda_u2418_u24lambda_u2417.getArguments().set(4, setterCallableReference);
        }
        IrFunctionReferenceImpl initializer = irFunctionReferenceImpl;
        $this$createKProperty_u24lambda_u2418.unaryPlus(initializer);
        return (IrExpression)this_$iv$iv$iv.doBuild();
    }

    private final IrExpression createLocalKProperty(String propertyName, IrType propertyType, IrBuilderWithScope irBuilder) {
        IrMemberAccessExpression<?> irMemberAccessExpression;
        IrBuilderWithScope $this$createLocalKProperty_u24lambda_u2420 = irBuilder;
        boolean bl = false;
        Pair<IrConstructorSymbol, List<IrType>> pair = this.getKPropertyImplConstructor(CollectionsKt.emptyList(), propertyType, true, false);
        IrConstructorSymbol symbol = (IrConstructorSymbol)pair.component1();
        List constructorTypeArguments = (List)pair.component2();
        IrSimpleType initializerType = IrTypesKt.typeWith(IrTypesKt.getClassifierOrFail(((IrConstructor)symbol.getOwner()).getReturnType()), (List<? extends IrType>)constructorTypeArguments);
        IrMemberAccessExpression<?> $this$createLocalKProperty_u24lambda_u2420_u24lambda_u2419 = irMemberAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$createLocalKProperty_u24lambda_u2420, (IrFunctionSymbol)symbol, (IrType)initializerType, constructorTypeArguments);
        boolean bl2 = false;
        $this$createLocalKProperty_u24lambda_u2420_u24lambda_u2419.getArguments().set(0, ExpressionHelpersKt.irString($this$createLocalKProperty_u24lambda_u2420, propertyName));
        IrMemberAccessExpression<?> initializer = irMemberAccessExpression;
        return initializer;
    }

    private final boolean isKMutablePropertyType(IrType type) {
        IrClassSymbol irClassSymbol;
        if (!(type instanceof IrSimpleType)) {
            return false;
        }
        switch (((IrSimpleType)type).getArguments().size()) {
            case 0: {
                return false;
            }
            case 1: {
                irClassSymbol = this.symbols.getKMutableProperty0();
                break;
            }
            case 2: {
                irClassSymbol = this.symbols.getKMutableProperty1();
                break;
            }
            case 3: {
                irClassSymbol = this.symbols.getKMutableProperty2();
                break;
            }
            default: {
                throw new IllegalStateException("More than 2 receivers is not allowed".toString());
            }
        }
        IrClassSymbol expectedClass = irClassSymbol;
        return Intrinsics.areEqual((Object)((IrSimpleType)type).getClassifier(), (Object)expectedClass);
    }

    private static final IrField lower$lambda$3(WasmPropertyReferenceLowering this$0, IrType $kPropertiesFieldType, IrFile $irFile) {
        IrField irField;
        IrFactory irFactory = this$0.context.getIrFactory();
        IrDeclarationOrigin irDeclarationOrigin = DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION;
        Name name2 = Name.identifier("$KPROPERTIES");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
        IrField $this$lower_u24lambda_u243_u24lambda_u242 = irField = irFactory.createField(-2, -2, irDeclarationOrigin, name2, descriptorVisibility, new IrFieldSymbolImpl(null, null, 3, null), $kPropertiesFieldType, true, true, false);
        boolean bl = false;
        $this$lower_u24lambda_u243_u24lambda_u242.setParent($irFile);
        return irField;
    }

    public static final /* synthetic */ IrExpression access$createKProperty(WasmPropertyReferenceLowering $this, IrPropertyReference expression2, IrBuilderWithScope irBuilder) {
        return $this.createKProperty(expression2, irBuilder);
    }

    public static final /* synthetic */ IrExpression access$createLocalKProperty(WasmPropertyReferenceLowering $this, String propertyName, IrType propertyType, IrBuilderWithScope irBuilder) {
        return $this.createLocalKProperty(propertyName, propertyType, irBuilder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/WasmPropertyReferenceLowering$Companion;", "", "<init>", "()V", "DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getDECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "backend.wasm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrDeclarationOriginImpl getDECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION() {
            return DECLARATION_ORIGIN_KPROPERTIES_FOR_DELEGATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

