/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Named;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.ImmutableAttributesEntry;
import org.gradle.internal.Cast;
import org.gradle.internal.isolation.Isolatable;
import org.jspecify.annotations.Nullable;

public final class DefaultImmutableAttributesEntry<T>
implements ImmutableAttributesEntry<T> {
    private final Map<Attribute<?>, Object> coercionCache = new ConcurrentHashMap();
    private final Attribute<T> attribute;
    private final Isolatable<T> value;
    private final int hashCode;

    public DefaultImmutableAttributesEntry(Attribute<T> key, Isolatable<T> value) {
        this.attribute = key;
        this.value = value;
        this.hashCode = DefaultImmutableAttributesEntry.computeHashCode(key, value);
    }

    @Override
    public Attribute<T> getKey() {
        return this.attribute;
    }

    @Override
    public Isolatable<T> getValue() {
        return this.value;
    }

    @Override
    public <S> S coerce(Attribute<S> otherAttribute) {
        Object s = Cast.uncheckedCast((Object)this.coercionCache.get(otherAttribute));
        if (s == null) {
            s = this.uncachedCoerce(otherAttribute);
            this.coercionCache.put(otherAttribute, s);
        }
        return (S)s;
    }

    private <S> S uncachedCoerce(Attribute<S> otherAttribute) {
        Class otherAttributeType = otherAttribute.getType();
        if (otherAttributeType.isAssignableFrom(this.attribute.getType())) {
            return (S)Cast.uncheckedCast(this.getIsolatedValue());
        }
        Object converted = this.value.coerce(otherAttributeType);
        if (converted != null) {
            return (S)converted;
        }
        if (otherAttributeType.isAssignableFrom(String.class) && (converted = Cast.uncheckedCast((Object)this.desugar())) != null) {
            return (S)converted;
        }
        String foundType = this.getIsolatedValue().getClass().getName();
        if (foundType.equals(otherAttributeType.getName())) {
            foundType = foundType + " with a different ClassLoader";
        }
        throw new IllegalArgumentException(String.format("Unexpected type for attribute '%s' provided. Expected a value of type %s but found a value of type %s.", this.attribute.getName(), otherAttributeType.getName(), foundType));
    }

    private @Nullable String desugar() {
        if (Named.class.isAssignableFrom(this.attribute.getType())) {
            return ((Named)this.getIsolatedValue()).getName();
        }
        if (Enum.class.isAssignableFrom(this.attribute.getType())) {
            return ((Enum)this.getIsolatedValue()).name();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultImmutableAttributesEntry that = (DefaultImmutableAttributesEntry)o;
        return this.attribute.equals(that.attribute) && this.value.equals(that.value);
    }

    private static <T> int computeHashCode(Attribute<T> attribute, Isolatable<T> value) {
        int result = attribute.hashCode();
        result = 31 * result + value.hashCode();
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.attribute + "=" + this.getIsolatedValue();
    }
}

