/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.itk.simple.SimpleITKJNI;

public class DoubleDoubleMap
extends AbstractMap<Double, Double> {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DoubleDoubleMap(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DoubleDoubleMap doubleDoubleMap) {
        return doubleDoubleMap == null ? 0L : doubleDoubleMap.swigCPtr;
    }

    protected static long swigRelease(DoubleDoubleMap doubleDoubleMap) {
        long l = 0L;
        if (doubleDoubleMap != null) {
            if (!doubleDoubleMap.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = doubleDoubleMap.swigCPtr;
            doubleDoubleMap.swigCMemOwn = false;
            doubleDoubleMap.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_DoubleDoubleMap(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public int size() {
        return this.sizeImpl();
    }

    @Override
    public boolean containsKey(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        return this.containsImpl((Double)object);
    }

    @Override
    public Double get(Object object) {
        if (!(object instanceof Double)) {
            return null;
        }
        Iterator iterator = this.find((Double)object);
        if (iterator.isNot(this.end())) {
            return iterator.getValue();
        }
        return null;
    }

    @Override
    public Double put(Double d, Double d2) {
        Iterator iterator = this.find(d);
        if (iterator.isNot(this.end())) {
            Double d3 = iterator.getValue();
            iterator.setValue(d2);
            return d3;
        }
        this.putUnchecked(d, d2);
        return null;
    }

    @Override
    public Double remove(Object object) {
        if (!(object instanceof Double)) {
            return null;
        }
        Iterator iterator = this.find((Double)object);
        if (iterator.isNot(this.end())) {
            Double d = iterator.getValue();
            this.removeUnchecked(iterator);
            return d;
        }
        return null;
    }

    @Override
    public Set<Map.Entry<Double, Double>> entrySet() {
        HashSet<Map.Entry<Double, Double>> hashSet = new HashSet<Map.Entry<Double, Double>>();
        Iterator iterator = this.begin();
        Iterator iterator2 = this.end();
        while (iterator.isNot(iterator2)) {
            hashSet.add(new Map.Entry<Double, Double>(this){
                private Iterator iterator;

                private Map.Entry<Double, Double> init(Iterator iterator) {
                    this.iterator = iterator;
                    return this;
                }

                @Override
                public Double getKey() {
                    return this.iterator.getKey();
                }

                @Override
                public Double getValue() {
                    return this.iterator.getValue();
                }

                @Override
                public Double setValue(Double d) {
                    Double d2 = this.iterator.getValue();
                    this.iterator.setValue(d);
                    return d2;
                }
            }.init(iterator));
            iterator = iterator.getNextUnchecked();
        }
        return hashSet;
    }

    public DoubleDoubleMap() {
        this(SimpleITKJNI.new_DoubleDoubleMap__SWIG_0(), true);
    }

    public DoubleDoubleMap(DoubleDoubleMap doubleDoubleMap) {
        this(SimpleITKJNI.new_DoubleDoubleMap__SWIG_1(DoubleDoubleMap.getCPtr(doubleDoubleMap), doubleDoubleMap), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.DoubleDoubleMap_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.DoubleDoubleMap_clear(this.swigCPtr, this);
    }

    private Iterator find(double d) {
        return new Iterator(SimpleITKJNI.DoubleDoubleMap_find(this.swigCPtr, this, d), true);
    }

    private Iterator begin() {
        return new Iterator(SimpleITKJNI.DoubleDoubleMap_begin(this.swigCPtr, this), true);
    }

    private Iterator end() {
        return new Iterator(SimpleITKJNI.DoubleDoubleMap_end(this.swigCPtr, this), true);
    }

    private int sizeImpl() {
        return SimpleITKJNI.DoubleDoubleMap_sizeImpl(this.swigCPtr, this);
    }

    private boolean containsImpl(double d) {
        return SimpleITKJNI.DoubleDoubleMap_containsImpl(this.swigCPtr, this, d);
    }

    private void putUnchecked(double d, double d2) {
        SimpleITKJNI.DoubleDoubleMap_putUnchecked(this.swigCPtr, this, d, d2);
    }

    private void removeUnchecked(Iterator iterator) {
        SimpleITKJNI.DoubleDoubleMap_removeUnchecked(this.swigCPtr, this, Iterator.getCPtr(iterator), iterator);
    }

    public static class Iterator {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Iterator(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Iterator iterator) {
            return iterator == null ? 0L : iterator.swigCPtr;
        }

        protected static long swigRelease(Iterator iterator) {
            long l = 0L;
            if (iterator != null) {
                if (!iterator.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = iterator.swigCPtr;
                iterator.swigCMemOwn = false;
                iterator.delete();
            }
            return l;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    SimpleITKJNI.delete_DoubleDoubleMap_Iterator(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        private Iterator getNextUnchecked() {
            return new Iterator(SimpleITKJNI.DoubleDoubleMap_Iterator_getNextUnchecked(this.swigCPtr, this), true);
        }

        private boolean isNot(Iterator iterator) {
            return SimpleITKJNI.DoubleDoubleMap_Iterator_isNot(this.swigCPtr, this, Iterator.getCPtr(iterator), iterator);
        }

        private double getKey() {
            return SimpleITKJNI.DoubleDoubleMap_Iterator_getKey(this.swigCPtr, this);
        }

        private double getValue() {
            return SimpleITKJNI.DoubleDoubleMap_Iterator_getValue(this.swigCPtr, this);
        }

        private void setValue(double d) {
            SimpleITKJNI.DoubleDoubleMap_Iterator_setValue(this.swigCPtr, this, d);
        }
    }
}

