/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter removes "spurs" of less than a certain length in the
input image.


This class is parameterized over the type of the input image and the
type of the output image.

The input is assumed to be a binary image.

This filter is a sequential pruning algorithm and known to be
computational time dependable of the image size. The algorithm is the
N-dimensional version of that given for two dimensions in:

Rafael C. Gonzales and Richard E. Woods. Digital Image Processing. Addison Wesley, 491-494, (1993).


See:
 MorphologyImageFilter

 BinaryErodeImageFilter

 BinaryDilateImageFilter

 BinaryThinningImageFilter

 itk::simple::BinaryPruning for the procedural interface

 itk::BinaryPruningImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryPruningImageFilter.h
*/
public class BinaryPruningImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryPruningImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryPruningImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryPruningImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryPruningImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryPruningImageFilter::~BinaryPruningImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryPruningImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryPruningImageFilter::BinaryPruningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryPruningImageFilter() {
    this(SimpleITKJNI.new_BinaryPruningImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BinaryPruningImageFilter::SetIteration(uint32_t Iteration)

Set/Get the iteration value

*/
public  void setIteration(long Iteration) {
    SimpleITKJNI.BinaryPruningImageFilter_setIteration(swigCPtr, this, Iteration);
  }

  /**
uint32_t itk::simple::BinaryPruningImageFilter::GetIteration() const

Set/Get the iteration value

*/
public  long getIteration() {
    return SimpleITKJNI.BinaryPruningImageFilter_getIteration(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryPruningImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryPruningImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryPruningImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryPruningImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryPruningImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryPruningImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
