/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Convolve a given image with an arbitrary image kernel.


This filter operates by centering the flipped kernel at each pixel in
the image and computing the inner product between pixel values in the
image and pixel values in the kernel. The center of the kernel is
defined as $ \\lfloor (2*i+s-1)/2 \\rfloor $ where $i$ is the index and $s$ is the size of the largest possible region of the kernel image. For
kernels with odd sizes in all dimensions, this corresponds to the
center pixel. If a dimension of the kernel image has an even size,
then the center index of the kernel in that dimension will be the
largest integral index that is less than the continuous index of the
image center.

The kernel can optionally be normalized to sum to 1 using NormalizeOn() . Normalization is off by default.


WARNING:
This filter ignores the spacing, origin, and orientation of the kernel
image and treats them as identical to those in the input image.
 This code was contributed in the Insight Journal paper:

"Image Kernel Convolution" by Tustison N., Gee J. https://doi.org/10.54294/e292kx


Nicholas J. Tustison

James C. Gee

See:
 itk::simple::Convolution for the procedural interface

 itk::ConvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkConvolutionImageFilter.h
*/
public class ConvolutionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ConvolutionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ConvolutionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ConvolutionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ConvolutionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ConvolutionImageFilter::~ConvolutionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ConvolutionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ConvolutionImageFilter::ConvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ConvolutionImageFilter() {
    this(SimpleITKJNI.new_ConvolutionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ConvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public  void setNormalize(boolean Normalize) {
    SimpleITKJNI.ConvolutionImageFilter_setNormalize(swigCPtr, this, Normalize);
  }

  /**
Self&amp; itk::simple::ConvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public  void normalizeOn() {
    SimpleITKJNI.ConvolutionImageFilter_normalizeOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ConvolutionImageFilter::NormalizeOff()
*/
public  void normalizeOff() {
    SimpleITKJNI.ConvolutionImageFilter_normalizeOff(swigCPtr, this);
  }

  /**
bool itk::simple::ConvolutionImageFilter::GetNormalize() const
*/
public  boolean getNormalize() {
    return SimpleITKJNI.ConvolutionImageFilter_getNormalize(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ConvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public  void setBoundaryCondition(ConvolutionImageFilter.BoundaryConditionType BoundaryCondition) {
    SimpleITKJNI.ConvolutionImageFilter_setBoundaryCondition(swigCPtr, this, BoundaryCondition.swigValue());
  }

  /**
BoundaryConditionType itk::simple::ConvolutionImageFilter::GetBoundaryCondition() const
*/
public  ConvolutionImageFilter.BoundaryConditionType getBoundaryCondition() {
    return ConvolutionImageFilter.BoundaryConditionType.swigToEnum(SimpleITKJNI.ConvolutionImageFilter_getBoundaryCondition(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::ConvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public  void setOutputRegionMode(ConvolutionImageFilter.OutputRegionModeType OutputRegionMode) {
    SimpleITKJNI.ConvolutionImageFilter_setOutputRegionMode(swigCPtr, this, OutputRegionMode.swigValue());
  }

  /**
OutputRegionModeType itk::simple::ConvolutionImageFilter::GetOutputRegionMode() const
*/
public  ConvolutionImageFilter.OutputRegionModeType getOutputRegionMode() {
    return ConvolutionImageFilter.OutputRegionModeType.swigToEnum(SimpleITKJNI.ConvolutionImageFilter_getOutputRegionMode(swigCPtr, this));
  }

  /**
std::string itk::simple::ConvolutionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ConvolutionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ConvolutionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ConvolutionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ConvolutionImageFilter::Execute(const Image &amp;image, const Image &amp;kernelImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image kernelImage) {
    return new Image(SimpleITKJNI.ConvolutionImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(kernelImage), kernelImage), true);
  }

  public final static class BoundaryConditionType {
    public final static ConvolutionImageFilter.BoundaryConditionType ZERO_PAD = new ConvolutionImageFilter.BoundaryConditionType("ZERO_PAD");
    public final static ConvolutionImageFilter.BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new ConvolutionImageFilter.BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
    public final static ConvolutionImageFilter.BoundaryConditionType PERIODIC_PAD = new ConvolutionImageFilter.BoundaryConditionType("PERIODIC_PAD");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static BoundaryConditionType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + BoundaryConditionType.class + " with value " + swigValue);
    }

    private BoundaryConditionType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private BoundaryConditionType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private BoundaryConditionType(String swigName, BoundaryConditionType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static BoundaryConditionType[] swigValues = { ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

  public final static class OutputRegionModeType {
    public final static ConvolutionImageFilter.OutputRegionModeType SAME = new ConvolutionImageFilter.OutputRegionModeType("SAME");
    public final static ConvolutionImageFilter.OutputRegionModeType VALID = new ConvolutionImageFilter.OutputRegionModeType("VALID");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static OutputRegionModeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + OutputRegionModeType.class + " with value " + swigValue);
    }

    private OutputRegionModeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private OutputRegionModeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private OutputRegionModeType(String swigName, OutputRegionModeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static OutputRegionModeType[] swigValues = { SAME, VALID };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
