/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Mask and image with a LabelMap .


LabelMapMaskImageFilter mask the content of an input image according to the content of the
input LabelMap . The masked pixel of the input image are set to the BackgroundValue. LabelMapMaskImageFilter can keep the input image for one label only, with Negated = false
(the default) or it can mask the input image for a single label, when
Negated equals true. In Both cases, the label is set with SetLabel() .


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


See:
 LabelMapToBinaryImageFilter , LabelMapToLabelImageFilter

 itk::simple::LabelMapMask for the procedural interface

 itk::LabelMapMaskImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelMapMaskImageFilter.h
*/
public class LabelMapMaskImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelMapMaskImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelMapMaskImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelMapMaskImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelMapMaskImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelMapMaskImageFilter::~LabelMapMaskImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelMapMaskImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelMapMaskImageFilter::LabelMapMaskImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelMapMaskImageFilter() {
    this(SimpleITKJNI.new_LabelMapMaskImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelMapMaskImageFilter::SetLabel(uint64_t Label)

The label to mask or to not mask, depending on the value of the
Negated ivar.

*/
public  void setLabel(java.math.BigInteger Label) {
    SimpleITKJNI.LabelMapMaskImageFilter_setLabel(swigCPtr, this, Label);
  }

  /**
uint64_t itk::simple::LabelMapMaskImageFilter::GetLabel() const

The label to mask or to not mask, depending on the value of the
Negated ivar.

*/
public  java.math.BigInteger getLabel() {
    return SimpleITKJNI.LabelMapMaskImageFilter_getLabel(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelMapMaskImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::ZeroValue() .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.LabelMapMaskImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::LabelMapMaskImageFilter::GetBackgroundValue() const

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::ZeroValue() .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.LabelMapMaskImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelMapMaskImageFilter::SetNegated(bool Negated)

Set/Get whether the Label should be masked or not.

*/
public  void setNegated(boolean Negated) {
    SimpleITKJNI.LabelMapMaskImageFilter_setNegated(swigCPtr, this, Negated);
  }

  /**
Self&amp; itk::simple::LabelMapMaskImageFilter::NegatedOn()

Set the value of Negated to true or false respectfully.

*/
public  void negatedOn() {
    SimpleITKJNI.LabelMapMaskImageFilter_negatedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelMapMaskImageFilter::NegatedOff()
*/
public  void negatedOff() {
    SimpleITKJNI.LabelMapMaskImageFilter_negatedOff(swigCPtr, this);
  }

  /**
bool itk::simple::LabelMapMaskImageFilter::GetNegated() const

Set/Get whether the Label should be masked or not.

*/
public  boolean getNegated() {
    return SimpleITKJNI.LabelMapMaskImageFilter_getNegated(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelMapMaskImageFilter::SetCrop(bool Crop)

Set/Get whether the image size should be adjusted to the masked image
or not.

*/
public  void setCrop(boolean Crop) {
    SimpleITKJNI.LabelMapMaskImageFilter_setCrop(swigCPtr, this, Crop);
  }

  /**
Self&amp; itk::simple::LabelMapMaskImageFilter::CropOn()

Set the value of Crop to true or false respectfully.

*/
public  void cropOn() {
    SimpleITKJNI.LabelMapMaskImageFilter_cropOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelMapMaskImageFilter::CropOff()
*/
public  void cropOff() {
    SimpleITKJNI.LabelMapMaskImageFilter_cropOff(swigCPtr, this);
  }

  /**
bool itk::simple::LabelMapMaskImageFilter::GetCrop() const

Set/Get whether the image size should be adjusted to the masked image
or not.

*/
public  boolean getCrop() {
    return SimpleITKJNI.LabelMapMaskImageFilter_getCrop(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelMapMaskImageFilter::SetCropBorder(unsigned int value)

Set the values of the CropBorder vector all to value

*/
public  void setCropBorder(VectorUInt32 CropBorder) {
    SimpleITKJNI.LabelMapMaskImageFilter_setCropBorder__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(CropBorder), CropBorder);
  }

  /**
Self&amp; itk::simple::LabelMapMaskImageFilter::SetCropBorder(unsigned int value)

Set the values of the CropBorder vector all to value

*/
public  void setCropBorder(long value) {
    SimpleITKJNI.LabelMapMaskImageFilter_setCropBorder__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::LabelMapMaskImageFilter::GetCropBorder() const

Set/Get the border added to the mask before the crop. The default is 0
on all the axes.

*/
public  VectorUInt32 getCropBorder() {
    return new VectorUInt32(SimpleITKJNI.LabelMapMaskImageFilter_getCropBorder(swigCPtr, this), true);
  }

  /**
std::string itk::simple::LabelMapMaskImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelMapMaskImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelMapMaskImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelMapMaskImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LabelMapMaskImageFilter::Execute(const Image &amp;labelMapImage, const Image &amp;featureImage)

Execute the filter on the input image

*/
public  Image execute(Image labelMapImage, Image featureImage) {
    return new Image(SimpleITKJNI.LabelMapMaskImageFilter_execute(swigCPtr, this, Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage), true);
  }

}
