/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Apply a colormap to a label image and put it on top of the input
image.


Apply a colormap to a label image and put it on top of the input
image. The set of colors is a good selection of distinct colors. The
opacity of the label image can be defined by the user. The user can
also choose if the want to use a background and which label value is
the background. A background label produce a gray pixel with the same
intensity than the input one.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This class was contributed to the Insight Journal https://doi.org/10.54294/xr1bvx


See:
 LabelToRGBImageFilter

 LabelMapOverlayImageFilter , LabelOverlayFunctor

 itk::simple::LabelOverlay for the procedural interface

 itk::LabelOverlayImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelOverlayImageFilter.h
*/
public class LabelOverlayImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelOverlayImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelOverlayImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelOverlayImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelOverlayImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelOverlayImageFilter::~LabelOverlayImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelOverlayImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelOverlayImageFilter::LabelOverlayImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelOverlayImageFilter() {
    this(SimpleITKJNI.new_LabelOverlayImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelOverlayImageFilter::SetOpacity(double Opacity)

Set/Get the opacity of the colored label image. The value must be
between 0 and 1.

*/
public  void setOpacity(double Opacity) {
    SimpleITKJNI.LabelOverlayImageFilter_setOpacity(swigCPtr, this, Opacity);
  }

  /**
double itk::simple::LabelOverlayImageFilter::GetOpacity() const

Set/Get the opacity of the colored label image. The value must be
between 0 and 1.

*/
public  double getOpacity() {
    return SimpleITKJNI.LabelOverlayImageFilter_getOpacity(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelOverlayImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the background value.

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.LabelOverlayImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::LabelOverlayImageFilter::GetBackgroundValue() const

Set/Get the background value.

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.LabelOverlayImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelOverlayImageFilter::SetColormap(std::vector&lt; uint8_t &gt; Colormap)
*/
public  void setColormap(VectorUInt8 Colormap) {
    SimpleITKJNI.LabelOverlayImageFilter_setColormap(swigCPtr, this, VectorUInt8.getCPtr(Colormap), Colormap);
  }

  /**
std::vector&lt;uint8_t&gt; itk::simple::LabelOverlayImageFilter::GetColormap() const
*/
public  VectorUInt8 getColormap() {
    return new VectorUInt8(SimpleITKJNI.LabelOverlayImageFilter_getColormap(swigCPtr, this), true);
  }

  /**
std::string itk::simple::LabelOverlayImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelOverlayImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelOverlayImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelOverlayImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LabelOverlayImageFilter::Execute(Image &amp;&amp;image, const Image &amp;labelImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image labelImage) {
    return new Image(SimpleITKJNI.LabelOverlayImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(labelImage), labelImage), true);
  }

}
