/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Mask an image with a mask.


This class is templated over the types of the input image type, the
mask image type and the type of the output image. Numeric conversions
(castings) are done by the C++ defaults.

The pixel type of the input 2 image must have a valid definition of
the operator != with zero. This condition is required because
internally this filter will perform the operation


The pixel from the input 1 is cast to the pixel type of the output
image.

Note that the input and the mask images must be of the same size.


WARNING:
Any pixel value other than masking value (0 by default) will not be
masked out.

See:
 MaskNegatedImageFilter

 itk::simple::MaskedAssign for the procedural interface

 itk::MaskedAssignImageFilter for the Doxygen on the original ITK
class.


C++ includes: sitkMaskedAssignImageFilter.h
*/
public class MaskedAssignImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MaskedAssignImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MaskedAssignImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MaskedAssignImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MaskedAssignImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MaskedAssignImageFilter::~MaskedAssignImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MaskedAssignImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MaskedAssignImageFilter::MaskedAssignImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MaskedAssignImageFilter() {
    this(SimpleITKJNI.new_MaskedAssignImageFilter(), true);
  }

  /**
Self&amp; itk::simple::MaskedAssignImageFilter::SetAssignConstant(double AssignConstant)

Method to explicitly set the outside value of the mask when
AssignImage is undefined. Defaults to 0

*/
public  void setAssignConstant(double AssignConstant) {
    SimpleITKJNI.MaskedAssignImageFilter_setAssignConstant(swigCPtr, this, AssignConstant);
  }

  /**
double itk::simple::MaskedAssignImageFilter::GetAssignConstant() const
*/
public  double getAssignConstant() {
    return SimpleITKJNI.MaskedAssignImageFilter_getAssignConstant(swigCPtr, this);
  }

  /**
std::string itk::simple::MaskedAssignImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MaskedAssignImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MaskedAssignImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MaskedAssignImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::MaskedAssignImageFilter::Execute(Image &amp;&amp;image, const Image &amp;maskImage, const Image
&amp;assignImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage, Image assignImage) {
    return new Image(SimpleITKJNI.MaskedAssignImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage, Image.getCPtr(assignImage), assignImage), true);
  }

  /**
Image itk::simple::MaskedAssignImageFilter::Execute(Image &amp;&amp;image, const Image &amp;maskImage, const Image
&amp;assignImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.MaskedAssignImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

}
