/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Increase the image size by padding with replicants of the input image
value.


MirrorPadImageFilter changes the image bounds of an image. Any added pixels are filled in
with a mirrored replica of the input image. For instance, if the
output image needs a pixel that is two pixels to the left of the
LargestPossibleRegion of the input image, the value assigned will be
from the pixel two pixels inside the left boundary of the
LargestPossibleRegion. The image bounds of the output must be
specified.

Visual explanation of padding regions.

This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.

Exponential decay in the bounds is enabled when DecayBase has to be in
the range (0.0, 1.0]. When it is 1.0 it is disabled. The decay rate is
based on the Manhattan distance.


See:
 WrapPadImageFilter , ConstantPadImageFilter

 itk::simple::MirrorPad for the procedural interface

 itk::MirrorPadImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMirrorPadImageFilter.h
*/
public class MirrorPadImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MirrorPadImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MirrorPadImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MirrorPadImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MirrorPadImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MirrorPadImageFilter::~MirrorPadImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MirrorPadImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MirrorPadImageFilter::MirrorPadImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MirrorPadImageFilter() {
    this(SimpleITKJNI.new_MirrorPadImageFilter(), true);
  }

  /**
Self&amp; itk::simple::MirrorPadImageFilter::SetPadLowerBound(std::vector&lt; unsigned int &gt; PadLowerBound)
*/
public  void setPadLowerBound(VectorUInt32 PadLowerBound) {
    SimpleITKJNI.MirrorPadImageFilter_setPadLowerBound(swigCPtr, this, VectorUInt32.getCPtr(PadLowerBound), PadLowerBound);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::MirrorPadImageFilter::GetPadLowerBound() const
*/
public  VectorUInt32 getPadLowerBound() {
    return new VectorUInt32(SimpleITKJNI.MirrorPadImageFilter_getPadLowerBound(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::MirrorPadImageFilter::SetPadUpperBound(std::vector&lt; unsigned int &gt; PadUpperBound)
*/
public  void setPadUpperBound(VectorUInt32 PadUpperBound) {
    SimpleITKJNI.MirrorPadImageFilter_setPadUpperBound(swigCPtr, this, VectorUInt32.getCPtr(PadUpperBound), PadUpperBound);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::MirrorPadImageFilter::GetPadUpperBound() const
*/
public  VectorUInt32 getPadUpperBound() {
    return new VectorUInt32(SimpleITKJNI.MirrorPadImageFilter_getPadUpperBound(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::MirrorPadImageFilter::SetDecayBase(double DecayBase)

Get/Set the base for exponential decay in mirrored region.

*/
public  void setDecayBase(double DecayBase) {
    SimpleITKJNI.MirrorPadImageFilter_setDecayBase(swigCPtr, this, DecayBase);
  }

  /**
double itk::simple::MirrorPadImageFilter::GetDecayBase() const

Get/Set the base for exponential decay in mirrored region.

*/
public  double getDecayBase() {
    return SimpleITKJNI.MirrorPadImageFilter_getDecayBase(swigCPtr, this);
  }

  /**
std::string itk::simple::MirrorPadImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MirrorPadImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MirrorPadImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MirrorPadImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::MirrorPadImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.MirrorPadImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
