/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Deconvolve an image using the Richardson-Lucy deconvolution algorithm.


This filter implements the Richardson-Lucy deconvolution algorithm as
defined in Bertero M and Boccacci P, "Introduction to Inverse
Problems in Imaging", 1998. The algorithm assumes that the input
image has been formed by a linear shift-invariant system with a known
kernel.

The Richardson-Lucy algorithm assumes that noise in the image follows
a Poisson distribution and that the distribution for each pixel is
independent of the other pixels.

This code was adapted from the Insight Journal contribution:

"Deconvolution: infrastructure and reference algorithms" by Gaetan
Lehmann https://doi.org/10.54294/tvgfv1


Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France

Cory Quammen, The University of North Carolina at Chapel Hill

See:
 IterativeDeconvolutionImageFilter

 LandweberDeconvolutionImageFilter

 ProjectedLandweberDeconvolutionImageFilter

 itk::simple::RichardsonLucyDeconvolution for the procedural interface

 itk::RichardsonLucyDeconvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkRichardsonLucyDeconvolutionImageFilter.h
*/
public class RichardsonLucyDeconvolutionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected RichardsonLucyDeconvolutionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(RichardsonLucyDeconvolutionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(RichardsonLucyDeconvolutionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::RichardsonLucyDeconvolutionImageFilter::~RichardsonLucyDeconvolutionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_RichardsonLucyDeconvolutionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::RichardsonLucyDeconvolutionImageFilter::RichardsonLucyDeconvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  RichardsonLucyDeconvolutionImageFilter() {
    this(SimpleITKJNI.new_RichardsonLucyDeconvolutionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::RichardsonLucyDeconvolutionImageFilter::SetNumberOfIterations(int NumberOfIterations)

Set the number of iterations.

*/
public  void setNumberOfIterations(int NumberOfIterations) {
    SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
int itk::simple::RichardsonLucyDeconvolutionImageFilter::GetNumberOfIterations() const

Get the number of iterations.

*/
public  int getNumberOfIterations() {
    return SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RichardsonLucyDeconvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public  void setNormalize(boolean Normalize) {
    SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_setNormalize(swigCPtr, this, Normalize);
  }

  /**
Self&amp; itk::simple::RichardsonLucyDeconvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public  void normalizeOn() {
    SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_normalizeOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RichardsonLucyDeconvolutionImageFilter::NormalizeOff()
*/
public  void normalizeOff() {
    SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_normalizeOff(swigCPtr, this);
  }

  /**
bool itk::simple::RichardsonLucyDeconvolutionImageFilter::GetNormalize() const
*/
public  boolean getNormalize() {
    return SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_getNormalize(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::RichardsonLucyDeconvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public  void setBoundaryCondition(RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType BoundaryCondition) {
    SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_setBoundaryCondition(swigCPtr, this, BoundaryCondition.swigValue());
  }

  /**
BoundaryConditionType itk::simple::RichardsonLucyDeconvolutionImageFilter::GetBoundaryCondition() const
*/
public  RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType getBoundaryCondition() {
    return RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType.swigToEnum(SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_getBoundaryCondition(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::RichardsonLucyDeconvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public  void setOutputRegionMode(RichardsonLucyDeconvolutionImageFilter.OutputRegionModeType OutputRegionMode) {
    SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_setOutputRegionMode(swigCPtr, this, OutputRegionMode.swigValue());
  }

  /**
OutputRegionModeType itk::simple::RichardsonLucyDeconvolutionImageFilter::GetOutputRegionMode() const
*/
public  RichardsonLucyDeconvolutionImageFilter.OutputRegionModeType getOutputRegionMode() {
    return RichardsonLucyDeconvolutionImageFilter.OutputRegionModeType.swigToEnum(SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_getOutputRegionMode(swigCPtr, this));
  }

  /**
std::string itk::simple::RichardsonLucyDeconvolutionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::RichardsonLucyDeconvolutionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::RichardsonLucyDeconvolutionImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.RichardsonLucyDeconvolutionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public final static class BoundaryConditionType {
    public final static RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType ZERO_PAD = new RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType("ZERO_PAD");
    public final static RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
    public final static RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType PERIODIC_PAD = new RichardsonLucyDeconvolutionImageFilter.BoundaryConditionType("PERIODIC_PAD");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static BoundaryConditionType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + BoundaryConditionType.class + " with value " + swigValue);
    }

    private BoundaryConditionType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private BoundaryConditionType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private BoundaryConditionType(String swigName, BoundaryConditionType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static BoundaryConditionType[] swigValues = { ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

  public final static class OutputRegionModeType {
    public final static RichardsonLucyDeconvolutionImageFilter.OutputRegionModeType SAME = new RichardsonLucyDeconvolutionImageFilter.OutputRegionModeType("SAME");
    public final static RichardsonLucyDeconvolutionImageFilter.OutputRegionModeType VALID = new RichardsonLucyDeconvolutionImageFilter.OutputRegionModeType("VALID");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static OutputRegionModeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + OutputRegionModeType.class + " with value " + swigValue);
    }

    private OutputRegionModeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private OutputRegionModeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private OutputRegionModeType(String swigName, OutputRegionModeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static OutputRegionModeType[] swigValues = { SAME, VALID };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
