/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Phaser;
import java.util.function.BiConsumer;
import oracle.jdbc.driver.PhasedPublisher;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;

final class BufferedPublisher<T>
extends PhasedPublisher<T> {
    private final AsyncQueue<T> itemQueue;
    private final Monitor monitor = Monitor.newInstance();
    private CompletableFuture<T> onNextFuture = null;
    private boolean isTerminated = false;
    private Throwable terminalError = null;

    private BufferedPublisher(int bufferSize, Phaser joinPhaser, Executor userCodeExecutor) {
        super(userCodeExecutor, joinPhaser, null);
        this.itemQueue = new AsyncQueue(bufferSize);
    }

    final CompletionStage<Void> offerItem(T item) {
        return this.itemQueue.put(item);
    }

    final void terminate(Throwable error) {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            this.isTerminated = true;
            this.terminalError = error;
            if (this.onNextFuture != null) {
                this.attemptTerminalSignal();
            }
        }
    }

    @Override
    protected void requestNext(BiConsumer<T, Throwable> callback) {
        try (Monitor.CloseableLock lock = this.monitor.acquireCloseableLock();){
            this.onNextFuture = this.itemQueue.take();
            if (this.isTerminated) {
                this.attemptTerminalSignal();
            }
            CompletionStageUtil.callOnComplete(this.onNextFuture, callback);
        }
    }

    private void attemptTerminalSignal() {
        if (this.terminalError == null) {
            this.onNextFuture.complete(null);
        } else {
            this.onNextFuture.completeExceptionally(this.terminalError);
        }
    }

    static final <T> BufferedPublisher<T> newInstance(int bufferSize, Phaser joinPhaser, Executor userCodeExecutor) {
        return new BufferedPublisher<T>(bufferSize, joinPhaser, userCodeExecutor);
    }

    private static final class AsyncQueue<T> {
        private final Monitor queueMonitor = Monitor.newInstance();
        private final ArrayDeque<T> queue = new ArrayDeque();
        private final int maxQueueSize;
        private CompletableFuture<Void> putFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
        private CompletableFuture<Void> takeFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;

        private AsyncQueue(int maxSize) {
            this.maxQueueSize = maxSize;
        }

        private final CompletionStage<Void> put(T value) {
            try (Monitor.CloseableLock lock = this.queueMonitor.acquireCloseableLock();){
                assert (this.takeFuture.isDone()) : "Stage returned by previous put is not complete";
                this.queue.addLast(value);
                this.putFuture.complete(null);
                if (this.queue.size() < this.maxQueueSize) {
                    CompletableFuture<Void> completableFuture = CompletionStageUtil.VOID_COMPLETED_FUTURE;
                    return completableFuture;
                }
                this.takeFuture = new CompletableFuture<Void>();
                CompletableFuture<Void> completableFuture = this.takeFuture;
                return completableFuture;
            }
        }

        private final CompletableFuture<T> take() {
            try (Monitor.CloseableLock lock = this.queueMonitor.acquireCloseableLock();){
                assert (this.putFuture.isDone()) : "Stage returned by previous take is not complete";
                T value = this.queue.pollFirst();
                this.takeFuture.complete(null);
                if (value != null) {
                    CompletableFuture<T> completableFuture = CompletableFuture.completedFuture(value);
                    return completableFuture;
                }
                this.putFuture = new CompletableFuture();
                CompletionStage completionStage = this.putFuture.thenCompose(nil -> this.take());
                return completionStage;
            }
        }
    }
}

