/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.cluster.metadata.TemplatesMetadata;
import org.opensearch.common.io.Streams;
import org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.repositories.blobstore.ChecksumBlobStoreFormat;

public class RemoteTemplatesMetadata
extends AbstractClusterMetadataWriteableBlobEntity<TemplatesMetadata> {
    public static final String TEMPLATES_METADATA = "templates";
    public static final ChecksumBlobStoreFormat<TemplatesMetadata> TEMPLATES_METADATA_FORMAT = new ChecksumBlobStoreFormat("templates", "%s", TemplatesMetadata::fromXContent);
    private TemplatesMetadata templatesMetadata;
    private long metadataVersion;

    public RemoteTemplatesMetadata(TemplatesMetadata templatesMetadata, long metadataVersion, String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry) {
        super(clusterUUID, compressor, namedXContentRegistry);
        this.templatesMetadata = templatesMetadata;
        this.metadataVersion = metadataVersion;
    }

    public RemoteTemplatesMetadata(String blobName, String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry) {
        super(clusterUUID, compressor, namedXContentRegistry);
        this.blobName = blobName;
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        return new BlobPathParameters(List.of("global-metadata"), TEMPLATES_METADATA);
    }

    @Override
    public String getType() {
        return TEMPLATES_METADATA;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.metadataVersion), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
        return blobFileName;
    }

    @Override
    public InputStream serialize() throws IOException {
        return TEMPLATES_METADATA_FORMAT.serialize(this.templatesMetadata, this.generateBlobFileName(), this.getCompressor(), RemoteClusterStateUtils.FORMAT_PARAMS).streamInput();
    }

    @Override
    public TemplatesMetadata deserialize(InputStream inputStream) throws IOException {
        return TEMPLATES_METADATA_FORMAT.deserialize(this.blobName, this.getNamedXContentRegistry(), Streams.readFully(inputStream));
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(TEMPLATES_METADATA, this.blobName);
    }
}

