"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _configSchema = require("@osd/config-schema");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
// Router factory
var _default = (iRouter, basePath) => {
  if (basePath == null || basePath == '') {
    throw new TypeError('Base path is null');
  }
  const requestHandler = handler => async (context, request, response) => {
    try {
      return await handler(context, request, response);
    } catch (e) {
      throw e;
    }
  };
  return ['get', 'put', 'post', 'delete'].reduce((router, method) => {
    router[method] = (path, handler) => {
      switch (method) {
        case 'get':
          {
            iRouter.get({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }
        case 'put':
          {
            iRouter.put({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any(),
                body: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }
        case 'post':
          {
            iRouter.post({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any(),
                body: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }
        case 'delete':
          {
            iRouter.delete({
              path: `${basePath}${path}`,
              validate: {
                params: _configSchema.schema.any(),
                query: _configSchema.schema.any(),
                body: _configSchema.schema.any()
              }
            }, requestHandler(handler));
            break;
          }
        default:
          {
            break;
          }
      }
    };
    return router;
  }, {});
};
exports.default = _default;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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