/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ssl;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.ldaptive.LdapUtils;
import org.ldaptive.ssl.AggregateTrustManager;
import org.ldaptive.ssl.DefaultTrustManager;
import org.ldaptive.ssl.HostnameVerifierConfig;
import org.ldaptive.ssl.HostnameVerifyingTrustManager;
import org.ldaptive.ssl.SSLContextInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSSLContextInitializer
implements SSLContextInitializer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected TrustManager[] trustManagers;
    protected HostnameVerifierConfig hostnameVerifierConfig;

    @Override
    public TrustManager[] getTrustManagers() throws GeneralSecurityException {
        TrustManager[] trustManagerArray;
        TrustManager[] tm = this.createTrustManagers();
        if (this.hostnameVerifierConfig != null) {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = new HostnameVerifyingTrustManager(this.hostnameVerifierConfig.getCertificateHostnameVerifier(), this.hostnameVerifierConfig.getHostnames());
        } else {
            trustManagerArray = null;
        }
        TrustManager[] hostnameTrustManager = trustManagerArray;
        TrustManager[] aggregate = null;
        if (tm == null) {
            if (this.trustManagers == null) {
                if (hostnameTrustManager != null) {
                    aggregate = this.aggregateTrustManagers(new DefaultTrustManager(), hostnameTrustManager[0]);
                }
            } else {
                aggregate = this.aggregateTrustManagers(LdapUtils.concatArrays(this.trustManagers, new TrustManager[][]{hostnameTrustManager}));
            }
        } else {
            aggregate = this.aggregateTrustManagers(LdapUtils.concatArrays(tm, this.trustManagers, hostnameTrustManager));
        }
        return aggregate;
    }

    @Override
    public void setTrustManagers(TrustManager ... managers) {
        this.trustManagers = managers;
    }

    @Override
    public HostnameVerifierConfig getHostnameVerifierConfig() {
        return this.hostnameVerifierConfig;
    }

    @Override
    public void setHostnameVerifierConfig(HostnameVerifierConfig config) {
        this.hostnameVerifierConfig = config;
    }

    protected abstract TrustManager[] createTrustManagers() throws GeneralSecurityException;

    @Override
    public SSLContext initSSLContext(String protocol) throws GeneralSecurityException {
        Object[] km = this.getKeyManagers();
        Object[] tm = this.getTrustManagers();
        this.logger.trace("Initialize SSLContext with keyManagers={} and trustManagers={}", (Object)Arrays.toString(km), (Object)Arrays.toString(tm));
        SSLContext ctx = SSLContext.getInstance(protocol);
        ctx.init((KeyManager[])km, (TrustManager[])tm, null);
        return ctx;
    }

    protected TrustManager[] aggregateTrustManagers(TrustManager ... managers) {
        X509TrustManager[] x509Managers = null;
        if (managers != null) {
            x509Managers = new X509TrustManager[managers.length];
            for (int i = 0; i < managers.length; ++i) {
                x509Managers[i] = (X509TrustManager)managers[i];
            }
        }
        return new TrustManager[]{new AggregateTrustManager(x509Managers)};
    }
}

