/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import com.google.common.collect.LinkedListMultimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyLoaderMetaData;
import org.semanticweb.owlapi.io.RDFParserMetaData;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.CollectionFactory;

public abstract class OWLDocumentFormatImpl
implements OWLDocumentFormat {
    private static final long serialVersionUID = 40000L;
    private final Map<Serializable, Serializable> parameterMap = new HashMap<Serializable, Serializable>();
    @Nonnull
    private OWLOntologyLoaderMetaData loaderMetaData = new RDFParserMetaData();
    private boolean addMissingTypes = true;

    @Override
    public boolean isAddMissingTypes() {
        return this.addMissingTypes;
    }

    public static boolean isMissingType(@Nonnull OWLEntity entity, OWLOntology ontology) {
        if (entity.isBuiltIn()) {
            return false;
        }
        if (!ontology.containsEntityInSignature(entity)) {
            return false;
        }
        if (ontology.isDeclared(entity, Imports.INCLUDED)) {
            return false;
        }
        Set<OWLOntology> transitiveImports = ontology.getImports();
        if (!transitiveImports.contains(ontology)) {
            for (OWLOntology importedOntology : transitiveImports) {
                if (!importedOntology.containsEntityInSignature(entity)) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<IRI> determineIllegalPunnings(boolean add, Collection<OWLEntity> signature, Collection<IRI> punnedEntities) {
        if (!add) {
            return CollectionFactory.emptySet();
        }
        LinkedListMultimap punnings = LinkedListMultimap.create();
        for (OWLEntity e : signature) {
            if (e.isOWLNamedIndividual() || !punnedEntities.contains(e.getIRI())) continue;
            punnings.put((Object)e.getIRI(), e.getEntityType());
        }
        HashSet<IRI> illegals = new HashSet<IRI>();
        for (IRI i : punnings.keySet()) {
            Collection puns = punnings.get((Object)i);
            if (puns.contains(EntityType.OBJECT_PROPERTY) && puns.contains(EntityType.ANNOTATION_PROPERTY)) {
                illegals.add(i);
                continue;
            }
            if (puns.contains(EntityType.DATA_PROPERTY) && puns.contains(EntityType.ANNOTATION_PROPERTY)) {
                illegals.add(i);
                continue;
            }
            if (puns.contains(EntityType.DATA_PROPERTY) && puns.contains(EntityType.OBJECT_PROPERTY)) {
                illegals.add(i);
                continue;
            }
            if (!puns.contains(EntityType.DATATYPE) || !puns.contains(EntityType.CLASS)) continue;
            illegals.add(i);
        }
        return illegals;
    }

    @Override
    public void setAddMissingTypes(boolean addMissingTypes) {
        this.addMissingTypes = addMissingTypes;
    }

    @Override
    public void setParameter(Serializable key, Serializable value) {
        this.parameterMap.put(key, value);
    }

    @Override
    public Serializable getParameter(Serializable key, Serializable defaultValue) {
        Serializable val = this.parameterMap.get(key);
        if (val != null) {
            return val;
        }
        return defaultValue;
    }

    @Override
    public OWLOntologyLoaderMetaData getOntologyLoaderMetaData() {
        return this.loaderMetaData;
    }

    @Override
    public void setOntologyLoaderMetaData(OWLOntologyLoaderMetaData loaderMetaData) {
        this.loaderMetaData = loaderMetaData;
    }

    @Override
    public boolean isTextual() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof OWLDocumentFormat) {
            return ((OWLDocumentFormat)obj).getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.getKey();
    }
}

