# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.


import collections

from sys import version_info as _version_info
if _version_info < (3, 7, 0):
    raise RuntimeError("Python 3.7 or later required")

from . import _ITKCommonPython


from . import _ITKBridgeNumPyPython



from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _itkPyVectorContainerPython
else:
    import _itkPyVectorContainerPython

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


if _swig_python_version_info[0:2] >= (3, 3):
    import collections.abc
else:
    import collections

import itk.itkVectorContainerPython
import itk.ITKCommonBasePython
import itk.itkMatrixPython
import itk.vnl_matrix_fixedPython
import itk.vnl_matrixPython
import itk.stdcomplexPython
import itk.pyBasePython
import itk.vnl_vectorPython
import itk.itkVectorPython
import itk.itkFixedArrayPython
import itk.vnl_vector_refPython
import itk.itkCovariantVectorPython
import itk.itkPointPython
import itk.itkArrayPython
import itk.itkOffsetPython
import itk.itkSizePython
import itk.itkContinuousIndexPython
import itk.itkIndexPython


import numpy as np
class NDArrayITKBase(np.ndarray):
  """A numpy array that provides a view on the data associated with an optional itk "base" object."""

  def __new__(cls, input_array, itk_base=None):
      obj = np.asarray(input_array).view(cls)
      obj.itk_base = itk_base
      return obj

  def __array_finalize__(self, obj):
      if obj is None: return
      self.itk_base = getattr(obj, 'itk_base', None)

try:
    from distributed.protocol import dask_serialize, dask_deserialize
    from typing import Dict, List, Tuple
except (ImportError, RuntimeError):
    pass
else:
    @dask_serialize.register(NDArrayITKBase)
    def serialize(ndarray_itk_base: NDArrayITKBase) -> Tuple[Dict, List[bytes]]:
        dumps = dask_serialize.dispatch(np.ndarray)
        return dumps(ndarray_itk_base)

    @dask_deserialize.register(NDArrayITKBase)
    def deserialize(header: Dict, frames: List[bytes]) -> NDArrayITKBase:
        loads = dask_deserialize.dispatch(np.ndarray)
        return NDArrayITKBase(loads(header, frames))

def _get_numpy_pixelid(itk_Image_type) -> np.dtype:
    """Returns a ITK PixelID given a numpy array."""

# This is a Mapping from numpy array types to itk pixel types.
    _np_itk = {"UC":np.dtype(np.uint8),
               "US":np.dtype(np.uint16),
               "UI":np.dtype(np.uint32),
               "UL":np.dtype(np.uint64),
               "ULL":np.dtype(np.uint64),
               "SC":np.dtype(np.int8),
               "SS":np.dtype(np.int16),
               "SI":np.dtype(np.int32),
               "SL":np.dtype(np.int64),
               "SLL":np.dtype(np.int64),
               "F":np.dtype(np.float32),
               "D":np.dtype(np.float64),
               "PF2":np.dtype(np.float32),
               "PF3":np.dtype(np.float32),
                }
    import os
    if os.name == 'nt':
        _np_itk['UL'] = np.dtype(np.uint32)
        _np_itk['SL'] = np.dtype(np.int32)
    try:
        return _np_itk[itk_Image_type]
    except KeyError as e:
        raise e

class itkPyVectorContainerUCD(object):
    r"""Proxy of C++ itkPyVectorContainerUCD class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCD *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCD__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCD_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCD__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCD
        __init__(self, arg0) -> itkPyVectorContainerUCD

        Parameters
        ----------
        arg0: itkPyVectorContainerUCD const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCD_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCD(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCD


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCD._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCD.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCD._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCD in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCD_swigregister(itkPyVectorContainerUCD)
class itkPyVectorContainerUCF(object):
    r"""Proxy of C++ itkPyVectorContainerUCF class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCF *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCF__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCF_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCF__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCF
        __init__(self, arg0) -> itkPyVectorContainerUCF

        Parameters
        ----------
        arg0: itkPyVectorContainerUCF const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCF_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCF(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCF


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCF._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCF.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCF._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCF in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCF_swigregister(itkPyVectorContainerUCF)
class itkPyVectorContainerUCO2(object):
    r"""Proxy of C++ itkPyVectorContainerUCO2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCO2 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCO2__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCO2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCO2__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCO2
        __init__(self, arg0) -> itkPyVectorContainerUCO2

        Parameters
        ----------
        arg0: itkPyVectorContainerUCO2 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCO2_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCO2(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCO2


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "SL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCO2._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCO2.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCO2._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCO2 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCO2_swigregister(itkPyVectorContainerUCO2)
class itkPyVectorContainerUCO3(object):
    r"""Proxy of C++ itkPyVectorContainerUCO3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCO3 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCO3__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCO3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCO3__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCO3
        __init__(self, arg0) -> itkPyVectorContainerUCO3

        Parameters
        ----------
        arg0: itkPyVectorContainerUCO3 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCO3_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCO3(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCO3


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "SL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCO3._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCO3.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCO3._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCO3 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCO3_swigregister(itkPyVectorContainerUCO3)
class itkPyVectorContainerUCO4(object):
    r"""Proxy of C++ itkPyVectorContainerUCO4 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCO4 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCO4__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCO4_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCO4__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCO4
        __init__(self, arg0) -> itkPyVectorContainerUCO4

        Parameters
        ----------
        arg0: itkPyVectorContainerUCO4 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCO4_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCO4(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCO4


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "SL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCO4._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCO4.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCO4._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCO4 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCO4_swigregister(itkPyVectorContainerUCO4)
class itkPyVectorContainerUCSC(object):
    r"""Proxy of C++ itkPyVectorContainerUCSC class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCSC *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCSC__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCSC_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCSC__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCSC
        __init__(self, arg0) -> itkPyVectorContainerUCSC

        Parameters
        ----------
        arg0: itkPyVectorContainerUCSC const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCSC_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCSC(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCSC


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "SC"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCSC._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCSC.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCSC._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCSC in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCSC_swigregister(itkPyVectorContainerUCSC)
class itkPyVectorContainerUCSS(object):
    r"""Proxy of C++ itkPyVectorContainerUCSS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCSS *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCSS__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCSS_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCSS__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCSS
        __init__(self, arg0) -> itkPyVectorContainerUCSS

        Parameters
        ----------
        arg0: itkPyVectorContainerUCSS const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCSS_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCSS(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCSS


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "SS"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCSS._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCSS.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCSS._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCSS in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCSS_swigregister(itkPyVectorContainerUCSS)
class itkPyVectorContainerUCUC(object):
    r"""Proxy of C++ itkPyVectorContainerUCUC class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCUC *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCUC__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCUC_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCUC__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCUC
        __init__(self, arg0) -> itkPyVectorContainerUCUC

        Parameters
        ----------
        arg0: itkPyVectorContainerUCUC const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCUC_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCUC(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCUC


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UC"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCUC._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCUC.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCUC._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCUC in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCUC_swigregister(itkPyVectorContainerUCUC)
class itkPyVectorContainerUCUI(object):
    r"""Proxy of C++ itkPyVectorContainerUCUI class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCUI *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCUI__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCUI_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCUI__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCUI
        __init__(self, arg0) -> itkPyVectorContainerUCUI

        Parameters
        ----------
        arg0: itkPyVectorContainerUCUI const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCUI_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCUI(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCUI


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UI"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCUI._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCUI.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCUI._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCUI in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCUI_swigregister(itkPyVectorContainerUCUI)
class itkPyVectorContainerUCUL(object):
    r"""Proxy of C++ itkPyVectorContainerUCUL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCUL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCUL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCUL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCUL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCUL
        __init__(self, arg0) -> itkPyVectorContainerUCUL

        Parameters
        ----------
        arg0: itkPyVectorContainerUCUL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCUL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCUL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCUL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCUL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCUL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCUL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCUL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCUL_swigregister(itkPyVectorContainerUCUL)
class itkPyVectorContainerUCULL(object):
    r"""Proxy of C++ itkPyVectorContainerUCULL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCULL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCULL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCULL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCULL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCULL
        __init__(self, arg0) -> itkPyVectorContainerUCULL

        Parameters
        ----------
        arg0: itkPyVectorContainerUCULL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCULL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCULL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCULL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "ULL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCULL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCULL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCULL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCULL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCULL_swigregister(itkPyVectorContainerUCULL)
class itkPyVectorContainerUCUS(object):
    r"""Proxy of C++ itkPyVectorContainerUCUS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUCUS *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCUS__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUCUS_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUCUS__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUCUS
        __init__(self, arg0) -> itkPyVectorContainerUCUS

        Parameters
        ----------
        arg0: itkPyVectorContainerUCUS const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUCUS_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUCUS(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUCUS


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "US"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUCUS._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUCUS.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUCUS._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUCUS in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUCUS_swigregister(itkPyVectorContainerUCUS)
class itkPyVectorContainerUICID2(object):
    r"""Proxy of C++ itkPyVectorContainerUICID2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUICID2 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUICID2__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUICID2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUICID2__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUICID2
        __init__(self, arg0) -> itkPyVectorContainerUICID2

        Parameters
        ----------
        arg0: itkPyVectorContainerUICID2 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUICID2_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUICID2(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUICID2


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUICID2._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUICID2.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUICID2._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUICID2 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUICID2_swigregister(itkPyVectorContainerUICID2)
class itkPyVectorContainerUICID3(object):
    r"""Proxy of C++ itkPyVectorContainerUICID3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUICID3 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUICID3__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUICID3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUICID3__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUICID3
        __init__(self, arg0) -> itkPyVectorContainerUICID3

        Parameters
        ----------
        arg0: itkPyVectorContainerUICID3 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUICID3_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUICID3(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUICID3


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUICID3._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUICID3.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUICID3._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUICID3 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUICID3_swigregister(itkPyVectorContainerUICID3)
class itkPyVectorContainerUICID4(object):
    r"""Proxy of C++ itkPyVectorContainerUICID4 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUICID4 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUICID4__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUICID4_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUICID4__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUICID4
        __init__(self, arg0) -> itkPyVectorContainerUICID4

        Parameters
        ----------
        arg0: itkPyVectorContainerUICID4 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUICID4_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUICID4(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUICID4


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUICID4._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUICID4.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUICID4._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUICID4 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUICID4_swigregister(itkPyVectorContainerUICID4)
class itkPyVectorContainerUIUC(object):
    r"""Proxy of C++ itkPyVectorContainerUIUC class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUIUC *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIUC__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUIUC_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIUC__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUIUC
        __init__(self, arg0) -> itkPyVectorContainerUIUC

        Parameters
        ----------
        arg0: itkPyVectorContainerUIUC const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUIUC_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUIUC(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUIUC


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UC"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUIUC._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUIUC.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUIUC._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUIUC in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUIUC_swigregister(itkPyVectorContainerUIUC)
class itkPyVectorContainerUIUI(object):
    r"""Proxy of C++ itkPyVectorContainerUIUI class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUIUI *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIUI__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUIUI_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIUI__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUIUI
        __init__(self, arg0) -> itkPyVectorContainerUIUI

        Parameters
        ----------
        arg0: itkPyVectorContainerUIUI const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUIUI_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUIUI(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUIUI


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UI"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUIUI._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUIUI.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUIUI._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUIUI in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUIUI_swigregister(itkPyVectorContainerUIUI)
class itkPyVectorContainerUIUL(object):
    r"""Proxy of C++ itkPyVectorContainerUIUL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUIUL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIUL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUIUL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIUL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUIUL
        __init__(self, arg0) -> itkPyVectorContainerUIUL

        Parameters
        ----------
        arg0: itkPyVectorContainerUIUL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUIUL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUIUL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUIUL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUIUL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUIUL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUIUL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUIUL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUIUL_swigregister(itkPyVectorContainerUIUL)
class itkPyVectorContainerUIULL(object):
    r"""Proxy of C++ itkPyVectorContainerUIULL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUIULL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIULL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUIULL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIULL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUIULL
        __init__(self, arg0) -> itkPyVectorContainerUIULL

        Parameters
        ----------
        arg0: itkPyVectorContainerUIULL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUIULL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUIULL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUIULL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "ULL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUIULL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUIULL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUIULL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUIULL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUIULL_swigregister(itkPyVectorContainerUIULL)
class itkPyVectorContainerUIUS(object):
    r"""Proxy of C++ itkPyVectorContainerUIUS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUIUS *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIUS__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUIUS_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIUS__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUIUS
        __init__(self, arg0) -> itkPyVectorContainerUIUS

        Parameters
        ----------
        arg0: itkPyVectorContainerUIUS const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUIUS_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUIUS(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUIUS


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "US"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUIUS._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUIUS.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUIUS._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUIUS in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUIUS_swigregister(itkPyVectorContainerUIUS)
class itkPyVectorContainerUIVUC1(object):
    r"""Proxy of C++ itkPyVectorContainerUIVUC1 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUIVUC1 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIVUC1__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUIVUC1_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUIVUC1__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUIVUC1
        __init__(self, arg0) -> itkPyVectorContainerUIVUC1

        Parameters
        ----------
        arg0: itkPyVectorContainerUIVUC1 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUIVUC1_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUIVUC1(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUIVUC1


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UC"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUIVUC1._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUIVUC1.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUIVUC1._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUIVUC1 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUIVUC1_swigregister(itkPyVectorContainerUIVUC1)
class itkPyVectorContainerULD(object):
    r"""Proxy of C++ itkPyVectorContainerULD class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULD *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULD__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULD_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULD__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULD
        __init__(self, arg0) -> itkPyVectorContainerULD

        Parameters
        ----------
        arg0: itkPyVectorContainerULD const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULD_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULD(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULD


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULD._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULD.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULD._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULD in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULD_swigregister(itkPyVectorContainerULD)
class itkPyVectorContainerULF(object):
    r"""Proxy of C++ itkPyVectorContainerULF class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULF *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULF__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULF_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULF__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULF
        __init__(self, arg0) -> itkPyVectorContainerULF

        Parameters
        ----------
        arg0: itkPyVectorContainerULF const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULF_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULF(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULF


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULF._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULF.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULF._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULF in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULF_swigregister(itkPyVectorContainerULF)
class itkPyVectorContainerULLUC(object):
    r"""Proxy of C++ itkPyVectorContainerULLUC class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULLUC *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULLUC__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULLUC_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULLUC__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULLUC
        __init__(self, arg0) -> itkPyVectorContainerULLUC

        Parameters
        ----------
        arg0: itkPyVectorContainerULLUC const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULLUC_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULLUC(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULLUC


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UC"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULLUC._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULLUC.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULLUC._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULLUC in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULLUC_swigregister(itkPyVectorContainerULLUC)
class itkPyVectorContainerULLUI(object):
    r"""Proxy of C++ itkPyVectorContainerULLUI class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULLUI *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULLUI__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULLUI_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULLUI__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULLUI
        __init__(self, arg0) -> itkPyVectorContainerULLUI

        Parameters
        ----------
        arg0: itkPyVectorContainerULLUI const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULLUI_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULLUI(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULLUI


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UI"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULLUI._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULLUI.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULLUI._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULLUI in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULLUI_swigregister(itkPyVectorContainerULLUI)
class itkPyVectorContainerULLUL(object):
    r"""Proxy of C++ itkPyVectorContainerULLUL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULLUL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULLUL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULLUL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULLUL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULLUL
        __init__(self, arg0) -> itkPyVectorContainerULLUL

        Parameters
        ----------
        arg0: itkPyVectorContainerULLUL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULLUL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULLUL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULLUL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULLUL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULLUL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULLUL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULLUL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULLUL_swigregister(itkPyVectorContainerULLUL)
class itkPyVectorContainerULLULL(object):
    r"""Proxy of C++ itkPyVectorContainerULLULL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULLULL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULLULL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULLULL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULLULL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULLULL
        __init__(self, arg0) -> itkPyVectorContainerULLULL

        Parameters
        ----------
        arg0: itkPyVectorContainerULLULL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULLULL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULLULL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULLULL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "ULL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULLULL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULLULL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULLULL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULLULL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULLULL_swigregister(itkPyVectorContainerULLULL)
class itkPyVectorContainerULLUS(object):
    r"""Proxy of C++ itkPyVectorContainerULLUS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULLUS *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULLUS__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULLUS_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULLUS__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULLUS
        __init__(self, arg0) -> itkPyVectorContainerULLUS

        Parameters
        ----------
        arg0: itkPyVectorContainerULLUS const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULLUS_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULLUS(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULLUS


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "US"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULLUS._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULLUS.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULLUS._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULLUS in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULLUS_swigregister(itkPyVectorContainerULLUS)
class itkPyVectorContainerULMD22(object):
    r"""Proxy of C++ itkPyVectorContainerULMD22 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULMD22 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMD22__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULMD22_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMD22__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULMD22
        __init__(self, arg0) -> itkPyVectorContainerULMD22

        Parameters
        ----------
        arg0: itkPyVectorContainerULMD22 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULMD22_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULMD22(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULMD22


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULMD22._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULMD22.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULMD22._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULMD22 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULMD22_swigregister(itkPyVectorContainerULMD22)
class itkPyVectorContainerULMD33(object):
    r"""Proxy of C++ itkPyVectorContainerULMD33 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULMD33 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMD33__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULMD33_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMD33__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULMD33
        __init__(self, arg0) -> itkPyVectorContainerULMD33

        Parameters
        ----------
        arg0: itkPyVectorContainerULMD33 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULMD33_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULMD33(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULMD33


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULMD33._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULMD33.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULMD33._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULMD33 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULMD33_swigregister(itkPyVectorContainerULMD33)
class itkPyVectorContainerULMD44(object):
    r"""Proxy of C++ itkPyVectorContainerULMD44 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULMD44 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMD44__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULMD44_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMD44__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULMD44
        __init__(self, arg0) -> itkPyVectorContainerULMD44

        Parameters
        ----------
        arg0: itkPyVectorContainerULMD44 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULMD44_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULMD44(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULMD44


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULMD44._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULMD44.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULMD44._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULMD44 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULMD44_swigregister(itkPyVectorContainerULMD44)
class itkPyVectorContainerULMF22(object):
    r"""Proxy of C++ itkPyVectorContainerULMF22 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULMF22 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMF22__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULMF22_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMF22__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULMF22
        __init__(self, arg0) -> itkPyVectorContainerULMF22

        Parameters
        ----------
        arg0: itkPyVectorContainerULMF22 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULMF22_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULMF22(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULMF22


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULMF22._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULMF22.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULMF22._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULMF22 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULMF22_swigregister(itkPyVectorContainerULMF22)
class itkPyVectorContainerULMF33(object):
    r"""Proxy of C++ itkPyVectorContainerULMF33 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULMF33 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMF33__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULMF33_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMF33__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULMF33
        __init__(self, arg0) -> itkPyVectorContainerULMF33

        Parameters
        ----------
        arg0: itkPyVectorContainerULMF33 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULMF33_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULMF33(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULMF33


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULMF33._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULMF33.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULMF33._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULMF33 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULMF33_swigregister(itkPyVectorContainerULMF33)
class itkPyVectorContainerULMF44(object):
    r"""Proxy of C++ itkPyVectorContainerULMF44 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULMF44 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMF44__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULMF44_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULMF44__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULMF44
        __init__(self, arg0) -> itkPyVectorContainerULMF44

        Parameters
        ----------
        arg0: itkPyVectorContainerULMF44 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULMF44_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULMF44(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULMF44


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULMF44._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULMF44.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULMF44._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULMF44 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULMF44_swigregister(itkPyVectorContainerULMF44)
class itkPyVectorContainerULPD2(object):
    r"""Proxy of C++ itkPyVectorContainerULPD2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULPD2 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPD2__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULPD2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPD2__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULPD2
        __init__(self, arg0) -> itkPyVectorContainerULPD2

        Parameters
        ----------
        arg0: itkPyVectorContainerULPD2 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULPD2_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULPD2(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULPD2


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULPD2._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULPD2.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULPD2._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULPD2 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULPD2_swigregister(itkPyVectorContainerULPD2)
class itkPyVectorContainerULPD3(object):
    r"""Proxy of C++ itkPyVectorContainerULPD3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULPD3 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPD3__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULPD3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPD3__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULPD3
        __init__(self, arg0) -> itkPyVectorContainerULPD3

        Parameters
        ----------
        arg0: itkPyVectorContainerULPD3 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULPD3_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULPD3(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULPD3


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULPD3._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULPD3.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULPD3._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULPD3 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULPD3_swigregister(itkPyVectorContainerULPD3)
class itkPyVectorContainerULPD4(object):
    r"""Proxy of C++ itkPyVectorContainerULPD4 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULPD4 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPD4__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULPD4_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPD4__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULPD4
        __init__(self, arg0) -> itkPyVectorContainerULPD4

        Parameters
        ----------
        arg0: itkPyVectorContainerULPD4 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULPD4_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULPD4(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULPD4


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULPD4._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULPD4.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULPD4._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULPD4 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULPD4_swigregister(itkPyVectorContainerULPD4)
class itkPyVectorContainerULPF2(object):
    r"""Proxy of C++ itkPyVectorContainerULPF2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULPF2 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPF2__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULPF2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPF2__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULPF2
        __init__(self, arg0) -> itkPyVectorContainerULPF2

        Parameters
        ----------
        arg0: itkPyVectorContainerULPF2 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULPF2_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULPF2(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULPF2


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULPF2._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULPF2.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULPF2._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULPF2 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULPF2_swigregister(itkPyVectorContainerULPF2)
class itkPyVectorContainerULPF3(object):
    r"""Proxy of C++ itkPyVectorContainerULPF3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULPF3 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPF3__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULPF3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPF3__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULPF3
        __init__(self, arg0) -> itkPyVectorContainerULPF3

        Parameters
        ----------
        arg0: itkPyVectorContainerULPF3 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULPF3_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULPF3(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULPF3


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULPF3._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULPF3.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULPF3._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULPF3 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULPF3_swigregister(itkPyVectorContainerULPF3)
class itkPyVectorContainerULPF4(object):
    r"""Proxy of C++ itkPyVectorContainerULPF4 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULPF4 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPF4__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULPF4_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULPF4__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULPF4
        __init__(self, arg0) -> itkPyVectorContainerULPF4

        Parameters
        ----------
        arg0: itkPyVectorContainerULPF4 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULPF4_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULPF4(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULPF4


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULPF4._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULPF4.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULPF4._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULPF4 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULPF4_swigregister(itkPyVectorContainerULPF4)
class itkPyVectorContainerULSC(object):
    r"""Proxy of C++ itkPyVectorContainerULSC class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULSC *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULSC__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULSC_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULSC__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULSC
        __init__(self, arg0) -> itkPyVectorContainerULSC

        Parameters
        ----------
        arg0: itkPyVectorContainerULSC const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULSC_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULSC(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULSC


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "SC"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULSC._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULSC.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULSC._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULSC in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULSC_swigregister(itkPyVectorContainerULSC)
class itkPyVectorContainerULSS(object):
    r"""Proxy of C++ itkPyVectorContainerULSS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULSS *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULSS__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULSS_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULSS__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULSS
        __init__(self, arg0) -> itkPyVectorContainerULSS

        Parameters
        ----------
        arg0: itkPyVectorContainerULSS const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULSS_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULSS(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULSS


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "SS"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULSS._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULSS.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULSS._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULSS in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULSS_swigregister(itkPyVectorContainerULSS)
class itkPyVectorContainerULSUL(object):
    r"""Proxy of C++ itkPyVectorContainerULSUL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULSUL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULSUL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULSUL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULSUL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULSUL
        __init__(self, arg0) -> itkPyVectorContainerULSUL

        Parameters
        ----------
        arg0: itkPyVectorContainerULSUL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULSUL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULSUL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULSUL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "IT"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULSUL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULSUL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULSUL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULSUL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULSUL_swigregister(itkPyVectorContainerULSUL)
class itkPyVectorContainerULUC(object):
    r"""Proxy of C++ itkPyVectorContainerULUC class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULUC *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULUC__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULUC_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULUC__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULUC
        __init__(self, arg0) -> itkPyVectorContainerULUC

        Parameters
        ----------
        arg0: itkPyVectorContainerULUC const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULUC_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULUC(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULUC


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UC"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULUC._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULUC.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULUC._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULUC in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULUC_swigregister(itkPyVectorContainerULUC)
class itkPyVectorContainerULUI(object):
    r"""Proxy of C++ itkPyVectorContainerULUI class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULUI *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULUI__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULUI_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULUI__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULUI
        __init__(self, arg0) -> itkPyVectorContainerULUI

        Parameters
        ----------
        arg0: itkPyVectorContainerULUI const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULUI_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULUI(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULUI


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UI"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULUI._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULUI.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULUI._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULUI in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULUI_swigregister(itkPyVectorContainerULUI)
class itkPyVectorContainerULUL(object):
    r"""Proxy of C++ itkPyVectorContainerULUL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULUL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULUL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULUL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULUL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULUL
        __init__(self, arg0) -> itkPyVectorContainerULUL

        Parameters
        ----------
        arg0: itkPyVectorContainerULUL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULUL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULUL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULUL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULUL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULUL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULUL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULUL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULUL_swigregister(itkPyVectorContainerULUL)
class itkPyVectorContainerULULL(object):
    r"""Proxy of C++ itkPyVectorContainerULULL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULULL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULULL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULULL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULULL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULULL
        __init__(self, arg0) -> itkPyVectorContainerULULL

        Parameters
        ----------
        arg0: itkPyVectorContainerULULL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULULL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULULL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULULL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "ULL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULULL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULULL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULULL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULULL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULULL_swigregister(itkPyVectorContainerULULL)
class itkPyVectorContainerULUS(object):
    r"""Proxy of C++ itkPyVectorContainerULUS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULUS *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULUS__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULUS_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULUS__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULUS
        __init__(self, arg0) -> itkPyVectorContainerULUS

        Parameters
        ----------
        arg0: itkPyVectorContainerULUS const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULUS_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULUS(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULUS


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "US"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULUS._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULUS.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULUS._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULUS in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULUS_swigregister(itkPyVectorContainerULUS)
class itkPyVectorContainerULVD2(object):
    r"""Proxy of C++ itkPyVectorContainerULVD2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULVD2 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVD2__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULVD2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVD2__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULVD2
        __init__(self, arg0) -> itkPyVectorContainerULVD2

        Parameters
        ----------
        arg0: itkPyVectorContainerULVD2 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULVD2_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULVD2(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULVD2


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULVD2._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULVD2.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULVD2._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULVD2 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULVD2_swigregister(itkPyVectorContainerULVD2)
class itkPyVectorContainerULVD3(object):
    r"""Proxy of C++ itkPyVectorContainerULVD3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULVD3 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVD3__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULVD3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVD3__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULVD3
        __init__(self, arg0) -> itkPyVectorContainerULVD3

        Parameters
        ----------
        arg0: itkPyVectorContainerULVD3 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULVD3_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULVD3(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULVD3


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULVD3._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULVD3.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULVD3._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULVD3 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULVD3_swigregister(itkPyVectorContainerULVD3)
class itkPyVectorContainerULVD4(object):
    r"""Proxy of C++ itkPyVectorContainerULVD4 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULVD4 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVD4__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULVD4_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVD4__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULVD4
        __init__(self, arg0) -> itkPyVectorContainerULVD4

        Parameters
        ----------
        arg0: itkPyVectorContainerULVD4 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULVD4_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULVD4(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULVD4


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "D"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULVD4._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULVD4.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULVD4._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULVD4 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULVD4_swigregister(itkPyVectorContainerULVD4)
class itkPyVectorContainerULVF2(object):
    r"""Proxy of C++ itkPyVectorContainerULVF2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULVF2 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVF2__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULVF2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVF2__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULVF2
        __init__(self, arg0) -> itkPyVectorContainerULVF2

        Parameters
        ----------
        arg0: itkPyVectorContainerULVF2 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULVF2_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULVF2(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULVF2


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULVF2._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULVF2.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULVF2._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULVF2 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULVF2_swigregister(itkPyVectorContainerULVF2)
class itkPyVectorContainerULVF3(object):
    r"""Proxy of C++ itkPyVectorContainerULVF3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULVF3 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVF3__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULVF3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVF3__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULVF3
        __init__(self, arg0) -> itkPyVectorContainerULVF3

        Parameters
        ----------
        arg0: itkPyVectorContainerULVF3 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULVF3_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULVF3(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULVF3


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULVF3._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULVF3.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULVF3._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULVF3 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULVF3_swigregister(itkPyVectorContainerULVF3)
class itkPyVectorContainerULVF4(object):
    r"""Proxy of C++ itkPyVectorContainerULVF4 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerULVF4 *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVF4__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerULVF4_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerULVF4__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerULVF4
        __init__(self, arg0) -> itkPyVectorContainerULVF4

        Parameters
        ----------
        arg0: itkPyVectorContainerULVF4 const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerULVF4_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerULVF4(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerULVF4


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "F"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerULVF4._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerULVF4.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerULVF4._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerULVF4 in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerULVF4_swigregister(itkPyVectorContainerULVF4)
class itkPyVectorContainerUSUC(object):
    r"""Proxy of C++ itkPyVectorContainerUSUC class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUSUC *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUSUC__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUSUC_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUSUC__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUSUC
        __init__(self, arg0) -> itkPyVectorContainerUSUC

        Parameters
        ----------
        arg0: itkPyVectorContainerUSUC const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUSUC_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUSUC(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUSUC


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UC"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUSUC._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUSUC.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUSUC._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUSUC in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUSUC_swigregister(itkPyVectorContainerUSUC)
class itkPyVectorContainerUSUI(object):
    r"""Proxy of C++ itkPyVectorContainerUSUI class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUSUI *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUSUI__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUSUI_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUSUI__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUSUI
        __init__(self, arg0) -> itkPyVectorContainerUSUI

        Parameters
        ----------
        arg0: itkPyVectorContainerUSUI const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUSUI_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUSUI(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUSUI


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UI"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUSUI._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUSUI.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUSUI._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUSUI in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUSUI_swigregister(itkPyVectorContainerUSUI)
class itkPyVectorContainerUSUL(object):
    r"""Proxy of C++ itkPyVectorContainerUSUL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUSUL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUSUL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUSUL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUSUL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUSUL
        __init__(self, arg0) -> itkPyVectorContainerUSUL

        Parameters
        ----------
        arg0: itkPyVectorContainerUSUL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUSUL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUSUL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUSUL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "UL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUSUL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUSUL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUSUL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUSUL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUSUL_swigregister(itkPyVectorContainerUSUL)
class itkPyVectorContainerUSULL(object):
    r"""Proxy of C++ itkPyVectorContainerUSULL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUSULL *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUSULL__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUSULL_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUSULL__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUSULL
        __init__(self, arg0) -> itkPyVectorContainerUSULL

        Parameters
        ----------
        arg0: itkPyVectorContainerUSULL const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUSULL_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUSULL(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUSULL


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "ULL"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUSULL._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUSULL.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUSULL._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUSULL in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUSULL_swigregister(itkPyVectorContainerUSULL)
class itkPyVectorContainerUSUS(object):
    r"""Proxy of C++ itkPyVectorContainerUSUS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _array_view_from_vector_container(vector):
        r"""
        _array_view_from_vector_container(vector) -> PyObject *

        Parameters
        ----------
        vector: itkVectorContainerUSUS *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUSUS__array_view_from_vector_container(vector)

    @staticmethod
    def _vector_container_from_array(arr, shape):
        r"""
        _vector_container_from_array(arr, shape) -> itkVectorContainerUSUS_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyVectorContainerPython.itkPyVectorContainerUSUS__vector_container_from_array(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVectorContainerUSUS
        __init__(self, arg0) -> itkPyVectorContainerUSUS

        Parameters
        ----------
        arg0: itkPyVectorContainerUSUS const &

        """
        _itkPyVectorContainerPython.itkPyVectorContainerUSUS_swiginit(self, _itkPyVectorContainerPython.new_itkPyVectorContainerUSUS(*args))
    __swig_destroy__ = _itkPyVectorContainerPython.delete_itkPyVectorContainerUSUS


    def array_view_from_vector_container(vector_container):
        """Get a NumPy array view of an itk.VectorContainer.

        Warning: No copy of the data is performed. Using an array
        view after its source vector has been deleted can results in corrupt values
        or a segfault.
        """

        import itk

        itksize = vector_container.Size()
        container_type = itk.template(vector_container)
        if isinstance(container_type[1][1], type):
            container_element_type = itk.template(container_type[1][1])
            dimension = container_element_type[1][1]
            shape   = (itksize, dimension)
        else:
            shape   = (itksize,)

        element_type     = "US"
        numpydatatype = _get_numpy_pixelid(element_type)
        memview       = itkPyVectorContainerUSUS._array_view_from_vector_container(vector_container)
        ndarrview  = np.asarray(memview).view(dtype = numpydatatype).reshape(shape).view(np.ndarray)

        return ndarrview

    array_view_from_vector_container = staticmethod(array_view_from_vector_container)

    def array_from_vector_container(vector_container):
        """Get a NumPy ndarray from an itk.VectorContainer.

        This is a deep copy of the itk.VectorContainer and is completely safe and without potential side effects.
        """

        arrayView = itkPyVectorContainerUSUS.array_view_from_vector_container(vector_container)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    array_from_vector_container = staticmethod(array_from_vector_container)

    def vector_container_from_array(ndarr):
        """Get an itk.VectorContainer from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.
        """

        assert ndarr.ndim == 1 , "Only arrays of 1 dimension are supported."

        vec = itkPyVectorContainerUSUS._vector_container_from_array(ndarr, ndarr.shape)

        return vec

    vector_container_from_array = staticmethod(vector_container_from_array)



# Register itkPyVectorContainerUSUS in _itkPyVectorContainerPython:
_itkPyVectorContainerPython.itkPyVectorContainerUSUS_swigregister(itkPyVectorContainerUSUS)

