﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace PinpointSMSVoiceV2
{
namespace Model
{
  enum class ConflictExceptionReason
  {
    NOT_SET,
    CREATE_REGISTRATION_VERSION_NOT_ALLOWED,
    DELETION_PROTECTION_ENABLED,
    DESTINATION_PHONE_NUMBER_NOT_VERIFIED,
    DESTINATION_PHONE_NUMBER_OPTED_OUT,
    DISASSOCIATE_REGISTRATION_NOT_ALLOWED,
    DISCARD_REGISTRATION_VERSION_NOT_ALLOWED,
    EDIT_REGISTRATION_FIELD_VALUES_NOT_ALLOWED,
    EVENT_DESTINATION_MISMATCH,
    KEYWORD_MISMATCH,
    LAST_PHONE_NUMBER,
    NUMBER_CAPABILITIES_MISMATCH,
    MESSAGE_TYPE_MISMATCH,
    NO_ORIGINATION_IDENTITIES_FOUND,
    OPT_OUT_LIST_MISMATCH,
    PHONE_NUMBER_ASSOCIATED_TO_POOL,
    PHONE_NUMBER_ASSOCIATED_TO_REGISTRATION,
    PHONE_NUMBER_NOT_ASSOCIATED_TO_POOL,
    PHONE_NUMBER_NOT_IN_REGISTRATION_REGION,
    REGISTRATION_ALREADY_SUBMITTED,
    REGISTRATION_NOT_COMPLETE,
    SENDER_ID_ASSOCIATED_TO_POOL,
    RESOURCE_ALREADY_EXISTS,
    RESOURCE_DELETION_NOT_ALLOWED,
    RESOURCE_MODIFICATION_NOT_ALLOWED,
    RESOURCE_NOT_ACTIVE,
    RESOURCE_NOT_EMPTY,
    SELF_MANAGED_OPT_OUTS_MISMATCH,
    SUBMIT_REGISTRATION_VERSION_NOT_ALLOWED,
    TWO_WAY_CONFIG_MISMATCH,
    VERIFICATION_CODE_EXPIRED,
    VERIFICATION_ALREADY_COMPLETE,
    PROTECT_CONFIGURATION_IS_ACCOUNT_DEFAULT,
    PROTECT_CONFIGURATION_ASSOCIATED_WITH_CONFIGURATION_SET,
    PROTECT_CONFIGURATION_NOT_ASSOCIATED_WITH_CONFIGURATION_SET,
    DESTINATION_COUNTRY_BLOCKED_BY_PROTECT_CONFIGURATION,
    DESTINATION_PHONE_NUMBER_BLOCKED_BY_PROTECT_NUMBER_OVERRIDE
  };

namespace ConflictExceptionReasonMapper
{
AWS_PINPOINTSMSVOICEV2_API ConflictExceptionReason GetConflictExceptionReasonForName(const Aws::String& name);

AWS_PINPOINTSMSVOICEV2_API Aws::String GetNameForConflictExceptionReason(ConflictExceptionReason value);
} // namespace ConflictExceptionReasonMapper
} // namespace Model
} // namespace PinpointSMSVoiceV2
} // namespace Aws
