﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/medialive/MediaLiveRequest.h>
#include <aws/medialive/MediaLive_EXPORTS.h>

#include <utility>

namespace Aws {
namespace MediaLive {
namespace Model {

/**
 * Placeholder documentation for RejectInputDeviceTransferRequest<p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RejectInputDeviceTransferRequest">AWS
 * API Reference</a></p>
 */
class RejectInputDeviceTransferRequest : public MediaLiveRequest {
 public:
  AWS_MEDIALIVE_API RejectInputDeviceTransferRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "RejectInputDeviceTransfer"; }

  AWS_MEDIALIVE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * The unique ID of the input device to reject. For example, hd-123456789abcdef.
   */
  inline const Aws::String& GetInputDeviceId() const { return m_inputDeviceId; }
  inline bool InputDeviceIdHasBeenSet() const { return m_inputDeviceIdHasBeenSet; }
  template <typename InputDeviceIdT = Aws::String>
  void SetInputDeviceId(InputDeviceIdT&& value) {
    m_inputDeviceIdHasBeenSet = true;
    m_inputDeviceId = std::forward<InputDeviceIdT>(value);
  }
  template <typename InputDeviceIdT = Aws::String>
  RejectInputDeviceTransferRequest& WithInputDeviceId(InputDeviceIdT&& value) {
    SetInputDeviceId(std::forward<InputDeviceIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_inputDeviceId;
  bool m_inputDeviceIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaLive
}  // namespace Aws
