/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.multislider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jdesktop.swingx.multislider.AbstractMultiThumbModel;
import org.jdesktop.swingx.multislider.MultiThumbModel;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMultiThumbModel<E>
extends AbstractMultiThumbModel<E>
implements MultiThumbModel<E> {
    protected List<Thumb<E>> thumbs = new ArrayList<Thumb<E>>();

    public DefaultMultiThumbModel() {
        this.setMinimumValue(0.0f);
        this.setMaximumValue(1.0f);
    }

    @Override
    public int addThumb(float value, E obj) {
        Thumb<E> thumb = new Thumb<E>(this);
        thumb.setPosition(value);
        thumb.setObject(obj);
        this.thumbs.add(thumb);
        int n = this.thumbs.size();
        ThumbDataEvent evt = new ThumbDataEvent(this, -1, this.thumbs.size() - 1, thumb);
        for (ThumbDataListener tdl : this.thumbDataListeners) {
            tdl.thumbAdded(evt);
        }
        return n - 1;
    }

    @Override
    public void insertThumb(float value, E obj, int index) {
        Thumb<E> thumb = new Thumb<E>(this);
        thumb.setPosition(value);
        thumb.setObject(obj);
        this.thumbs.add(index, thumb);
        ThumbDataEvent evt = new ThumbDataEvent(this, -1, index, thumb);
        for (ThumbDataListener tdl : this.thumbDataListeners) {
            tdl.thumbAdded(evt);
        }
    }

    @Override
    public void removeThumb(int index) {
        Thumb<E> thumb = this.thumbs.remove(index);
        ThumbDataEvent evt = new ThumbDataEvent(this, -1, index, thumb);
        for (ThumbDataListener tdl : this.thumbDataListeners) {
            tdl.thumbRemoved(evt);
        }
    }

    @Override
    public int getThumbCount() {
        return this.thumbs.size();
    }

    @Override
    public Thumb<E> getThumbAt(int index) {
        return this.thumbs.get(index);
    }

    @Override
    public List<Thumb<E>> getSortedThumbs() {
        ArrayList<Thumb<Thumb<E>>> list = new ArrayList<Thumb<Thumb<E>>>();
        list.addAll(this.thumbs);
        Collections.sort(list, new Comparator<Thumb<E>>(){

            @Override
            public int compare(Thumb<E> o1, Thumb<E> o2) {
                float f2;
                float f1 = o1.getPosition();
                if (f1 < (f2 = o2.getPosition())) {
                    return -1;
                }
                if (f1 > f2) {
                    return 1;
                }
                return 0;
            }
        });
        return list;
    }

    @Override
    public Iterator<Thumb<E>> iterator() {
        return this.thumbs.iterator();
    }

    @Override
    public int getThumbIndex(Thumb<E> thumb) {
        return this.thumbs.indexOf(thumb);
    }
}

